/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.CommsServerByteBuffer;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.IdToTransactionTable;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;

public class CATBifurcatedConsumer
extends CATConsumer {
    private static String CLASS_NAME = CATBifurcatedConsumer.class.getName();
    private static final TraceComponent tc = SibTr.register(CATBifurcatedConsumer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private final CATMainConsumer mainConsumer;
    private BifurcatedConsumerSession bifSession = null;

    public CATBifurcatedConsumer(CATMainConsumer mainConsumer, BifurcatedConsumerSession bifSession) {
        this.mainConsumer = mainConsumer;
        this.bifSession = bifSession;
    }

    @Override
    protected ConsumerSession getConsumerSession() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSession");
        }
        ConsumerSession sess = this.mainConsumer.getConsumerSession();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSession", (Object)sess);
        }
        return sess;
    }

    @Override
    protected Conversation getConversation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversation");
        }
        Conversation conv = this.mainConsumer.getConversation();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversation", (Object)conv);
        }
        return conv;
    }

    @Override
    protected int getLowestPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLowestPriority");
        }
        int lowestPri = this.mainConsumer.getLowestPriority();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLowestPriority", (Object)lowestPri);
        }
        return lowestPri;
    }

    @Override
    protected short getClientSessionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getClientSessionId");
        }
        short sessId = this.mainConsumer.getClientSessionId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getClientSessionId");
        }
        return sessId;
    }

    @Override
    protected Reliability getUnrecoverableReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUnrecoverableReliability");
        }
        Reliability rel = this.mainConsumer.getUnrecoverableReliability();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUnrecoverableReliability");
        }
        return rel;
    }

    @Override
    public void close(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)requestNumber);
        }
        try {
            this.bifSession.close();
            try {
                this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 201, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".close"), (String)"3-025-0012", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2033", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".close"), (String)"3-025-0013", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-025-0013", this.getConversation(), requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    @Override
    public void readSet(int requestNumber, SIMessageHandle[] msgHandles) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readSet", (Object)new Object[]{requestNumber, msgHandles});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request to read " + msgHandles.length + " message(s)"));
        }
        ConversationState convState = (ConversationState)this.getConversation().getAttachment();
        try {
            SIBusMessage[] messages = this.bifSession.readSet(msgHandles);
            CommsServerByteBuffer buff = poolManager.allocate();
            buff.putInt(messages.length);
            for (int x = 0; x < messages.length; ++x) {
                buff.putMessage((JsMessage)messages[x], convState.getCommsConnection(), this.getConversation());
            }
            try {
                this.getConversation().send((JFapByteBuffer)buff, 234, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".readSet"), (String)"3-025-0007", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2033", (Object)((Object)e));
            }
        }
        catch (Exception e) {
            if (!(e instanceof SIException) || !convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".readSet"), (String)"3-025-0008", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-025-0008", this.getConversation(), requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readSet");
        }
    }

    @Override
    public void readAndDeleteSet(int requestNumber, SIMessageHandle[] msgHandles, int tran) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readAndDeleteSet", (Object)new Object[]{requestNumber, msgHandles, tran});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request to read / delete " + msgHandles.length + " message(s)"));
        }
        ConversationState convState = (ConversationState)this.getConversation().getAttachment();
        try {
            SITransaction siTran = null;
            if (tran != 0) {
                siTran = ((ServerLinkLevelState)this.getConversation().getLinkLevelAttachment()).getTransactionTable().get(tran);
            }
            SIBusMessage[] messages = siTran != IdToTransactionTable.INVALID_TRANSACTION ? this.bifSession.readAndDeleteSet(msgHandles, siTran) : new SIBusMessage[]{};
            CommsServerByteBuffer buff = poolManager.allocate();
            buff.putInt(messages.length);
            for (int x = 0; x < messages.length; ++x) {
                buff.putMessage((JsMessage)messages[x], convState.getCommsConnection(), this.getConversation());
            }
            try {
                this.getConversation().send((JFapByteBuffer)buff, 235, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".readAndDeleteSet"), (String)"3-025-0009", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2033", (Object)((Object)e));
            }
        }
        catch (Exception e) {
            if (!(e instanceof SIException) || !convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".readAndDeleteSet"), (String)"3-025-0010", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-025-0010", this.getConversation(), requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readAndDeleteSet");
        }
    }

    @Override
    public void unlockSet(int requestNumber, SIMessageHandle[] msgHandles, boolean reply) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockSet", (Object)new Object[]{requestNumber, msgHandles, reply});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request to unlock " + msgHandles.length + " message(s)"));
            if (reply) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"The client is expecting a reply");
            }
        }
        try {
            this.bifSession.unlockSet(msgHandles);
            if (reply) {
                try {
                    this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 233, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-025-0005", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2033", (Object)((Object)e));
                }
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-025-0006", (Object)this);
            }
            if (reply) {
                StaticCATHelper.sendExceptionToClient(e, "3-025-0006", this.getConversation(), requestNumber);
            }
            SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_UNLOCK_MSGS_SICO2032", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockSet");
        }
    }

    @Override
    public void unlockSet(int requestNumber, SIMessageHandle[] msgHandles, boolean reply, boolean incrementLockCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockSet", (Object)new Object[]{requestNumber, msgHandles, reply, incrementLockCount});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request to unlock " + msgHandles.length + " message(s)"));
            if (reply) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"The client is expecting a reply");
            }
        }
        try {
            this.bifSession.unlockSet(msgHandles, incrementLockCount);
            if (reply) {
                try {
                    this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 233, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-025-0015", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2033", (Object)((Object)e));
                }
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".unlockSet"), (String)"3-025-0014", (Object)this);
            }
            if (reply) {
                StaticCATHelper.sendExceptionToClient(e, "3-025-0014", this.getConversation(), requestNumber);
            }
            SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_UNLOCK_MSGS_SICO2032", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockSet");
        }
    }

    @Override
    public void deleteSet(int requestNumber, SIMessageHandle[] msgHandles, int tran, boolean reply) {
        block15: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteSet", (Object)new Object[]{requestNumber, msgHandles, tran, reply});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request to delete " + msgHandles.length + " message(s)"));
                if (reply) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Client is expecting a reply");
                }
            }
            try {
                SITransaction siTran = null;
                if (tran != 0) {
                    siTran = ((ServerLinkLevelState)this.getConversation().getLinkLevelAttachment()).getTransactionTable().get(tran);
                }
                if (siTran != IdToTransactionTable.INVALID_TRANSACTION) {
                    this.bifSession.deleteSet(msgHandles, siTran);
                }
                try {
                    if (reply) {
                        this.getConversation().send((JFapByteBuffer)poolManager.allocate(), 219, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                    }
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".deleteSet"), (String)"3-025-0001", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2033", (Object)((Object)e));
                }
            }
            catch (SIException e) {
                if (!((ConversationState)this.getConversation().getAttachment()).hasMETerminated()) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".deleteSet"), (String)"3-025-0002", (Object)this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                if (reply) {
                    StaticCATHelper.sendExceptionToClient(e, "3-025-0003", this.getConversation(), requestNumber);
                }
                SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_DELETE_MSGS_SICO2034", (Object)((Object)e));
                if (tran == 0) break block15;
                ((ServerLinkLevelState)this.getConversation().getLinkLevelAttachment()).getTransactionTable().markAsRollbackOnly(tran, e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteSet");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATBifurcatedConsumer.java, SIB.comms, WASX.SIB, aa1225.01 1.28");
        }
    }
}

