/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATProxyConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;

public class CATAsynchReadAheadReader
implements AsynchConsumerCallback {
    private static String CLASS_NAME = CATAsynchReadAheadReader.class.getName();
    private static final TraceComponent tc = SibTr.register(CATAsynchReadAheadReader.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    final CATProxyConsumer consumerSession;
    final CATMainConsumer mainConsumer;

    public CATAsynchReadAheadReader(CATProxyConsumer consumerSession, CATMainConsumer mainConsumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{consumerSession, mainConsumer});
        }
        this.consumerSession = consumerSession;
        this.mainConsumer = mainConsumer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeMessages(LockedMessageEnumeration vEnum) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"consumeMessages", (Object)vEnum);
        }
        this.consumerSession.stateLock.lock();
        try {
            try {
                this.consumerSession.awaitStableState();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (CATConsumer.State.NEW == this.consumerSession.getState()) {
                this.consumerSession.setState(CATConsumer.State.STARTING);
                this.consumerSession.setState(CATConsumer.State.STARTED);
            }
        }
        finally {
            this.consumerSession.stateLock.unlock();
        }
        if (this.mainConsumer.getConversation().getConnectionReference().isClosed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"The connection is closed so we shouldn't consume anymore messages. Consumer Session should be closed soon");
            }
            boolean stopSession = false;
            this.consumerSession.stateLock.lock();
            try {
                while (true) {
                    try {
                        this.consumerSession.awaitStableState();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                CATConsumer.State currentState = this.consumerSession.getState();
                boolean bl = stopSession = CATConsumer.State.STARTING == currentState || CATConsumer.State.STARTED == currentState;
                if (stopSession) {
                    this.consumerSession.setState(CATConsumer.State.STOPPING);
                }
            }
            finally {
                this.consumerSession.stateLock.unlock();
            }
            if (stopSession) {
                this.stopConsumer();
            }
        } else {
            Object xctErrStr = null;
            CATConsumer.State fallback = CATConsumer.State.UNDEFINED;
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Getting next locked message");
                }
                SIBusMessage sibMessage = vEnum.nextLocked();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received message", (Object)sibMessage);
                }
                int msgLen = this.consumerSession.sendMessage(sibMessage);
                if (!CommsUtils.isRecoverable((SIBusMessage)sibMessage, (Reliability)this.consumerSession.getUnrecoverableReliability())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Deleting the message");
                    }
                    vEnum.deleteCurrent(null);
                }
                this.consumerSession.setLowestPriority(JFapChannelConstants.getJFAPPriority((Integer)sibMessage.getPriority()));
                boolean stopConsumer = false;
                this.consumerSession.stateLock.lock();
                try {
                    try {
                        this.consumerSession.awaitStableState();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    boolean bl = stopConsumer = msgLen == 0 || this.consumerSession.updateConsumedBytes(msgLen);
                    if (stopConsumer) {
                        fallback = this.consumerSession.setState(CATConsumer.State.STOPPING);
                    }
                }
                finally {
                    this.consumerSession.stateLock.unlock();
                }
                if (stopConsumer) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stopping consumer session (sent bytes >= requested bytes || msgLen = 0)");
                    }
                    this.stopConsumer();
                    fallback = CATConsumer.State.UNDEFINED;
                }
            }
            catch (Throwable e) {
                ConversationState convState = (ConversationState)this.consumerSession.getConversation().getAttachment();
                if (!(e instanceof SIException) || !convState.hasMETerminated()) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-022-0001", (Object)this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                }
                StaticCATHelper.sendAsyncExceptionToClient(e, "3-022-0001", this.consumerSession.getClientSessionId(), this.consumerSession.getConversation(), 0);
            }
            finally {
                if (CATConsumer.State.UNDEFINED != fallback) {
                    this.consumerSession.setState(fallback);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"consumeMessages");
        }
    }

    public void stopConsumer() {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopConsumer");
            }
            try {
                this.consumerSession.getConsumerSession().stop();
                this.consumerSession.setState(CATConsumer.State.STOPPED);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-022-0002", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unable to stop consumer session due to Throwable: " + t));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopConsumer");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATAsynchReadAheadReader.java, SIB.comms, WASX.SIB, aa1225.01 1.38");
        }
    }
}

