/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.common;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import javax.transaction.xa.XAException;

public class CommsLightTrace {
    private static final String STRING_NULL = "null";
    private static final TraceComponent light_tc = SibTr.register(CommsLightTrace.class, (String)"SIBMessageTraceComms", (String)"com.ibm.ws.sib.comms.CWSICMessages");

    public static void traceMessageId(TraceComponent callersTrace, String action, SIBusMessage message) {
        if (light_tc.isDebugEnabled() || callersTrace.isDebugEnabled()) {
            CommsLightTrace._traceMessageId(callersTrace, action, CommsLightTrace.msgToString(message));
        }
    }

    public static void traceMessageId(TraceComponent callersTrace, String action, AbstractMessage message) {
        if (light_tc.isDebugEnabled() || callersTrace.isDebugEnabled()) {
            CommsLightTrace._traceMessageId(callersTrace, action, CommsLightTrace.msgToString(message));
        }
    }

    private static void _traceMessageId(TraceComponent callersTrace, String action, String messageText) {
        String traceText = action + ": " + messageText;
        if (light_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)light_tc, (String)traceText);
        } else {
            SibTr.debug((TraceComponent)callersTrace, (String)traceText);
        }
    }

    public static void traceMessageIds(TraceComponent callersTrace, String action, SIMessageHandle[] messageHandles) {
        if ((light_tc.isDebugEnabled() || callersTrace.isDebugEnabled()) && messageHandles != null) {
            StringBuffer trcBuffer = new StringBuffer();
            trcBuffer.append(action + ": [");
            for (int i = 0; i < messageHandles.length; ++i) {
                if (i != 0) {
                    trcBuffer.append(",");
                }
                if (messageHandles[i] == null) continue;
                trcBuffer.append(messageHandles[i].getSystemMessageId());
            }
            trcBuffer.append("]");
            if (light_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)light_tc, (String)trcBuffer.toString());
            } else {
                SibTr.debug((TraceComponent)callersTrace, (String)trcBuffer.toString());
            }
        }
    }

    public static void traceTransaction(TraceComponent callersTrace, String action, Object transaction, int commsId, int commsFlags) {
        if (light_tc.isDebugEnabled() || callersTrace.isDebugEnabled()) {
            String traceText = action + ": " + transaction + " CommsId:" + commsId + " CommsFlags:" + commsFlags;
            if (light_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)light_tc, (String)traceText);
            } else {
                SibTr.debug((TraceComponent)callersTrace, (String)traceText);
            }
        }
    }

    public static void traceException(TraceComponent callersTrace, Throwable ex) {
        if (light_tc.isDebugEnabled() || callersTrace.isDebugEnabled()) {
            String xaErrStr = null;
            if (ex instanceof XAException) {
                XAException xaex = (XAException)ex;
                xaErrStr = "XAExceptionErrorCode: " + xaex.errorCode;
            }
            if (light_tc.isDebugEnabled()) {
                if (xaErrStr != null) {
                    SibTr.debug((TraceComponent)light_tc, xaErrStr);
                }
                SibTr.exception((TraceComponent)light_tc, (Throwable)ex);
            } else {
                if (xaErrStr != null) {
                    SibTr.debug((TraceComponent)callersTrace, xaErrStr);
                }
                SibTr.exception((TraceComponent)callersTrace, (Throwable)ex);
            }
        }
    }

    public static String minimalToString(Object object) {
        return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public static String msgToString(SIBusMessage message) {
        if (message == null) {
            return STRING_NULL;
        }
        return message + "[" + message.getSystemMessageId() + "]";
    }

    public static String msgToString(AbstractMessage message) {
        if (message == null) {
            return STRING_NULL;
        }
        if (message instanceof JsMessage) {
            return message + "[" + ((JsMessage)message).getSystemMessageId() + "]";
        }
        return message.toString();
    }
}

