/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.ClassDesc;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.apache.yoko.rmi.impl.ClassBaseDescriptor;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.MARSHAL;

class ClassDescriptor
extends ClassBaseDescriptor {
    private static final Logger logger = Logger.getLogger(ClassDescriptor.class.getName());

    ClassDescriptor(TypeRepository repository) {
        super(Class.class, repository);
    }

    @Override
    Object copyObject(Object orig, CopyState state) {
        state.put(orig, orig);
        return orig;
    }

    @Override
    public Serializable writeReplace(Serializable value) {
        final Class type = (Class)value;
        ClassDesc result = AccessController.doPrivileged(new PrivilegedAction<ClassDesc>(){

            @Override
            public ClassDesc run() {
                try {
                    ClassDesc desc = new ClassDesc();
                    ValueHandler handler = Util.createValueHandler();
                    String repId = handler.getRMIRepositoryID(type);
                    ClassDescriptor.this.getRepidField().set(desc, repId);
                    String codebase = Util.getCodebase((Class)type);
                    ClassDescriptor.this.getCobebaseField().set(desc, codebase);
                    return desc;
                }
                catch (IllegalAccessException ex) {
                    throw (MARSHAL)new MARSHAL("no such field: " + ex).initCause((Throwable)ex);
                }
            }
        });
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("writeReplace %s => %s", value, result));
        }
        return result;
    }
}

