/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bytebuffer.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.WsBBConfigException;
import com.ibm.ws.bytebuffer.internal.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={ByteBufferConfiguration.class}, name="com.ibm.ws.bytebuffer", configurationPid={"com.ibm.ws.bytebuffer"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"service.vendor=IBM"})
public class ByteBufferConfiguration {
    private static final TraceComponent tc = Tr.register(ByteBufferConfiguration.class, (String)"WsByteBuffer", (String)"com.ibm.ws.bytebuffer.internal.resources.ByteBufferMessages");
    private volatile WsByteBufferPoolManager wsbbmgr = null;
    private final AtomicReference<WsByteBufferPoolManager.DirectByteBufferHelper> directByteBufferHelper = new AtomicReference();

    @Activate
    protected void activate(Map<String, Object> configuration) {
        this.modified(configuration);
    }

    @Deactivate
    protected void deactivate() {
        this.wsbbmgr = null;
    }

    @Reference(name="directByteBufferHelper", service=WsByteBufferPoolManager.DirectByteBufferHelper.class, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setDirectByteBufferHelper(WsByteBufferPoolManager.DirectByteBufferHelper helper) {
        this.directByteBufferHelper.set(helper);
    }

    protected void unsetDirectByteBufferHelper(WsByteBufferPoolManager.DirectByteBufferHelper helper) {
        this.directByteBufferHelper.compareAndSet(helper, null);
    }

    public WsByteBufferPoolManager getBufferManager() {
        return this.wsbbmgr;
    }

    public synchronized void modified(Map<String, Object> newConfig) {
        if (null == newConfig) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Processing byte buffer config", (Object[])new Object[]{newConfig});
        }
        if (null == this.wsbbmgr) {
            this.wsbbmgr = this.createBufferManager(newConfig);
        } else {
            this.updateBufferManager(newConfig);
        }
    }

    private WsByteBufferPoolManager createBufferManager(Map<String, Object> config) {
        block21: {
            WsBBConfigException configError;
            block20: {
                configError = null;
                Object oClass = config.get("class");
                if (null != oClass && oClass instanceof String) {
                    Class<?> clazz;
                    block19: {
                        String className = (String)oClass;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Pool class: " + className), (Object[])new Object[0]);
                        }
                        config.remove("class");
                        clazz = null;
                        try {
                            ClassLoader cl = ByteBufferConfiguration.class.getClassLoader();
                            if (null != cl) {
                                clazz = cl.loadClass(className);
                            }
                        }
                        catch (Exception e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("Class load failed using loader: " + e), (Object[])new Object[0]);
                            }
                            try {
                                clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                            }
                            catch (Exception e2) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block19;
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("Class load failed using Class.forName: " + e2), (Object[])new Object[0]);
                            }
                        }
                    }
                    if (null != clazz) {
                        try {
                            Constructor<?> c = clazz.getConstructor(Map.class);
                            return (WsByteBufferPoolManager)c.newInstance(config);
                        }
                        catch (Exception e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("New instance of class " + clazz + " failed: " + e.getCause()), (Object[])new Object[0]);
                            }
                            if (!(e.getCause() instanceof WsBBConfigException)) break block20;
                            configError = (WsBBConfigException)e.getCause();
                        }
                    }
                }
            }
            if (null == configError) {
                try {
                    return new WsByteBufferPoolManagerImpl(this.directByteBufferHelper, config);
                }
                catch (WsBBConfigException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block21;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Error in configuration: " + e), (Object[])new Object[0]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Using default pool class with default config", (Object[])new Object[0]);
        }
        try {
            return new WsByteBufferPoolManagerImpl(this.directByteBufferHelper);
        }
        catch (WsBBConfigException e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".createBufferManager"), (String)"2");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Failure to create buffer manager: " + e), (Object[])new Object[0]);
            }
            return null;
        }
    }

    private void updateBufferManager(Map<String, Object> properties) {
        if (properties.isEmpty()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Ignoring runtime changes to WSBB config; " + properties), (Object[])new Object[0]);
        }
    }
}

