/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.EJBPMICollaborator;
import com.ibm.ws.ejbcontainer.util.PoolDiscardStrategy;
import com.ibm.ws.ejbcontainer.util.PoolImplBase;
import com.ibm.ws.ejbcontainer.util.PoolManagerImpl;
import com.ibm.ws.util.LockFreeIndexedStack;

public final class PoolImplThreadSafe
extends PoolImplBase {
    private static final TraceComponent tc = Tr.register(PoolImplThreadSafe.class, (String)"EJBContainer", null);
    private static final int DrainAggressivenessPercentage = 20;
    private static final SizeData DISABLED_SIZE = new SizeData();
    protected volatile SizeData poolSize = DISABLED_SIZE;
    private final LockFreeIndexedStack<Object> buffer = new LockFreeIndexedStack();
    private final PoolDiscardStrategy discardStrategy;
    private int ivInactiveNoDrainCount;
    private boolean ivManaged;
    private final EJBPMICollaborator beanPerf;

    PoolImplThreadSafe(int min, int max, EJBPMICollaborator pmiBean, PoolDiscardStrategy d, PoolManagerImpl poolManager) {
        this.setPoolSize(min, max);
        this.discardStrategy = d;
        this.poolMgr = poolManager;
        this.beanPerf = pmiBean;
        if (this.beanPerf != null) {
            this.beanPerf.poolCreated(0);
        }
    }

    private void setPoolSize(int min, int max) {
        SizeData newSize = new SizeData();
        newSize.minSize = min;
        newSize.maxSize = max;
        int drainOpportunity = max - min;
        newSize.maxDrainAmount = drainOpportunity <= 0 ? 0 : (drainOpportunity <= 5 ? drainOpportunity : drainOpportunity * 20 / 100);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setPoolSize: min=" + newSize.minSize + ", max=" + newSize.maxSize + ", drain=" + newSize.maxDrainAmount), (Object[])new Object[0]);
        }
        this.poolSize = newSize;
    }

    @Override
    public final Object get() {
        Object o = this.buffer.pop();
        if (this.beanPerf != null) {
            this.beanPerf.objectRetrieve(this.buffer.size(), o != null);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(Object o) {
        boolean discarded = false;
        if (this.inactive) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setting active: " + this), (Object[])new Object[0]);
            }
            this.inactive = false;
            PoolImplThreadSafe poolImplThreadSafe = this;
            synchronized (poolImplThreadSafe) {
                if (!this.ivManaged) {
                    this.poolMgr.add(this);
                    this.ivManaged = true;
                }
            }
        }
        boolean bl = discarded = !this.buffer.pushWithLimit(o, this.poolSize.maxSize);
        if (discarded && this.discardStrategy != null) {
            this.discardStrategy.discard(o);
        }
        if (this.beanPerf != null) {
            this.beanPerf.objectReturn(this.buffer.size(), discarded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void periodicDrain() {
        SizeData size = this.poolSize;
        int numDiscarded = this.drainToSize(size.minSize, size.maxDrainAmount);
        if (numDiscarded == 0) {
            ++this.ivInactiveNoDrainCount;
            if (this.ivInactiveNoDrainCount > 4) {
                PoolImplThreadSafe poolImplThreadSafe = this;
                synchronized (poolImplThreadSafe) {
                    this.poolMgr.remove(this);
                    this.ivManaged = false;
                }
                this.ivInactiveNoDrainCount = 0;
            }
        } else {
            this.ivInactiveNoDrainCount = 0;
        }
    }

    private int drainToSize(int minPooled, int maxDiscard) {
        int numDiscarded;
        Object o = null;
        for (numDiscarded = 0; numDiscarded < maxDiscard && (o = this.buffer.popWithLimit(minPooled)) != null; ++numDiscarded) {
            if (this.discardStrategy == null) continue;
            this.discardStrategy.discard(o);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("drainToSize: numDiscarded=" + numDiscarded + ", inactive=" + this.ivInactiveNoDrainCount + ", " + this), (Object[])new Object[0]);
        }
        if (this.beanPerf != null) {
            this.beanPerf.poolDrained(this.buffer.size(), numDiscarded);
        }
        return numDiscarded;
    }

    @Override
    final void completeDrain() {
        Object o = null;
        int numDiscarded = this.buffer.size();
        for (LockFreeIndexedStack.StackNode oldTop = this.buffer.clean(); oldTop != null; oldTop = oldTop.getNext()) {
            o = oldTop.getValue();
            if (this.discardStrategy == null) continue;
            this.discardStrategy.discard(o);
        }
        if (this.beanPerf != null) {
            this.beanPerf.poolDrained(0, numDiscarded);
        }
    }

    @Override
    void disable() {
        this.poolSize = DISABLED_SIZE;
    }

    @Override
    public int getMaxSize() {
        return this.poolSize.maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        SizeData size = this.poolSize;
        if (size.maxSize != maxSize) {
            this.setPoolSize(Math.min(maxSize, size.minSize), maxSize);
            this.drainToSize(maxSize, Integer.MAX_VALUE);
        }
    }

    private static class SizeData {
        int minSize;
        int maxSize;
        int maxDrainAmount;

        private SizeData() {
        }
    }
}

