/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.InvalidConditionException;
import com.ibm.ws.objectManager.InvalidObjectStoreNameException;
import com.ibm.ws.objectManager.InvalidObjectToStoreException;
import com.ibm.ws.objectManager.InvalidStoreStrategyException;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.ObjectStoreFullException;
import com.ibm.ws.objectManager.ReplacementException;
import com.ibm.ws.objectManager.StoreSequenceException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.WeakValueConcurrentHashMap;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractObjectStore
extends ObjectStore
implements Serializable {
    private static final Class cclass = AbstractObjectStore.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerStore");
    private static final long serialVersionUID = 9004399024189054153L;
    protected static final int concurrency = 64;
    protected String storeName;
    protected int objectStoreIdentifier = -1;
    protected int storeStrategy;
    protected transient long sequenceNumber;
    private transient SequenceNumberLock sequenceNumberLock;
    protected transient boolean allocationAllowed = true;
    transient WeakValueConcurrentHashMap inMemoryTokens;
    transient ObjectManagerState objectManagerState;
    transient boolean persistent;
    transient boolean containsRestartData;
    transient boolean usesSerializedForm;
    transient int addSpaceOverhead = 0;

    AbstractObjectStore(String storeName, ObjectManager objectManager) throws ObjectManagerException {
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{storeName, objectManager});
        }
        if (storeName == null) {
            throw new InvalidObjectStoreNameException(this, storeName);
        }
        this.storeName = storeName;
        this.objectManagerState = objectManager.objectManagerState;
        this.storeStrategy = 1;
        objectManager.objectManagerState.registerObjectStore(this);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected AbstractObjectStore(ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{objectManagerState});
        }
        this.storeName = "ObjectManagerState.default";
        this.objectManagerState = objectManagerState;
        this.storeStrategy = 0;
        this.persistent = true;
        this.containsRestartData = false;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public AbstractObjectStore(String storeName, ObjectManager objectManager, int storeStrategy) throws ObjectManagerException {
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{storeName, objectManager, new Integer(storeStrategy)});
        }
        if (storeName == null) {
            throw new InvalidObjectStoreNameException(this, storeName);
        }
        this.storeName = storeName;
        this.objectManagerState = objectManager.objectManagerState;
        this.storeStrategy = storeStrategy;
        objectManager.objectManagerState.registerObjectStore(this);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    public synchronized void open(ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "open";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "open", new Object[]{objectManagerState, new Integer(this.storeStrategy), strategyNames[this.storeStrategy], this.storeName});
        }
        this.objectManagerState = objectManagerState;
        this.sequenceNumber = 100L;
        this.sequenceNumberLock = new SequenceNumberLock();
        this.allocationAllowed = true;
        this.inMemoryTokens = new WeakValueConcurrentHashMap(64);
        switch (this.storeStrategy) {
            case 0: {
                this.persistent = true;
                this.containsRestartData = true;
                this.usesSerializedForm = true;
                break;
            }
            case 1: {
                this.persistent = false;
                this.containsRestartData = false;
                this.usesSerializedForm = true;
                break;
            }
            case 2: {
                this.persistent = false;
                this.containsRestartData = true;
                this.usesSerializedForm = false;
                break;
            }
            default: {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "open", new Integer(this.storeStrategy));
                }
                throw new InvalidStoreStrategyException(this, this.storeStrategy);
            }
        }
        objectManagerState.notifyCallbacks(1, new Object[]{this});
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "open", new Object[]{new Boolean(this.persistent), new Boolean(this.containsRestartData), new Boolean(this.usesSerializedForm)});
        }
    }

    @Override
    public abstract ManagedObject get(Token var1) throws ObjectManagerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token like(Token likeToken) {
        Token inMemoryToken;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "like", new Object[]{likeToken});
        }
        if ((inMemoryToken = (Token)this.inMemoryTokens.putIfAbsent(new Long(likeToken.storedObjectIdentifier), likeToken)) == null) {
            inMemoryToken = likeToken;
            SequenceNumberLock sequenceNumberLock = this.sequenceNumberLock;
            synchronized (sequenceNumberLock) {
                if (likeToken.storedObjectIdentifier > this.sequenceNumber) {
                    this.sequenceNumber = Math.max(likeToken.storedObjectIdentifier, this.sequenceNumber);
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "like", new Object[]{inMemoryToken});
        }
        return inMemoryToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token allocate(ManagedObject objectToStore) throws ObjectManagerException {
        long usableSequenceNumber;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "allocate", objectToStore);
        }
        if (objectToStore == null) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "allocate", objectToStore);
            }
            throw new InvalidObjectToStoreException(this, objectToStore);
        }
        if (!this.allocationAllowed) {
            if (this.getStoreFullWaitForCheckPoint()) {
                if (trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "allocate", "Store is currently full, waiting for checkpoint");
                }
                this.objectManagerState.waitForCheckpoint(true);
            } else {
                if (trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "allocate", "Store is currently full, requesting checkpoint");
                }
                this.objectManagerState.requestCheckpoint(true);
            }
            if (!this.allocationAllowed) {
                if (trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "allocate");
                }
                throw new ObjectStoreFullException(this, objectToStore);
            }
        }
        SequenceNumberLock sequenceNumberLock = this.sequenceNumberLock;
        synchronized (sequenceNumberLock) {
            usableSequenceNumber = ++this.sequenceNumber;
        }
        Token tokenToStore = new Token(objectToStore, this, usableSequenceNumber);
        Token inMemoryToken = (Token)this.inMemoryTokens.putIfAbsent(new Long(usableSequenceNumber), tokenToStore);
        if (inMemoryToken != null) {
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "allocate", new Object[]{"via StoreSequenceException", inMemoryToken, new Long(this.sequenceNumber)});
            }
            StoreSequenceException storeSequenceException = new StoreSequenceException(this, this.sequenceNumber, inMemoryToken);
            ObjectManager.ffdc.processException(this, cclass, "add", storeSequenceException, "1:402:1.31");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "allocate", storeSequenceException);
            }
            throw storeSequenceException;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "allocate", new Object[]{tokenToStore});
        }
        return tokenToStore;
    }

    @Override
    public void reserve(int deltaSize, boolean pacing) throws ObjectManagerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ManagedObject managedObject, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
        Token inMemoryToken;
        String methodName = "add";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "add", new Object[]{managedObject, new Boolean(requiresCurrentCheckpoint)});
        }
        if ((inMemoryToken = (Token)this.inMemoryTokens.putIfAbsent(new Long(managedObject.owningToken.storedObjectIdentifier), managedObject.owningToken)) == null) {
            SequenceNumberLock sequenceNumberLock = this.sequenceNumberLock;
            synchronized (sequenceNumberLock) {
                if (managedObject.owningToken.storedObjectIdentifier > this.sequenceNumber) {
                    this.sequenceNumber = Math.max(managedObject.owningToken.storedObjectIdentifier, this.sequenceNumber);
                    if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                        trace.debug((Object)this, cclass, "add", new Object[]{"sequenceNumber now", new Long(this.sequenceNumber)});
                    }
                }
            }
        } else if (inMemoryToken != managedObject.owningToken) {
            ReplacementException replacementException = new ReplacementException(this, managedObject, managedObject.owningToken, inMemoryToken);
            ObjectManager.ffdc.processException(this, cclass, "add", replacementException, "1:473:1.31");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "add", new Object[]{replacementException, managedObject, managedObject.owningToken, inMemoryToken});
            }
            throw replacementException;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "add");
        }
    }

    @Override
    public void remove(Token token, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
        String methodName = "remove";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "remove", new Object[]{token, new Boolean(requiresCurrentCheckpoint)});
        }
        this.inMemoryTokens.remove(new Long(token.storedObjectIdentifier));
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "remove");
        }
    }

    @Override
    public final void deRegister() throws ObjectManagerException {
        this.objectManagerState.deRegisterObjectStore(this);
    }

    @Override
    protected synchronized void clear() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "clear");
        }
        this.sequenceNumber = 100L;
        this.allocationAllowed = true;
        this.inMemoryTokens = new WeakValueConcurrentHashMap(64);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "clear");
        }
    }

    @Override
    public synchronized void close() throws ObjectManagerException {
        for (Reference reference : this.inMemoryTokens.values()) {
            Token token;
            if (reference == null || (token = (Token)reference.get()) == null) continue;
            token.invalidate();
        }
        this.inMemoryTokens.clear();
        this.inMemoryTokens = null;
    }

    @Override
    public abstract void flush() throws ObjectManagerException;

    @Override
    public int getIdentifier() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getIdentifier");
            trace.exit((Object)this, cclass, "getIdentifier", "returns objectStoreIdentifier=" + this.objectStoreIdentifier + "(int)");
        }
        return this.objectStoreIdentifier;
    }

    @Override
    public void setIdentifier(int identifier) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setIdentifier", new Object[]{new Integer(identifier)});
        }
        if (this.objectStoreIdentifier != -1) {
            InvalidConditionException invalidConditionException = new InvalidConditionException((Object)this, "objectStoreIdentifier", Integer.toString(this.objectStoreIdentifier) + "not equal IDENTIFIER_NOT_SET");
            ObjectManager.ffdc.processException(this, cclass, "setIdentifier", invalidConditionException, "1:623:1.31", new Object[]{new Integer(this.objectStoreIdentifier)});
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "setIdentifier", invalidConditionException);
            }
            throw invalidConditionException;
        }
        this.objectStoreIdentifier = identifier;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "setIdentifier");
        }
    }

    @Override
    public final String getName() {
        String methodName = "getName";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getName");
            trace.exit((Object)this, cclass, "getName", new Object[]{this.storeName});
        }
        return this.storeName;
    }

    @Override
    public final void setName(String newName) throws ObjectManagerException {
        String methodName = "setName";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setName", new Object[]{newName, this.storeName});
        }
        this.objectManagerState.renameObjectStore(this, newName);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "setName");
        }
    }

    @Override
    final void setLogicalName(String newName) {
        this.storeName = newName;
    }

    @Override
    protected final ObjectManagerState getObjectManagerState() {
        return this.objectManagerState;
    }

    @Override
    public final int getStoreStrategy() {
        return this.storeStrategy;
    }

    @Override
    public final boolean getPersistence() {
        return this.persistent;
    }

    @Override
    public final boolean getContainsRestartData() {
        return this.containsRestartData;
    }

    @Override
    public final boolean getUsesSerializedForm() {
        return this.usesSerializedForm;
    }

    @Override
    public int getAddSpaceOverhead() {
        return this.addSpaceOverhead;
    }

    @Override
    public Map captureStatistics() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "captureStatistics");
        }
        HashMap<String, String> statistics = new HashMap<String, String>();
        if (this.inMemoryTokens != null) {
            statistics.put("inMemoryTokens.size()", Integer.toString(this.inMemoryTokens.size()));
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "captureStatistics", statistics);
        }
        return statistics;
    }

    @Override
    public void print(PrintWriter printWriter) {
        printWriter.println("State Dump for:" + cclass.getName() + " sequenceNumber=" + this.sequenceNumber + "(int) allocationAllowed=" + this.allocationAllowed + "(boolean) storeName=" + this.storeName + "(String)\n objectStoreIdentifier=" + this.objectStoreIdentifier + "(int) storeStrategy=" + this.storeStrategy + "(int)" + strategyNames[this.storeStrategy] + "(String) persistent=" + this.persistent + "(boolean) objectManagerState=" + this.objectManagerState + "(ObjectManagerState)");
        printWriter.println();
        printWriter.println("inMemoryTokens...");
        for (Reference reference : this.inMemoryTokens.values()) {
            Token token;
            if (reference == null || (token = (Token)reference.get()) == null) continue;
            printWriter.println(token.toString());
        }
    }

    public String toString() {
        return new String("AbstractObjectStore(" + this.storeName + ")/" + Integer.toHexString(this.hashCode()));
    }

    private class SequenceNumberLock {
        private SequenceNumberLock() {
        }
    }
}

