/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.InvalidTopicSyntaxException;
import com.ibm.ws.sib.matchspace.MatchSpace;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.MatchTarget;
import com.ibm.ws.sib.matchspace.MatchingException;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.QuerySyntaxException;
import com.ibm.ws.sib.matchspace.SearchResults;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.impl.Matching;
import com.ibm.ws.sib.matchspace.tools.Evaluator;
import com.ibm.ws.sib.matchspace.tools.MatchParser;
import com.ibm.ws.sib.matchspace.tools.PositionAssigner;
import com.ibm.ws.sib.matchspace.tools.Resolver;
import com.ibm.ws.sib.matchspace.tools.TopicSyntaxChecker;
import com.ibm.ws.sib.matchspace.tools.Transformer;
import com.ibm.ws.sib.matchspace.tools.XPath10Parser;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.processor.MPSelectionCriteria;
import com.ibm.ws.sib.processor.exceptions.SIMPDiscriminatorSyntaxException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ControllableProxySubscription;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.processor.matching.ConsumerMonitoring;
import com.ibm.ws.sib.processor.matching.JSResolver;
import com.ibm.ws.sib.processor.matching.MatchingApplicationSignature;
import com.ibm.ws.sib.processor.matching.MatchingConsumerDispatcher;
import com.ibm.ws.sib.processor.matching.MatchingConsumerDispatcherWithCriteira;
import com.ibm.ws.sib.processor.matching.MatchingConsumerPoint;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.matching.MonitoredConsumer;
import com.ibm.ws.sib.processor.matching.TopicAcl;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSetChangeCallback;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.messagecontrol.ApplicationSignature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MessageProcessorMatching {
    private static final TraceComponent tc = SibTr.register(MessageProcessorMatching.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    public static boolean unitTestMode = false;
    private boolean disableXPathOptimizer = false;
    private MatchParser _sibParser;
    private MatchParser _xpathParser;
    private Map _targets = new HashMap();
    private ConsumerMonitoring _consumerMonitoring;
    private Matching _matching = null;
    private Identifier _rootId;
    private MatchSpace _matchSpace = null;
    private Resolver _defaultResolver = null;
    private JSResolver _simessageResolver = null;
    private JSResolver _jmsResolver = null;
    private PositionAssigner _positionAssigner = null;
    private static TopicSyntaxChecker _syntaxChecker = null;
    private MessageProcessor _messageProcessor;
    private boolean _isBusSecure = false;

    public MessageProcessorMatching() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageProcessorMatching");
        }
        this._matching = this.getMatchingInstance();
        this._rootId = this._matching.createIdentifier("topic");
        this._rootId.setType(3);
        _syntaxChecker = this._matching.createXPathTopicSyntaxChecker();
        this._defaultResolver = this._matching.createMinimalResolver();
        this._simessageResolver = new JSResolver(SelectorDomain.SIMESSAGE);
        this._jmsResolver = new JSResolver(SelectorDomain.JMS);
        this._positionAssigner = this._matching.createPositionAssigner();
        this._defaultResolver.resolve(this._rootId, this._positionAssigner);
        this._matchSpace = this._matching.createMatchSpace(this._rootId, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageProcessorMatching", (Object)this);
        }
    }

    public MessageProcessorMatching(MessageProcessor messageProcessor) {
        this();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageProcessorMatching", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        this._isBusSecure = messageProcessor.isBusSecure();
        JsBus jsBus = messageProcessor.getBus();
        String propVal = jsBus.getCustomProperty("com.ibm.ws.sib.matching.XPathOptimizer");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("custom prop value: " + propVal));
        }
        if (propVal != null && !"".equals(propVal.trim())) {
            if (propVal.equalsIgnoreCase("disabled")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"XPath Optimization is disabled at the Bus");
                }
                this.disableXPathOptimizer = true;
            } else if (propVal.equalsIgnoreCase("enabled")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"XPath Optimization is enabled at the Bus");
                }
                this.disableXPathOptimizer = false;
            } else {
                SibTr.info((TraceComponent)tc, (String)"INVALID_XPATH_CUSTOM_PROPERTY_CWSIP0377", (Object)new Object[]{propVal});
            }
        }
        this._consumerMonitoring = new ConsumerMonitoring(this._messageProcessor, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageProcessorMatching", (Object)this);
        }
    }

    private Matching getMatchingInstance() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMatchingInstance", (Object)unitTestMode);
        }
        Matching result = null;
        if (unitTestMode) {
            try {
                result = Matching.getInstance();
            }
            catch (Exception exception) {}
        } else {
            result = (Matching)MessageProcessor.getSingletonInstance("Matching");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMatchingInstance", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTarget(Object key, String topic, String selectorString, SelectorDomain domain, Resolver resolver, MatchTarget target, Selector inputSelector, Map<String, Object> selectorProperties) throws InvalidTopicSyntaxException, SIDiscriminatorSyntaxException, QuerySyntaxException, MatchingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTarget", (Object)new Object[]{key, topic, selectorString, domain, resolver, target});
        }
        _syntaxChecker.checkTopicSyntax(topic);
        Operator selectorTree = this._matching.createTopicLikeOperator((Selector)this._rootId, topic);
        Transformer transformer = Matching.getTransformer();
        if (selectorString != null && selectorString.trim().length() != 0) {
            try {
                MessageProcessorMatching messageProcessorMatching = this;
                synchronized (messageProcessorMatching) {
                    Selector parsed;
                    if (inputSelector == null) {
                        MatchParser parser = null;
                        if (domain.equals((Object)SelectorDomain.JMS)) {
                            parser = this._sibParser = this._matching.primeMatchParser(this._sibParser, selectorString, SelectorDomain.JMS.toInt());
                        } else if (domain.equals((Object)SelectorDomain.SIMESSAGE)) {
                            parser = this._sibParser = this._matching.primeMatchParser(this._sibParser, selectorString, SelectorDomain.SIMESSAGE.toInt());
                        } else {
                            this._xpathParser = this._matching.primeMatchParser(this._xpathParser, selectorString, SelectorDomain.XPATH1.toInt());
                            if (selectorProperties != null) {
                                Map prefixMappings = null;
                                prefixMappings = (Map)selectorProperties.get("namespacePrefixMappings");
                                if (prefixMappings != null) {
                                    XPath10Parser xpParser = (XPath10Parser)this._xpathParser;
                                    xpParser.setNamespaceMappings(prefixMappings);
                                }
                            }
                            parser = this._xpathParser;
                        }
                        if (this.disableXPathOptimizer && domain.equals((Object)SelectorDomain.XPATH1)) {
                            XPath10Parser xpParser = (XPath10Parser)parser;
                            if (selectorProperties != null) {
                                Map prefixMappings = null;
                                prefixMappings = (Map)selectorProperties.get("namespacePrefixMappings");
                                if (prefixMappings != null) {
                                    xpParser.setNamespaceMappings(prefixMappings);
                                }
                            }
                            parsed = xpParser.parseWholeSelector(selectorString);
                        } else {
                            parsed = parser.getSelector(selectorString);
                        }
                        if (parsed.getType() == 2) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"addTarget", (Object)"QuerySyntaxException");
                            }
                            throw new QuerySyntaxException(selectorString);
                        }
                        if (resolver == null) {
                            resolver = this._defaultResolver;
                        }
                        if ((parsed = transformer.resolve(parsed, resolver, this._positionAssigner)).getType() == 2) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"addTarget", (Object)"QuerySyntaxException");
                            }
                            throw new QuerySyntaxException(selectorString);
                        }
                    } else {
                        parsed = inputSelector;
                    }
                    selectorTree = this._matching.createOperator(46, (Selector)selectorTree, parsed);
                }
            }
            catch (RuntimeException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addTarget", (Object)"QuerySyntaxException");
                }
                throw new QuerySyntaxException(e.getMessage());
            }
        }
        Conjunction[] expr = null;
        expr = domain != null && domain.equals((Object)SelectorDomain.XPATH1) ? transformer.organizeTests((Selector)selectorTree) : transformer.organizeTests(transformer.DNF((Selector)selectorTree));
        if (expr == null) {
            expr = new Conjunction[]{null};
        }
        MatchTarget[] targ = new MatchTarget[expr.length];
        for (int i = 0; i < targ.length; ++i) {
            targ[i] = i == 0 ? target : target.duplicate();
            this._matchSpace.addTarget(expr[i], targ[i]);
        }
        Map map = this._targets;
        synchronized (map) {
            if (target instanceof MonitoredConsumer) {
                this._consumerMonitoring.addConsumer(key, topic, selectorString, target, this.isWildCarded(topic));
            }
            this._targets.put(key, new Target(expr, targ));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTarget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTarget(Object key) throws MatchingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeTarget", (Object)new Object[]{key});
        }
        Map map = this._targets;
        synchronized (map) {
            Target targ = (Target)this._targets.get(key);
            if (targ == null) {
                throw new MatchingException();
            }
            for (int i = 0; i < targ.targets.length; ++i) {
                this._matchSpace.removeTarget(targ.expr[i], targ.targets[i]);
            }
            this._targets.remove(key);
            if (targ.targets.length > 0 && targ.targets[0] instanceof MonitoredConsumer) {
                this._consumerMonitoring.removeConsumer((MonitoredConsumer)targ.targets[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeTarget");
        }
    }

    public void addConsumerPointMatchTarget(DispatchableKey consumerPointData, SIBUuid12 destUuid, SIBUuid8 cmUuid, SelectionCriteria criteria) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumerPointMatchTarget", (Object)new Object[]{consumerPointData, destUuid, cmUuid, criteria});
        }
        MatchingConsumerPoint mcp = new MatchingConsumerPoint(consumerPointData);
        String mSpacePrefix = destUuid.toString() + '/' + cmUuid.toString();
        String theTopic = null;
        theTopic = criteria != null && criteria.getDiscriminator() != null ? this.buildAddTopicExpression(mSpacePrefix, criteria.getDiscriminator()) : mSpacePrefix;
        try {
            String selectorString = null;
            SelectorDomain selectorDomain = SelectorDomain.SIMESSAGE;
            Map selectorProperties = null;
            Resolver resolver = null;
            if (criteria != null) {
                selectorString = criteria.getSelectorString();
                selectorDomain = criteria.getSelectorDomain();
                if (criteria instanceof MPSelectionCriteria) {
                    MPSelectionCriteria mpCriteria = (MPSelectionCriteria)criteria;
                    selectorProperties = mpCriteria.getSelectorProperties();
                }
                if (selectorString != null && selectorString.trim().length() != 0) {
                    resolver = selectorDomain.equals((Object)SelectorDomain.JMS) ? this._jmsResolver : (selectorDomain.equals((Object)SelectorDomain.SIMESSAGE) ? this._simessageResolver : this._defaultResolver);
                }
            }
            this.addTarget(consumerPointData, theTopic, selectorString, selectorDomain, resolver, mcp, consumerPointData.getSelector(), selectorProperties);
        }
        catch (QuerySyntaxException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerPointMatchTarget", (Object)"SISelectorSyntaxException");
            }
            throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{criteria}, null));
        }
        catch (InvalidTopicSyntaxException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerPointMatchTarget", (Object)"SIDiscriminatorSyntaxException");
            }
            String theTopicString = criteria != null && criteria.getDiscriminator() != null ? criteria.getDiscriminator() : mSpacePrefix;
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{theTopicString}, null));
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.addConsumerPointMatchTarget", (String)"1:652:1.117.1.11", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerPointMatchTarget", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:661:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:669:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumerPointMatchTarget");
        }
    }

    public void retrieveMatchingConsumerPoints(SIBUuid12 destUuid, SIBUuid8 cmUuid, JsMessage msg, MessageProcessorSearchResults searchResults) throws SIDiscriminatorSyntaxException {
        block11: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"retrieveMatchingConsumerPoints", (Object)new Object[]{destUuid, cmUuid, msg, searchResults});
            }
            String mSpacePrefix = destUuid.toString() + '/' + cmUuid.toString();
            try {
                searchResults.reset();
                EvalCache cache = this._matching.createEvalCache();
                String discriminator = msg.getDiscriminator();
                if (discriminator != null) {
                    try {
                        _syntaxChecker.checkEventTopicSyntax(discriminator);
                        String theTopic = this.buildSendTopicExpression(mSpacePrefix, discriminator);
                        this.search(theTopic, (MatchSpaceKey)msg, cache, searchResults);
                        break block11;
                    }
                    catch (InvalidTopicSyntaxException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingConsumerPoints", (Object)((Object)e));
                        }
                        throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{discriminator}, null));
                    }
                }
                this.search(mSpacePrefix, (MatchSpaceKey)msg, cache, searchResults);
            }
            catch (BadMessageFormatMatchingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingConsumerPoints", (String)"1:759:1.117.1.11", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingConsumerPoints", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:770:1.117.1.11", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:778:1.117.1.11", e}, null), (Throwable)e);
            }
            catch (MatchingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingConsumerPoints", (String)"1:789:1.117.1.11", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingConsumerPoints", (Object)"SIErrorException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:800:1.117.1.11", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:808:1.117.1.11", e}, null), (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingConsumerPoints");
        }
    }

    public void removeConsumerPointMatchTarget(DispatchableKey consumerPointData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerPointMatchTarget", (Object)consumerPointData);
        }
        try {
            this.removeTarget(consumerPointData);
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.removeConsumerPointMatchTarget", (String)"1:840:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeConsumerPointMatchTarget", (Object)"SICoreException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:851:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:859:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerPointMatchTarget");
        }
    }

    public void addConsumerDispatcherMatchTarget(ConsumerDispatcher consumerDispatcher, SIBUuid12 topicSpace, SelectionCriteria criteria) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumerDispatcherMatchTarget", (Object)new Object[]{consumerDispatcher, topicSpace, criteria});
        }
        String topicSpaceStr = topicSpace.toString();
        String theTopic = this.buildAddTopicExpression(topicSpaceStr, criteria == null ? null : criteria.getDiscriminator());
        try {
            String selectorString = null;
            SelectorDomain selectorDomain = SelectorDomain.SIMESSAGE;
            Map selectorProperties = null;
            Resolver resolver = null;
            if (criteria != null) {
                selectorString = criteria.getSelectorString();
                selectorDomain = criteria.getSelectorDomain();
                if (criteria instanceof MPSelectionCriteria) {
                    MPSelectionCriteria mpCriteria = (MPSelectionCriteria)criteria;
                    selectorProperties = mpCriteria.getSelectorProperties();
                }
                if (selectorString != null && selectorString.trim().length() != 0) {
                    resolver = selectorDomain.equals((Object)SelectorDomain.JMS) ? this._jmsResolver : (selectorDomain.equals((Object)SelectorDomain.SIMESSAGE) ? this._simessageResolver : this._defaultResolver);
                }
            }
            MatchingConsumerDispatcher Matchkey = new MatchingConsumerDispatcher(consumerDispatcher);
            MatchingConsumerDispatcherWithCriteira key = new MatchingConsumerDispatcherWithCriteira(consumerDispatcher, criteria);
            this.addTarget((Object)key, theTopic, selectorString, selectorDomain, resolver, Matchkey, null, selectorProperties);
            consumerDispatcher.setIsInMatchSpace(true);
        }
        catch (QuerySyntaxException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerDispatcherMatchTarget", (Object)"SISelectorSyntaxException");
            }
            throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{criteria}, null));
        }
        catch (InvalidTopicSyntaxException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerDispatcherMatchTarget", (Object)((Object)e));
            }
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{criteria == null ? null : criteria.getDiscriminator()}, null));
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.addConsumerDispatcherMatchTarget", (String)"1:981:1.117.1.11", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerDispatcherMatchTarget", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:990:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:998:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumerDispatcherMatchTarget");
        }
    }

    public ConsumerDispatcher addSimConsumerDispatcherMatchTarget(BaseDestinationHandler handler, SelectionCriteria criteria) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSimConsumerDispatcherMatchTarget", (Object)new Object[]{handler, criteria});
        }
        SubscriptionItemStream si = new SubscriptionItemStream();
        ConsumerDispatcher cd = new ConsumerDispatcher(handler, si, null);
        SIBUuid12 topicSpace = handler.getUuid();
        this.addConsumerDispatcherMatchTarget(cd, topicSpace, criteria);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSimConsumerDispatcherMatchTarget", (Object)cd);
        }
        return cd;
    }

    public ControllableProxySubscription addPubSubOutputHandlerMatchTarget(PubSubOutputHandler handler, SIBUuid12 topicSpace, String discriminator, boolean foreignSecuredProxy, String MESubUserId) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPubSubOutputHandlerMatchTarget", (Object)new Object[]{handler, topicSpace, discriminator, foreignSecuredProxy, MESubUserId});
        }
        String topicSpaceStr = topicSpace.toString();
        String theTopic = this.buildAddTopicExpression(topicSpaceStr, discriminator);
        ControllableProxySubscription key = new ControllableProxySubscription(handler, theTopic, foreignSecuredProxy, MESubUserId);
        try {
            this.addTarget(key, theTopic, null, null, null, key, null, null);
        }
        catch (QuerySyntaxException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addPubSubOutputHandlerMatchTarget", (Object)((Object)e));
            }
            throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{null}, null));
        }
        catch (InvalidTopicSyntaxException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addPubSubOutputHandlerMatchTarget", (Object)((Object)e));
            }
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{discriminator}, null));
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.addPubSubOutputHandlerMatchTarget", (String)"1:1111:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addPubSubOutputHandlerMatchTarget", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1122:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1130:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPubSubOutputHandlerMatchTarget", (Object)key);
        }
        return key;
    }

    public void retrieveMatchingOutputHandlers(DestinationHandler topicSpace, String discriminator, MatchSpaceKey msg, MessageProcessorSearchResults searchResults) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"retrieveMatchingOutputHandlers", (Object)new Object[]{topicSpace, discriminator, msg, searchResults});
        }
        SIBUuid12 topicSpaceUuid = topicSpace.getBaseUuid();
        String topicSpaceStr = topicSpaceUuid.toString();
        String theTopic = this.buildSendTopicExpression(topicSpaceStr, discriminator);
        try {
            _syntaxChecker.checkEventTopicSyntax(theTopic);
        }
        catch (InvalidTopicSyntaxException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingOutputHandlers", (Object)((Object)e));
            }
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{discriminator}, null));
        }
        try {
            searchResults.reset();
            if (this._isBusSecure) {
                searchResults.setTopicSpace(topicSpace);
            }
            EvalCache cache = this._matching.createEvalCache();
            this.search(theTopic, msg, cache, searchResults);
        }
        catch (BadMessageFormatMatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingOutputHandlers", (String)"1:1222:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingOutputHandlers", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1233:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1241:1.117.1.11", e}, null), (Throwable)e);
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingOutputHandlers", (String)"1:1252:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingOutputHandlers", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1263:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1271:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingOutputHandlers", (Object)searchResults);
        }
    }

    public void removeConsumerDispatcherMatchTarget(ConsumerDispatcher consumerDispatcher, SelectionCriteria selectionCriteria) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerDispatcherMatchTarget", (Object)new Object[]{consumerDispatcher, selectionCriteria});
        }
        MatchingConsumerDispatcherWithCriteira key = new MatchingConsumerDispatcherWithCriteira(consumerDispatcher, selectionCriteria);
        consumerDispatcher.setIsInMatchSpace(false);
        try {
            this.removeTarget((Object)key);
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.removeConsumerDispatcherMatchTarget", (String)"1:1312:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeConsumerDispatcherMatchTarget", (Object)"SICoreException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1323:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1331:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerDispatcherMatchTarget");
        }
    }

    public void removePubSubOutputHandlerMatchTarget(ControllableProxySubscription sub) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removePubSubOutputHandlerMatchTarget", (Object)sub);
        }
        try {
            this.removeTarget(sub);
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.removePubSubOutputHandlerMatchTarget", (String)"1:1363:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1370:1.117.1.11", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removePubSubOutputHandlerMatchTarget", (Object)"SICoreException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1381:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removePubSubOutputHandlerMatchTarget");
        }
    }

    private String buildSendTopicExpression(String destName, String discriminator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"buildSendTopicExpression", (Object)new Object[]{destName, discriminator});
        }
        String combo = null;
        combo = discriminator == null || discriminator.trim().length() == 0 ? destName : destName + '/' + discriminator;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"buildSendTopicExpression", (Object)combo);
        }
        return combo;
    }

    public String buildAddTopicExpression(String destName, String discriminator) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"buildAddTopicExpression", (Object)new Object[]{destName, discriminator});
        }
        String combo = null;
        if (discriminator == null) {
            combo = destName + "//.";
        } else if (discriminator.trim().length() == 0) {
            combo = destName;
        } else if (discriminator.startsWith("//")) {
            combo = destName + discriminator;
        } else {
            if (discriminator.startsWith("/")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"buildAddTopicExpression", (Object)"SISelectorSyntaxException");
                }
                throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{discriminator}, null));
            }
            combo = destName + '/' + discriminator;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"buildAddTopicExpression", (Object)combo);
        }
        return combo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllCDMatchTargets() {
        ArrayList<ConsumerDispatcher> consumerDispatcherList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllCDMatchTargets");
        }
        Map map = this._targets;
        synchronized (map) {
            consumerDispatcherList = new ArrayList<ConsumerDispatcher>(this._targets.size());
            for (Object key : this._targets.keySet()) {
                if (!(key instanceof MatchingConsumerDispatcherWithCriteira)) continue;
                consumerDispatcherList.add(((MatchingConsumerDispatcherWithCriteira)((Object)key)).getConsumerDispatcher());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllCDMatchTargets");
        }
        return consumerDispatcherList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllCDMatchTargetsForTopicSpace(String tSpace) {
        ArrayList<ConsumerDispatcher> consumerDispatcherList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllCDMatchTargetsForTopicSpace");
        }
        Map map = this._targets;
        synchronized (map) {
            consumerDispatcherList = new ArrayList<ConsumerDispatcher>(this._targets.size());
            for (Object key : this._targets.keySet()) {
                ConsumerDispatcher cd;
                String storedDest;
                if (!(key instanceof MatchingConsumerDispatcherWithCriteira) || !(storedDest = (cd = ((MatchingConsumerDispatcherWithCriteira)((Object)key)).getConsumerDispatcher()).getDestination().getName()).equals(tSpace)) continue;
                consumerDispatcherList.add(cd);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllCDMatchTargetsForTopicSpace");
        }
        return consumerDispatcherList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllPubSubOutputHandlerMatchTargets() {
        ArrayList<OutputHandler> outputHandlerList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllPubSubOutputHandlerMatchTargets");
        }
        Map map = this._targets;
        synchronized (map) {
            outputHandlerList = new ArrayList<OutputHandler>(this._targets.size());
            for (Object key : this._targets.keySet()) {
                if (!(key instanceof ControllableProxySubscription)) continue;
                outputHandlerList.add(((ControllableProxySubscription)key).getOutputHandler());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllPubSubOutputHandlerMatchTargets", outputHandlerList);
        }
        return outputHandlerList;
    }

    public Selector parseDiscriminator(String discriminator) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseDiscriminator", (Object)discriminator);
        }
        Operator discriminatorTree = null;
        try {
            if (discriminator != null) {
                _syntaxChecker.checkTopicSyntax(discriminator);
                discriminatorTree = this._matching.createTopicLikeOperator((Selector)this._rootId, discriminator);
            }
        }
        catch (InvalidTopicSyntaxException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"parseDiscriminator", (Object)((Object)e));
            }
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{discriminator}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseDiscriminator", discriminatorTree);
        }
        return discriminatorTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector parseSelector(String selectorString, SelectorDomain domain) throws SISelectorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseSelector", (Object)new Object[]{selectorString, domain});
        }
        Selector selectorTree = null;
        Transformer transformer = Matching.getTransformer();
        Resolver resolver = null;
        try {
            MessageProcessorMatching messageProcessorMatching = this;
            synchronized (messageProcessorMatching) {
                MatchParser parser = null;
                if (domain.equals((Object)SelectorDomain.JMS)) {
                    resolver = this._jmsResolver;
                    parser = this._sibParser = this._matching.primeMatchParser(this._sibParser, selectorString, SelectorDomain.JMS.toInt());
                } else if (domain.equals((Object)SelectorDomain.SIMESSAGE)) {
                    resolver = this._simessageResolver;
                    parser = this._sibParser = this._matching.primeMatchParser(this._sibParser, selectorString, SelectorDomain.SIMESSAGE.toInt());
                } else {
                    resolver = this._defaultResolver;
                    parser = this._xpathParser = this._matching.primeMatchParser(this._xpathParser, selectorString, SelectorDomain.XPATH1.toInt());
                }
                if (this.disableXPathOptimizer && domain.equals((Object)SelectorDomain.XPATH1)) {
                    XPath10Parser xpParser = (XPath10Parser)parser;
                    selectorTree = xpParser.parseWholeSelector(selectorString);
                } else {
                    selectorTree = parser.getSelector(selectorString);
                }
                if (selectorTree.getType() == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"parseSelector", (Object)"SISelectorSyntaxException");
                    }
                    throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{selectorString}, null));
                }
                if ((selectorTree = transformer.resolve(selectorTree, resolver, this._positionAssigner)).getType() == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"parseSelector", (Object)"SISelectorSyntaxException");
                    }
                    throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{selectorString}, null));
                }
            }
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.parseSelector", (String)"1:1741:1.117.1.11", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"parseSelector", (Object)"SISelectorSyntaxException");
            }
            throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{null}, null));
        }
        catch (MatchingException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"parseSelector", (Object)"SISelectorSyntaxException");
            }
            throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0376", new Object[]{e}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseSelector", (Object)selectorTree);
        }
        return selectorTree;
    }

    public boolean evaluateMessage(Selector selectorTree, Selector discriminatorTree, SIBusMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"evaluateMessage", (Object)new Object[]{selectorTree, msg});
        }
        boolean ret = false;
        Object result = null;
        boolean discriminatorMatches = true;
        EvalCache cache = EvalCache.DUMMY;
        try {
            Evaluator evaluator = Matching.getEvaluator();
            if (discriminatorTree != null) {
                discriminatorMatches = false;
                String discriminator = msg.getDiscriminator();
                DiscriminatorMatchSpaceKey msk = new DiscriminatorMatchSpaceKey(discriminator);
                result = evaluator.eval(discriminatorTree, msk, cache, null, false);
                if (result != null && ((Boolean)result).booleanValue()) {
                    discriminatorMatches = true;
                }
            }
            if (selectorTree != null && discriminatorMatches) {
                result = evaluator.eval(selectorTree, (MatchSpaceKey)msg, cache, null, false);
            }
        }
        catch (BadMessageFormatMatchingException qex) {
            FFDCFilter.processException((Throwable)qex, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.evaluateMessage", (String)"1:1824:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)qex));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"evaluateMessage", (Object)"SICoreException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1834:1.117.1.11", qex});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1844:1.117.1.11", qex}, null), (Throwable)qex);
        }
        if (result instanceof Boolean) {
            ret = (Boolean)result;
        } else if (result == null) {
            ret = false;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"evaluateMessage", (Object)"SICoreException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1870:1.117.1.11"});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1877:1.117.1.11"}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"evaluateMessage", (Object)ret);
        }
        return ret;
    }

    public void addTopicAcl(SIBUuid12 destName, TopicAcl acl) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTopicAcl", (Object)new Object[]{destName, acl});
        }
        String discriminator = null;
        String theTopic = "";
        if (destName != null) {
            String destNameStr = destName.toString();
            theTopic = this.buildAddTopicExpression(destNameStr, acl.getTopic());
        }
        discriminator = acl.getTopic() != null ? theTopic + "//." : theTopic;
        try {
            this.addTarget((Object)acl, discriminator, null, null, null, acl, null, null);
        }
        catch (QuerySyntaxException destNameStr) {
        }
        catch (InvalidTopicSyntaxException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addTopicAcl", (Object)"SIDiscriminatorSyntaxException");
            }
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{theTopic}, null));
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.addTopicAcl", (String)"1:1954:1.117.1.11", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addTopicAcl", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1962:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:1970:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTopicAcl");
        }
    }

    public void retrieveMatchingTopicAcls(DestinationHandler topicSpace, String discriminator, JsMessage msg, MessageProcessorSearchResults searchResults) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"retrieveMatchingTopicAcls", (Object)new Object[]{topicSpace, discriminator, msg, searchResults});
        }
        SIBUuid12 topicSpaceUuid = topicSpace.getBaseUuid();
        String topicSpaceStr = topicSpaceUuid.toString();
        String theTopic = this.buildSendTopicExpression(topicSpaceStr, discriminator);
        try {
            _syntaxChecker.checkEventTopicSyntax(theTopic);
        }
        catch (InvalidTopicSyntaxException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingTopicAcls", (Object)((Object)e));
            }
            SIMPDiscriminatorSyntaxException ee = new SIMPDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{theTopic}, null));
            ee.setExceptionReason(901);
            ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2027:1.117.1.11", SIMPUtils.getStackTrace(e)});
            throw ee;
        }
        try {
            EvalCache cache = this._matching.createEvalCache();
            searchResults.reset();
            if (this._isBusSecure) {
                searchResults.setTopicSpace(topicSpace);
            }
            this.search(theTopic, (MatchSpaceKey)msg, cache, searchResults);
        }
        catch (BadMessageFormatMatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingTopicAcls", (String)"1:2059:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingTopicAcls", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2070:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2078:1.117.1.11", e}, null), (Throwable)e);
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingTopicAcls", (String)"1:2089:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingTopicAcls", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2099:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2107:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingTopicAcls");
        }
    }

    public boolean isWildCarded(String discriminator) {
        boolean result = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isWildCarded", (Object)discriminator);
        }
        try {
            _syntaxChecker.checkEventTopicSyntax(discriminator);
        }
        catch (InvalidTopicSyntaxException e) {
            result = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isWildCarded", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTopicAcls() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeAllTopicAcls");
        }
        ArrayList topicAclList = null;
        try {
            Map map = this._targets;
            synchronized (map) {
                topicAclList = new ArrayList(this._targets.size());
                for (Object key : this._targets.keySet()) {
                    if (!(key instanceof TopicAcl)) continue;
                    topicAclList.add(key);
                }
                for (Object key : topicAclList) {
                    this.removeTarget(key);
                }
            }
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.removeAllTopicAcls", (String)"1:2188:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeAllTopicAcls", (Object)"SICoreException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2199:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2207:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAllTopicAcls");
        }
    }

    public void search(String theTopic, MatchSpaceKey msg, EvalCache cache, MessageProcessorSearchResults searchResults) throws BadMessageFormatMatchingException, MatchingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"search", (Object)new Object[]{theTopic, msg, cache, searchResults});
        }
        if (this._isBusSecure) {
            int aclVersion = this._messageProcessor.getDiscriminatorAccessChecker().getAclRefreshVersion();
            boolean searchAgain = true;
            while (searchAgain) {
                this._matchSpace.search((Object)theTopic, msg, cache, (SearchResults)searchResults);
                int newAclVersion = this._messageProcessor.getDiscriminatorAccessChecker().getAclRefreshVersion();
                if (newAclVersion == aclVersion) {
                    searchAgain = false;
                    continue;
                }
                aclVersion = newAclVersion;
            }
        } else {
            this._matchSpace.search((Object)theTopic, msg, cache, (SearchResults)searchResults);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"search");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerConsumerSetMonitor(DestinationHandler topicSpace, String discriminatorExpression, ConnectionImpl connection, ConsumerSetChangeCallback callback) throws SIDiscriminatorSyntaxException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)new Object[]{topicSpace, discriminatorExpression, connection, callback});
        }
        boolean isWildcarded = this.isWildCarded(discriminatorExpression);
        SIBUuid12 topicSpaceUuid = topicSpace.getBaseUuid();
        String topicSpaceStr = topicSpaceUuid.toString();
        String tExpression = this.buildAddTopicExpression(topicSpaceStr, discriminatorExpression);
        String wildcardStem = null;
        if (isWildcarded) {
            wildcardStem = this.retrieveNonWildcardStem(tExpression);
        }
        boolean areConsumers = false;
        Map map = this._targets;
        synchronized (map) {
            areConsumers = this._consumerMonitoring.registerConsumerSetMonitor(connection, topicSpace, topicSpaceUuid, discriminatorExpression, tExpression, callback, isWildcarded, wildcardStem, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)areConsumers);
        }
        return areConsumers;
    }

    public void retrieveNonSelectorConsumers(DestinationHandler topicSpace, String discriminatorExpression, Set localConsumers, Set remoteConsumers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"retrieveNonSelectorConsumers", (Object)new Object[]{topicSpace, discriminatorExpression});
        }
        SIBUuid12 topicSpaceUuid = topicSpace.getBaseUuid();
        String topicSpaceStr = topicSpaceUuid.toString();
        String theTopic = null;
        try {
            DiscriminatorMatchSpaceKey msk = new DiscriminatorMatchSpaceKey(discriminatorExpression);
            theTopic = this.buildSendTopicExpression(topicSpaceStr, discriminatorExpression);
            MessageProcessorSearchResults searchResults = (MessageProcessorSearchResults)this._messageProcessor.getSearchResultsObjectPool().remove();
            searchResults.reset();
            if (this._isBusSecure) {
                searchResults.setTopicSpace(topicSpace);
            }
            EvalCache cache = this._matching.createEvalCache();
            this.search(theTopic, msk, cache, searchResults);
            Object[] allResults = searchResults.getResults(theTopic);
            localConsumers.addAll((Set)allResults[1]);
            remoteConsumers.addAll((Set)allResults[3]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Found " + localConsumers.size() + " local consumers and " + remoteConsumers.size() + "remote consumers in MatchSpace search"));
            }
            this._messageProcessor.getSearchResultsObjectPool().add(searchResults);
        }
        catch (BadMessageFormatMatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveNonSelectorConsumers", (String)"1:2439:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveNonSelectorConsumers", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2450:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2458:1.117.1.11", e}, null), (Throwable)e);
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveNonSelectorConsumers", (String)"1:2469:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveNonSelectorConsumers", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2479:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2486:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveNonSelectorConsumers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterConsumerSetMonitor(ConnectionImpl connection, ConsumerSetChangeCallback callback) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterConsumerSetMonitor", (Object)new Object[]{connection, callback});
        }
        Map map = this._targets;
        synchronized (map) {
            this._consumerMonitoring.deregisterConsumerSetMonitor(connection, callback);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterConsumerSetMonitor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumerSetMonitors(ConnectionImpl connection) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerSetMonitors", (Object)new Object[]{connection});
        }
        Map map = this._targets;
        synchronized (map) {
            this._consumerMonitoring.removeConsumerSetMonitors(connection);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerSetMonitors");
        }
    }

    public boolean evaluateDiscriminator(String fullTopic, String wildcardTopic) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"evaluateDiscriminator", (Object)new Object[]{fullTopic, wildcardTopic});
        }
        boolean discriminatorMatches = this.evaluateDiscriminator(fullTopic, wildcardTopic, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"evaluateDiscriminator", (Object)discriminatorMatches);
        }
        return discriminatorMatches;
    }

    public boolean evaluateDiscriminator(String fullTopic, String wildcardTopic, Selector discriminatorTree) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"evaluateDiscriminator", (Object)new Object[]{fullTopic, wildcardTopic, discriminatorTree});
        }
        Object result = null;
        boolean discriminatorMatches = false;
        EvalCache cache = EvalCache.DUMMY;
        try {
            Evaluator evaluator = Matching.getEvaluator();
            DiscriminatorMatchSpaceKey msk = new DiscriminatorMatchSpaceKey(fullTopic);
            if (discriminatorTree == null) {
                discriminatorTree = this.parseDiscriminator(wildcardTopic);
            }
            if ((result = evaluator.eval(discriminatorTree, msk, cache, null, false)) != null && ((Boolean)result).booleanValue()) {
                discriminatorMatches = true;
            }
        }
        catch (BadMessageFormatMatchingException qex) {
            FFDCFilter.processException((Throwable)qex, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.evaluateDiscriminator", (String)"1:2623:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)qex));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"evaluateDiscriminator", (Object)"SICoreException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2633:1.117.1.11", qex});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2643:1.117.1.11", qex}, null), (Throwable)qex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"evaluateDiscriminator", (Object)discriminatorMatches);
        }
        return discriminatorMatches;
    }

    public String retrieveNonWildcardStem(String topic) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"retrieveNonWildcardStem", (Object)new Object[]{topic});
        }
        String stem = null;
        int wildMany = topic.indexOf("//");
        int wildOne = topic.indexOf(42);
        stem = wildOne > -1 ? (wildMany > wildOne ? topic.substring(0, wildOne - 1) : (wildMany > -1 ? topic.substring(0, wildMany) : topic.substring(0, wildOne - 1))) : (wildMany > -1 ? topic.substring(0, wildMany) : topic);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveNonWildcardStem", (Object)stem);
        }
        return stem;
    }

    public ConsumerMonitoring getConsumerMonitoring() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerMonitoring");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerMonitoring", (Object)this._consumerMonitoring);
        }
        return this._consumerMonitoring;
    }

    public void addApplicationSignatureMatchTarget(ApplicationSignature appSignature, SIBUuid12 destUuid, SIBUuid8 cmUuid, SelectionCriteria criteria) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addApplicationSignatureMatchTarget", (Object)new Object[]{appSignature, destUuid, cmUuid, criteria});
        }
        MatchingApplicationSignature mas = new MatchingApplicationSignature(appSignature);
        String mSpacePrefix = destUuid.toString() + '/' + cmUuid.toString();
        String theTopic = null;
        theTopic = criteria != null && criteria.getDiscriminator() != null ? this.buildAddTopicExpression(mSpacePrefix, criteria.getDiscriminator()) : mSpacePrefix;
        try {
            String selectorString = null;
            SelectorDomain selectorDomain = SelectorDomain.SIMESSAGE;
            Map selectorProperties = null;
            Resolver resolver = null;
            if (criteria != null) {
                selectorString = criteria.getSelectorString();
                selectorDomain = criteria.getSelectorDomain();
                if (criteria instanceof MPSelectionCriteria) {
                    MPSelectionCriteria mpCriteria = (MPSelectionCriteria)criteria;
                    selectorProperties = mpCriteria.getSelectorProperties();
                }
                if (selectorString != null && selectorString.trim().length() != 0) {
                    resolver = selectorDomain.equals((Object)SelectorDomain.JMS) ? this._jmsResolver : (selectorDomain.equals((Object)SelectorDomain.SIMESSAGE) ? this._simessageResolver : this._defaultResolver);
                }
            }
            this.addTarget(appSignature, theTopic, selectorString, selectorDomain, resolver, mas, null, selectorProperties);
        }
        catch (QuerySyntaxException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addApplicationSignatureMatchTarget", (Object)"SISelectorSyntaxException");
            }
            throw new SISelectorSyntaxException(nls.getFormattedMessage("INVALID_SELECTOR_ERROR_CWSIP0371", new Object[]{criteria}, null));
        }
        catch (InvalidTopicSyntaxException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addApplicationSignatureMatchTarget", (Object)"SIDiscriminatorSyntaxException");
            }
            String theTopicString = criteria != null && criteria.getDiscriminator() != null ? criteria.getDiscriminator() : mSpacePrefix;
            throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{theTopicString}, null));
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.addApplicationSignatureMatchTarget", (String)"1:2856:1.117.1.11", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addApplicationSignatureMatchTarget", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2865:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2873:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addApplicationSignatureMatchTarget");
        }
    }

    public void retrieveMatchingApplicationSignatures(SIBUuid12 destUuid, SIBUuid8 cmUuid, JsMessage msg, MessageProcessorSearchResults searchResults) throws SIDiscriminatorSyntaxException {
        block11: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"retrieveMatchingApplicationSignatures", (Object)new Object[]{destUuid, cmUuid, msg, searchResults});
            }
            String mSpacePrefix = destUuid.toString() + '/' + cmUuid.toString();
            try {
                searchResults.reset();
                EvalCache cache = this._matching.createEvalCache();
                String discriminator = msg.getDiscriminator();
                if (discriminator != null) {
                    try {
                        _syntaxChecker.checkEventTopicSyntax(discriminator);
                        String theTopic = this.buildSendTopicExpression(mSpacePrefix, discriminator);
                        this.search(theTopic, (MatchSpaceKey)msg, cache, searchResults);
                        break block11;
                    }
                    catch (InvalidTopicSyntaxException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingApplicationSignatures", (Object)((Object)e));
                        }
                        throw new SIDiscriminatorSyntaxException(nls.getFormattedMessage("INVALID_TOPIC_ERROR_CWSIP0372", new Object[]{discriminator}, null));
                    }
                }
                this.search(mSpacePrefix, (MatchSpaceKey)msg, cache, searchResults);
            }
            catch (BadMessageFormatMatchingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingApplicationSignatures", (String)"1:2965:1.117.1.11", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingApplicationSignatures", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2976:1.117.1.11", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:2984:1.117.1.11", e}, null), (Throwable)e);
            }
            catch (MatchingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.retrieveMatchingApplicationSignatures", (String)"1:2995:1.117.1.11", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingApplicationSignatures", (Object)"SIErrorException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:3006:1.117.1.11", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:3014:1.117.1.11", e}, null), (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveMatchingApplicationSignatures");
        }
    }

    public void removeApplicationSignatureMatchTarget(ApplicationSignature appSignature) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeApplicationSignatureMatchTarget", (Object)appSignature);
        }
        try {
            this.removeTarget(appSignature);
        }
        catch (MatchingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.matching.MessageProcessorMatching.removeApplicationSignatureMatchTarget", (String)"1:3045:1.117.1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeApplicationSignatureMatchTarget", (Object)"SICoreException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:3056:1.117.1.11", e});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.matching.MessageProcessorMatching", "1:3064:1.117.1.11", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeApplicationSignatureMatchTarget");
        }
    }

    private static class Target {
        private Conjunction[] expr;
        private MatchTarget[] targets;

        Target(Conjunction[] expr, MatchTarget[] targets) {
            this.expr = expr;
            this.targets = targets;
        }
    }

    private class DiscriminatorMatchSpaceKey
    implements MatchSpaceKey {
        private String value;

        public DiscriminatorMatchSpaceKey(String discriminator) {
            this.value = discriminator;
        }

        public Object getIdentifierValue(Identifier id, boolean ignoreType) {
            return this.value;
        }

        public Object getIdentifierValue(Identifier id, boolean ignoreType, Object contextValue, boolean returnList) {
            return this.value;
        }

        public Object getRootContext() {
            return null;
        }
    }
}

