/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.admin.QualifiedDestinationName;
import com.ibm.ws.sib.admin.SIBDestination;
import com.ibm.ws.sib.admin.internal.BaseDestinationDefinitionImpl;
import com.ibm.ws.sib.admin.internal.DestinationConfigType;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.util.HashMap;
import java.util.Map;

public class DestinationDefinitionImpl
extends BaseDestinationDefinitionImpl
implements DestinationDefinition {
    private static final TraceComponent tc = SibTr.register(DestinationDefinitionImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private int _defaultPriority = 0;
    private Map _destinationContext = new HashMap();
    private String _exceptionDestination = null;
    private QualifiedDestinationName[] _forwardRoutingPath = null;
    private int _maxFailedDeliveries = 5;
    private boolean _isRedeliveryCountPersisted = false;
    private Reliability _maxReliability;
    private boolean _producerQOSOverrideEnabled = true;
    private boolean _receiveAllowed = true;
    private boolean _receiveExclusive = false;
    private Reliability _reliability;
    private QualifiedDestinationName _replyDestination = null;
    private boolean _sendAllowed = true;
    private boolean _topicAccessCheckRequired = true;
    private boolean _isOrderingRequired = false;
    private boolean _isAuditAllowed = true;
    private long _blockedRetryTimeout;
    private Reliability _exceptionDiscardReliability = Reliability.BEST_EFFORT_NONPERSISTENT;
    public long _alterationTime;

    public DestinationDefinitionImpl(DestinationType type, String name) {
        super(type, name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DestinationDefinitionImpl", (Object)new Object[]{type, name});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DestinationDefinitionImpl", (Object)this);
        }
    }

    DestinationDefinitionImpl(LWMConfig dest) {
        super(dest);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DestinationDefinitionImpl", (Object)dest);
        }
        this.setConfigType(DestinationConfigType.LOCAL);
        this._destinationType = ((SIBDestination)dest).getDestinationType();
        this.setFromConfig(dest);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DestinationDefinitionImpl", (Object)this);
        }
    }

    @Override
    protected DestinationConfigType getConfigType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConfigType", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConfigType", (Object)this._type);
        }
        return this._type;
    }

    @Override
    protected void setConfigType(DestinationConfigType d) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setConfigType", (Object)d);
        }
        this._type = d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setConfigType");
        }
    }

    @Override
    protected void setFromConfig(LWMConfig dest) {
        String _rs;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setFromConfig", (Object)dest);
        }
        super.setFromConfig(dest);
        SIBDestination destConfig = (SIBDestination)dest;
        this._defaultPriority = destConfig.getDefaultPriority();
        this._exceptionDestination = destConfig.getExceptionDestination();
        this._maxFailedDeliveries = destConfig.getMaxFailedDeliveries();
        this._isRedeliveryCountPersisted = destConfig.isPersistRedeliveryCount();
        this._producerQOSOverrideEnabled = destConfig.isOverrideOfQOSByProducerAllowed();
        this._receiveAllowed = destConfig.isReceiveAllowed();
        if (this._destinationType == DestinationType.QUEUE) {
            this._receiveExclusive = destConfig.isReceiveExclusive();
        }
        if ((_rs = destConfig.getDefaultReliability()).equals("BEST_EFFORT_NONPERSISTENT")) {
            this._reliability = Reliability.BEST_EFFORT_NONPERSISTENT;
        } else if (_rs.equals("ASSURED_PERSISTENT")) {
            this._reliability = Reliability.ASSURED_PERSISTENT;
        } else if (_rs.equals("EXPRESS_NONPERSISTENT")) {
            this._reliability = Reliability.EXPRESS_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_NONPERSISTENT")) {
            this._reliability = Reliability.RELIABLE_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_PERSISTENT")) {
            this._reliability = Reliability.RELIABLE_PERSISTENT;
        }
        _rs = destConfig.getMaximumReliability();
        if (_rs.equals("BEST_EFFORT_NONPERSISTENT")) {
            this._maxReliability = Reliability.BEST_EFFORT_NONPERSISTENT;
        } else if (_rs.equals("ASSURED_PERSISTENT")) {
            this._maxReliability = Reliability.ASSURED_PERSISTENT;
        } else if (_rs.equals("EXPRESS_NONPERSISTENT")) {
            this._maxReliability = Reliability.EXPRESS_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_NONPERSISTENT")) {
            this._maxReliability = Reliability.RELIABLE_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_PERSISTENT")) {
            this._maxReliability = Reliability.RELIABLE_PERSISTENT;
        }
        _rs = destConfig.getExceptionDiscardReliability();
        if (_rs.equals("BEST_EFFORT_NONPERSISTENT")) {
            this._exceptionDiscardReliability = Reliability.BEST_EFFORT_NONPERSISTENT;
        } else if (_rs.equals("ASSURED_PERSISTENT")) {
            this._exceptionDiscardReliability = Reliability.ASSURED_PERSISTENT;
        } else if (_rs.equals("EXPRESS_NONPERSISTENT")) {
            this._exceptionDiscardReliability = Reliability.EXPRESS_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_NONPERSISTENT")) {
            this._exceptionDiscardReliability = Reliability.RELIABLE_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_PERSISTENT")) {
            this._exceptionDiscardReliability = Reliability.RELIABLE_PERSISTENT;
        }
        this._sendAllowed = destConfig.isSendAllowed();
        if (this._destinationType == DestinationType.TOPICSPACE) {
            this._topicAccessCheckRequired = destConfig.isTopicAccessCheckRequired();
        }
        this._isOrderingRequired = destConfig.isMaintainStrictOrder();
        if (this._isOrderingRequired && !this._receiveExclusive) {
            this.setReceiveExclusive(true);
            SibTr.debug((TraceComponent)tc, (String)"RECEIVE_EXCLUSIVE_OVERRIDE_WARNING_SIAS0048", (Object)new Object[]{destConfig.getName()});
        }
        this._blockedRetryTimeout = destConfig.getBlockedRetryTimeout();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setFromConfig");
        }
    }

    public int getDefaultPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultPriority", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Integer i = this._defaultPriority;
            SibTr.exit((TraceComponent)tc, (String)"getDefaultPriority", (Object)i);
        }
        return this._defaultPriority;
    }

    public void setDefaultPriority(int value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Integer i = value;
            SibTr.entry((TraceComponent)tc, (String)"setDefaultPriority", (Object)i);
        }
        this._defaultPriority = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDefaultPriority");
        }
    }

    public Reliability getDefaultReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultReliability", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Integer i = this._reliability.toInt();
            SibTr.exit((TraceComponent)tc, (String)"getDefaultReliability", (Object)(i + " " + this._reliability.toString()));
        }
        return this._reliability;
    }

    public void setDefaultReliability(Reliability value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Integer i = value.toInt();
            SibTr.entry((TraceComponent)tc, (String)"setDefaultReliability", (Object)(i + " " + value.toString()));
        }
        this._reliability = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDefaultReliability");
        }
    }

    @Override
    public Map getDestinationContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationContext", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationContext", (Object)this._destinationContext.toString());
        }
        return this._destinationContext;
    }

    @Override
    public void setDestinationContext(Map value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationContext", (Object)value.toString());
        }
        this._destinationContext = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationContext");
        }
    }

    public DestinationType getDestinationType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationType", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationType", (Object)this._destinationType.toString());
        }
        return this._destinationType;
    }

    public String getExceptionDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExceptionDestination", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExceptionDestination", (Object)this._exceptionDestination);
        }
        return this._exceptionDestination;
    }

    public void setExceptionDestination(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setExceptionDestination", (Object)value);
        }
        this._exceptionDestination = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setExceptionDestination");
        }
    }

    public Reliability getExceptionDiscardReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExceptionDiscardReliability", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExceptionDiscardReliability", (Object)this._exceptionDiscardReliability);
        }
        return this._exceptionDiscardReliability;
    }

    public void setExceptionDiscardReliability(Reliability value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setExceptionDiscardReliability", (Object)value.toString());
        }
        this._exceptionDiscardReliability = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setExceptionDiscardReliability");
        }
    }

    public int getMaxFailedDeliveries() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaxFailedDeliveries", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Integer i = this._maxFailedDeliveries;
            SibTr.exit((TraceComponent)tc, (String)"getMaxFailedDeliveries", (Object)i);
        }
        return this._maxFailedDeliveries;
    }

    public boolean isRedeliveryCountPersisted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRedeliveryCountPersisted", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean i = this._isRedeliveryCountPersisted;
            SibTr.exit((TraceComponent)tc, (String)"isRedeliveryCountPersisted", (Object)i);
        }
        return this._isRedeliveryCountPersisted;
    }

    public void setMaxFailedDeliveries(int value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Integer i = value;
            SibTr.entry((TraceComponent)tc, (String)"setMaxFailedDeliveries", (Object)i);
        }
        this._maxFailedDeliveries = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMaxFailedDeliveries");
        }
    }

    public void setRedeliveryCountPersisted(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean i = value;
            SibTr.entry((TraceComponent)tc, (String)"setRedeliveryCountPersisted", (Object)i);
        }
        this._isRedeliveryCountPersisted = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRedeliveryCountPersisted");
        }
    }

    public boolean isReceiveAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReceiveAllowed", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = this._receiveAllowed;
            SibTr.exit((TraceComponent)tc, (String)"isReceiveAllowed", (Object)b);
        }
        return this._receiveAllowed;
    }

    public void setReceiveAllowed(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = value;
            SibTr.entry((TraceComponent)tc, (String)"setReceiveAllowed", (Object)b.toString());
        }
        this._receiveAllowed = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReceiveAllowed");
        }
    }

    public Reliability getMaxReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaxReliability", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMaxReliability", (Object)this._maxReliability.toString());
        }
        return this._maxReliability;
    }

    public void setMaxReliability(Reliability value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMaxReliability", (Object)value.toString());
        }
        this._maxReliability = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMaxReliability");
        }
    }

    public boolean isOverrideOfQOSByProducerAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isOverrideOfQOSByProducerAllowed", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = this._producerQOSOverrideEnabled;
            SibTr.exit((TraceComponent)tc, (String)"isOverrideOfQOSByProducerAllowed", (Object)b);
        }
        return this._producerQOSOverrideEnabled;
    }

    public void setOverrideOfQOSByProducerAllowed(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = value;
            SibTr.entry((TraceComponent)tc, (String)"setOverrideOfQOSByProducerAllowed", (Object)b.toString());
        }
        this._producerQOSOverrideEnabled = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setOverrideOfQOSByProducerAllowed");
        }
    }

    public boolean isProducerQOSOverrideEnabled() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isProducerQOSOverrideEnabled", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = this._producerQOSOverrideEnabled;
            SibTr.exit((TraceComponent)tc, (String)"isProducerQOSOverrideEnabled", (Object)b);
        }
        return this._producerQOSOverrideEnabled;
    }

    public void setProducerQOSOverrideEnabled(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = value;
            SibTr.entry((TraceComponent)tc, (String)"setProducerQOSOverrideEnabled", (Object)b.toString());
        }
        this._producerQOSOverrideEnabled = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setProducerQOSOverrideEnabled");
        }
    }

    public boolean isReceiveExclusive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReceiveExclusive", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = this._receiveExclusive;
            SibTr.exit((TraceComponent)tc, (String)"isReceiveExclusive", (Object)b);
        }
        return this._receiveExclusive;
    }

    public void setReceiveExclusive(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = value;
            SibTr.entry((TraceComponent)tc, (String)"setReceiveExclusive", (Object)b.toString());
        }
        this._receiveExclusive = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReceiveExclusive");
        }
    }

    public boolean isSendAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = this._sendAllowed;
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)b);
        }
        return this._sendAllowed;
    }

    public void setSendAllowed(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = value;
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)b.toString());
        }
        this._sendAllowed = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSendAllowed");
        }
    }

    public QualifiedDestinationName getReplyDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReplyDestination", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReplyDestination", (Object)this._replyDestination);
        }
        return this._replyDestination;
    }

    public void setReplyDestination(QualifiedDestinationName value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setReplyDestination", (Object)value);
        }
        this._replyDestination = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReplyDestination");
        }
    }

    public QualifiedDestinationName[] getForwardRoutingPath() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForwardRoutingPath", (Object)this);
        }
        QualifiedDestinationName[] returnValue = null;
        if (this._forwardRoutingPath != null) {
            returnValue = new QualifiedDestinationName[this._forwardRoutingPath.length];
            System.arraycopy(this._forwardRoutingPath, 0, returnValue, 0, this._forwardRoutingPath.length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getForwardRoutingPath", (Object)returnValue);
        }
        return returnValue;
    }

    public void setForwardRoutingPath(QualifiedDestinationName[] newValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setForwardRoutingPath", (Object)newValue);
        }
        if (newValue == null) {
            this._forwardRoutingPath = null;
        } else {
            this._forwardRoutingPath = new QualifiedDestinationName[newValue.length];
            System.arraycopy(newValue, 0, this._forwardRoutingPath, 0, newValue.length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setForwardRoutingPath");
        }
    }

    public boolean isTopicAccessCheckRequired() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTopicAccessCheckRequired", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = this._topicAccessCheckRequired;
            SibTr.exit((TraceComponent)tc, (String)"isTopicAccessCheckRequired", (Object)b);
        }
        return this._topicAccessCheckRequired;
    }

    public void setTopicAccessCheckRequired(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = value;
            SibTr.entry((TraceComponent)tc, (String)"setTopicAccessCheckRequired", (Object)b.toString());
        }
        this._topicAccessCheckRequired = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTopicAccessCheckRequired");
        }
    }

    public long getAlterationTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAlterationTime", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAlterationTime", (Object)this._alterationTime);
        }
        return this._alterationTime;
    }

    public void setAlterationTime(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Long l = value;
            SibTr.entry((TraceComponent)tc, (String)"setAlterationTime", (Object)l);
        }
        this._alterationTime = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAlterationTime");
        }
    }

    public long getBlockedRetryTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBlockedRetryTimeout", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBlockedRetryTimeout", (Object)this._blockedRetryTimeout);
        }
        return this._blockedRetryTimeout;
    }

    public void setBlockedRetryTimeout(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Long l = value;
            SibTr.entry((TraceComponent)tc, (String)"setBlockedRetryTimeout", (Object)l);
        }
        this._blockedRetryTimeout = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBlockedRetryTimeout");
        }
    }

    public boolean isOrderingRequired() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isOrderingRequired", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isOrderingRequired", (Object)this._isOrderingRequired);
        }
        return this._isOrderingRequired;
    }

    public void maintainMsgOrder(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Boolean b = value;
            SibTr.entry((TraceComponent)tc, (String)"maintainMsgOrder", (Object)b.toString());
        }
        this._isOrderingRequired = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"maintainMsgOrder");
        }
    }

    public boolean isAuditAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAuditAllowed", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isAuditAllowed", (Object)this._isAuditAllowed);
        }
        return this._isAuditAllowed;
    }

    void setAuditAllowed(boolean auditAllowed) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAuditAllowed", (Object)auditAllowed);
        }
        this._isAuditAllowed = auditAllowed;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAuditAllowed");
        }
    }

    public void reset(LWMConfig sibdd) {
        this.setFromConfig(sibdd);
    }
}

