/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal.variables;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.admin.internal.ConfigurationStorageHelper;
import com.ibm.ws.config.xml.ConfigVariables;
import com.ibm.ws.config.xml.LibertyVariable;
import com.ibm.ws.config.xml.internal.ConfigComparator;
import com.ibm.ws.config.xml.internal.StringUtils;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.config.xml.internal.variables.AbstractLibertyVariable;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConfigVariableRegistry
implements VariableRegistry,
ConfigVariables {
    private static final TraceComponent tc = Tr.register(ConfigVariableRegistry.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    public static final String UNIQUE = "UNIQUE_";
    public static final String IN_USE = "WLP_VAR_IN_USE";
    private final VariableRegistry registry;
    private final File variableCacheFile;
    private Map<String, LibertyVariable> configVariables;
    private Map<String, LibertyVariable> defaultConfigVariables;
    private volatile Map<String, String> userDefinedVariableMap;
    private volatile Map<String, String> userDefinedVariableDefaultsMap;
    private Map<String, Object> variableCache;
    private Map<String, Object> defaultVariableCache;
    private final List<CommandLineVariable> commandLineVariables = new ArrayList<CommandLineVariable>();
    private final StringUtils stringUtils = new StringUtils();
    private final HashMap<String, FileSystemVariable> fileSystemVariables;
    private final List<String> fileVariableRootDirs = new ArrayList<String>();
    private final List<File> fsVarRootDirectoryFiles = new ArrayList<File>();
    static final long serialVersionUID = 5388473541685433023L;

    public ConfigVariableRegistry(VariableRegistry registry, String[] cmdArgs, File variableCacheFile, WsLocationAdmin locationService) {
        this.registry = registry;
        String fileVariableDirString = locationService.resolveString("${wlp.var.src.dirs}/");
        StringTokenizer st = new StringTokenizer(fileVariableDirString, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.fileVariableRootDirs.add(token);
            this.fsVarRootDirectoryFiles.add(new File(token));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Adding file system variable source: " + token), (Object[])new Object[0]);
        }
        this.fileSystemVariables = new HashMap();
        this.configVariables = Collections.emptyMap();
        this.defaultConfigVariables = Collections.emptyMap();
        this.variableCacheFile = variableCacheFile;
        if (variableCacheFile != null) {
            this.loadVariableCache();
        }
        if (this.variableCache == null) {
            this.variableCache = new HashMap<String, Object>();
        }
        if (this.defaultVariableCache == null) {
            this.defaultVariableCache = new HashMap<String, Object>();
        }
        for (String cmdArg : cmdArgs) {
            CommandLineVariable clv = new CommandLineVariable(cmdArg);
            if (!clv.isValid()) continue;
            this.commandLineVariables.add(clv);
            registry.replaceVariable(clv.getName(), clv.getValue());
        }
        this.processVarFiles((p, c) -> {
            if (c.getName().endsWith(".properties") && p.equals(c)) {
                try (FileInputStream fis = new FileInputStream((File)c);){
                    Properties props = new Properties();
                    props.load(fis);
                    props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.fileSystemVariables.put((String)key, new FileSystemVariable((File)c, (String)key, (String)value))));
                }
                catch (IOException ex) {
                    Tr.error((TraceComponent)tc, (String)"error.bad.variable.file", (Object[])new Object[]{c.getAbsolutePath()});
                }
            } else {
                String varName = p.equals(c) ? c.getName() : p.getName() + "/" + c.getName();
                this.fileSystemVariables.put(varName, new FileSystemVariable((File)c));
            }
        });
        this.updateUserDefinedVariableMap();
        this.updateUserDefinedVariableDefaultsMap();
        CheckpointPhase.getPhase().addSingleThreadedHook(-2147483548, new CheckpointHook(){
            private final Map<File, Long> trackedFiles = new HashMap<File, Long>(0);
            static final long serialVersionUID = -3373795360306970918L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void prepare() {
                ConfigVariableRegistry.this.processVarFiles((p, c) -> this.trackedFiles.put((File)c, ConfigVariableRegistry.reduceTimestampPrecision(c.lastModified())));
            }

            public void restore() {
                ArrayList<File> deletedFiles = new ArrayList<File>(0);
                ArrayList<File> createdFiles = new ArrayList<File>(0);
                ArrayList<File> modifiedFiles = new ArrayList<File>(0);
                ConfigVariableRegistry.this.processVarFiles((p, c) -> {
                    Long existing = this.trackedFiles.remove(c);
                    if (existing == null) {
                        createdFiles.add((File)c);
                    } else if (!existing.equals(ConfigVariableRegistry.reduceTimestampPrecision(c.lastModified()))) {
                        modifiedFiles.add((File)c);
                    }
                });
                this.trackedFiles.forEach((v, t) -> deletedFiles.add((File)v));
                this.trackedFiles.clear();
                HashMap<String, ConfigComparator.DeltaType> deltaMap = new HashMap<String, ConfigComparator.DeltaType>(0);
                ConfigVariableRegistry.this.removeFileSystemVariableDeletes(deletedFiles, deltaMap);
                ConfigVariableRegistry.this.addFileSystemVariableCreates(createdFiles, deltaMap);
                ConfigVariableRegistry.this.modifyFileSystemVariables(modifiedFiles, deltaMap);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry$1", 1.class, null, null);
            }
        });
    }

    final void processVarFiles(BiConsumer<File, File> processor) {
        for (File bindings : this.fsVarRootDirectoryFiles) {
            if (!bindings.exists() || !bindings.isDirectory()) continue;
            for (File f : bindings.listFiles()) {
                if (f.isFile()) {
                    processor.accept(f, f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                for (File varFile : f.listFiles()) {
                    if (!varFile.isFile()) continue;
                    processor.accept(f, varFile);
                }
            }
        }
    }

    static final long reduceTimestampPrecision(long value) {
        return value / 1000L * 1000L;
    }

    @Sensitive
    public Map<String, LibertyVariable> getConfigVariables() {
        return this.configVariables;
    }

    @Sensitive
    public Map<String, LibertyVariable> getDefaultConfigVariables() {
        return this.defaultConfigVariables;
    }

    public void updateSystemVariables(@Sensitive Map<String, LibertyVariable> newVariables) {
        for (String string : this.configVariables.keySet()) {
            if (newVariables.containsKey(string)) continue;
            LibertyVariable defaultInstanceVar = this.defaultConfigVariables.get(string);
            if (defaultInstanceVar == null || defaultInstanceVar.getValue() == null) {
                this.registry.removeVariable(string);
                continue;
            }
            this.registry.replaceVariable(string, defaultInstanceVar.getValue());
        }
        for (Map.Entry entry : newVariables.entrySet()) {
            String variableName = (String)entry.getKey();
            String variableValue = ((LibertyVariable)entry.getValue()).getValue();
            if (variableValue != null) {
                this.registry.replaceVariable(variableName, variableValue);
                continue;
            }
            this.registry.removeVariable(variableName);
        }
        this.configVariables = newVariables;
        for (CommandLineVariable commandLineVariable : this.commandLineVariables) {
            this.registry.replaceVariable(commandLineVariable.getName(), commandLineVariable.getValue());
        }
        for (LibertyVariable libertyVariable : this.fileSystemVariables.values()) {
            this.registry.addVariable(libertyVariable.getName(), libertyVariable.getValue());
        }
        this.updateUserDefinedVariableMap();
        this.updateUserDefinedVariableDefaultsMap();
    }

    public synchronized void updateVariableCache(Map<String, Object> variables) {
        boolean dirty = false;
        String variableSrcDirsKey = "wlp.var.src.dirs";
        if (this.variableCache.get(variableSrcDirsKey) == null) {
            String variableSrcDirsValue = this.lookupVariable(variableSrcDirsKey);
            this.variableCache.put(variableSrcDirsKey, variableSrcDirsValue);
            dirty = true;
        }
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            Object variableValue;
            LibertyVariable var;
            String variableName = entry.getKey();
            if (this.configVariables.containsKey(variableName) && (var = this.configVariables.get(variableName)).getDefaultValue() == null || this.isVariableCached(variableName, variableValue = entry.getValue())) continue;
            this.variableCache.put(variableName, variableValue);
            dirty = true;
        }
        if (dirty) {
            this.saveVariableCache();
        }
    }

    private boolean isVariableCached(String variableName, Object variableValue) {
        if (this.variableCache.containsKey(variableName)) {
            Object cachedVariableValue = this.variableCache.get(variableName);
            return Objects.equals(cachedVariableValue, variableValue);
        }
        return false;
    }

    public synchronized Map<String, ConfigComparator.DeltaType> variablesChanged() {
        HashMap<String, ConfigComparator.DeltaType> changed = null;
        for (Map.Entry<String, Object> entry : this.variableCache.entrySet()) {
            ConfigComparator.DeltaType deltaType;
            String variableName = entry.getKey();
            Object oldVariableValue = entry.getValue();
            Object newVariableValue = this.lookupVariable(variableName);
            if (newVariableValue == null) {
                newVariableValue = this.defaultVariableCache.get(variableName);
            }
            if (newVariableValue == null) {
                newVariableValue = this.lookupVariableFromAdditionalSources(variableName);
            }
            if (newVariableValue == null) {
                LibertyVariable cv = this.configVariables.get(variableName);
                Object object = newVariableValue = cv == null ? null : cv.getDefaultValue();
            }
            if ((deltaType = this.getDeltaType(oldVariableValue, newVariableValue)) == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Variable " + variableName + " has changed. "), (Object[])new Object[0]);
            }
            if (changed == null) {
                changed = new HashMap<String, ConfigComparator.DeltaType>();
            }
            changed.put(variableName, deltaType);
        }
        return changed == null ? Collections.emptyMap() : changed;
    }

    ConfigComparator.DeltaType getDeltaType(Object oldValue, Object newValue) {
        if (oldValue == null) {
            return newValue != null ? ConfigComparator.DeltaType.ADDED : null;
        }
        if (newValue == null) {
            return ConfigComparator.DeltaType.REMOVED;
        }
        return oldValue.equals(newValue) ? null : ConfigComparator.DeltaType.MODIFIED;
    }

    public String lookupVariableFromAdditionalSources(String variableName) {
        String value = null;
        value = this.lookupVariable("env." + variableName);
        if (value == null) {
            variableName = this.stringUtils.replaceNonAlpha(variableName);
            value = this.lookupVariable("env." + variableName);
        }
        if (value == null) {
            variableName = variableName.toUpperCase();
            value = this.lookupVariable("env." + variableName);
        }
        return value;
    }

    public synchronized void clearVariableCache() {
        this.variableCache.clear();
        this.defaultVariableCache.clear();
    }

    @Sensitive
    public String lookupVariable(String variableName) {
        String resolvedVar;
        String varReference = "${" + variableName + "}";
        if (varReference.equalsIgnoreCase(resolvedVar = this.registry.resolveRawString(varReference))) {
            return null;
        }
        return resolvedVar;
    }

    @FFDCIgnore(value={Exception.class})
    private synchronized void loadVariableCache() {
        block6: {
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.variableCacheFile)));
                try {
                    this.variableCache = new HashMap<String, Object>();
                    ConfigurationStorageHelper.readMap(in, ConfigurationStorageHelper.toMapOrDictionary(this.variableCache));
                    this.defaultVariableCache = new HashMap<String, Object>();
                    ConfigurationStorageHelper.readMap(in, ConfigurationStorageHelper.toMapOrDictionary(this.defaultVariableCache));
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry", (String)"570", (Object)this, (Object[])new Object[0]);
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry", (String)"570", (Object)this, (Object[])new Object[0]);
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                in.close();
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)("loadVariableCache():  Exception = " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={IOException.class})
    private synchronized void saveVariableCache() {
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.variableCacheFile)));
            try {
                ConfigurationStorageHelper.writeMap(out, ConfigurationStorageHelper.toMapOrDictionary(this.variableCache));
                ConfigurationStorageHelper.writeMap(out, ConfigurationStorageHelper.toMapOrDictionary(this.defaultVariableCache));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry", (String)"582", (Object)this, (Object[])new Object[0]);
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry", (String)"582", (Object)this, (Object[])new Object[0]);
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            out.close();
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("saveVariableCache():  Exception = " + e.getMessage()), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)e, (String)ConfigVariableRegistry.class.getName(), (String)("saveVariableCache(): Exception = " + e.getMessage()));
        }
    }

    @Sensitive
    public synchronized void setDefaultVariables(Map<String, LibertyVariable> variables) {
        boolean dirty = false;
        for (Map.Entry<String, LibertyVariable> entry : this.defaultConfigVariables.entrySet()) {
            LibertyVariable configuredVar;
            if (variables.containsKey(entry.getKey()) || (configuredVar = this.configVariables.get(entry.getKey())) != null || entry.getValue().getValue() == null) continue;
            this.registry.removeVariable(entry.getKey());
            this.defaultVariableCache.remove(entry.getKey());
            dirty = true;
        }
        this.defaultConfigVariables = variables;
        for (Map.Entry<String, LibertyVariable> entry : variables.entrySet()) {
            String variableName = entry.getKey();
            String variableValue = entry.getValue().getValue();
            LibertyVariable configVariable = this.configVariables.get(entry.getKey());
            if (configVariable != null || variableValue == null) continue;
            this.registry.replaceVariable(variableName, variableValue);
            Object oldValue = this.defaultVariableCache.put(variableName, variableValue);
            dirty = oldValue == null ? true : !oldValue.equals(variableValue);
        }
        if (dirty) {
            this.saveVariableCache();
        }
        this.updateUserDefinedVariableMap();
        this.updateUserDefinedVariableDefaultsMap();
    }

    public boolean addVariable(String variable, String value) {
        return this.registry.addVariable(variable, value);
    }

    public void replaceVariable(String variable, String value) {
        this.registry.replaceVariable(variable, value);
    }

    public String resolveString(String variableName) {
        return this.registry.resolveString(variableName);
    }

    public String resolveRawString(String variableName) {
        return this.registry.resolveRawString(variableName);
    }

    public void removeVariable(String symbol) {
        this.registry.removeVariable(symbol);
    }

    public String getUniqueVarString(ExtendedAttributeDefinition attrDef, String value) {
        return UNIQUE + attrDef.getUniqueCategory() + value;
    }

    public void removeUniqueVariable(ExtendedAttributeDefinition attrDef, String attributeValue) {
        this.removeVariable(this.getUniqueVarString(attrDef, attributeValue));
    }

    public void addVariableInUse(String variable) {
        this.addVariable(variable, IN_USE);
    }

    @Override
    @Sensitive
    public Map<String, String> getUserDefinedVariables() {
        return this.userDefinedVariableMap;
    }

    @Sensitive
    private void updateUserDefinedVariableMap() {
        LibertyVariable var;
        HashMap<String, String> userDefinedVariables = new HashMap<String, String>();
        for (Map.Entry<String, FileSystemVariable> entry : this.fileSystemVariables.entrySet()) {
            userDefinedVariables.put(entry.getKey(), entry.getValue().getValue());
        }
        for (Map.Entry<String, LibertyVariable> entry : this.defaultConfigVariables.entrySet()) {
            var = entry.getValue();
            if (var.getValue() == null) continue;
            userDefinedVariables.put(var.getName(), var.getValue());
        }
        for (Map.Entry<String, LibertyVariable> entry : this.configVariables.entrySet()) {
            var = entry.getValue();
            if (var.getValue() == null) continue;
            userDefinedVariables.put(var.getName(), var.getValue());
        }
        for (CommandLineVariable commandLineVariable : this.commandLineVariables) {
            userDefinedVariables.put(commandLineVariable.getName(), commandLineVariable.getValue());
        }
        this.userDefinedVariableMap = Collections.unmodifiableMap(userDefinedVariables);
    }

    public String lookupVariableDefaultValue(String variableName) {
        LibertyVariable cv = this.configVariables.get(variableName);
        if (cv == null) {
            cv = this.defaultConfigVariables.get(variableName);
        }
        return cv == null ? null : cv.getDefaultValue();
    }

    @Override
    public Map<String, String> getUserDefinedVariableDefaults() {
        return this.userDefinedVariableDefaultsMap;
    }

    private void updateUserDefinedVariableDefaultsMap() {
        LibertyVariable var;
        HashMap<String, String> userDefinedVariables = new HashMap<String, String>();
        for (Map.Entry<String, LibertyVariable> entry : this.configVariables.entrySet()) {
            var = entry.getValue();
            if (var.getDefaultValue() == null) continue;
            userDefinedVariables.put(var.getName(), var.getDefaultValue());
        }
        for (Map.Entry<String, LibertyVariable> entry : this.defaultConfigVariables.entrySet()) {
            var = entry.getValue();
            if (userDefinedVariables.containsKey(entry.getKey()) || var.getDefaultValue() == null) continue;
            userDefinedVariables.put(var.getName(), var.getDefaultValue());
        }
        this.userDefinedVariableDefaultsMap = Collections.unmodifiableMap(userDefinedVariables);
    }

    @Override
    public Collection<LibertyVariable> getAllLibertyVariables() {
        ArrayList<LibertyVariable> variables = new ArrayList<LibertyVariable>();
        variables.addAll(this.configVariables.values());
        variables.addAll(this.fileSystemVariables.values());
        variables.addAll(this.commandLineVariables);
        return Collections.unmodifiableCollection(variables);
    }

    public void removeFileSystemVariableDeletes(Collection<File> deletedFiles, Map<String, ConfigComparator.DeltaType> deltaMap) {
        for (File f : deletedFiles) {
            if (f.getName().endsWith(".properties")) {
                Iterator<FileSystemVariable> iter = this.fileSystemVariables.values().iterator();
                while (iter.hasNext()) {
                    FileSystemVariable var = iter.next();
                    if (!f.getName().equals(var.getPropertiesFileName())) continue;
                    iter.remove();
                    deltaMap.put(var.getName(), ConfigComparator.DeltaType.REMOVED);
                    this.registry.removeVariable(var.getName());
                }
                continue;
            }
            if (!this.removeFileSystemVariable(this.getFileSystemVariableName(f))) continue;
            deltaMap.put(f.getName(), ConfigComparator.DeltaType.REMOVED);
        }
        this.updateUserDefinedVariableMap();
    }

    private boolean removeFileSystemVariable(String name) {
        LibertyVariable var = this.fileSystemVariables.remove(name);
        if (var == null) {
            return false;
        }
        this.registry.removeVariable(name);
        return true;
    }

    public void addFileSystemVariableCreates(Collection<File> createdFiles, Map<String, ConfigComparator.DeltaType> deltaMap) {
        for (File file : createdFiles) {
            if (!file.isFile()) continue;
            if (file.getName().endsWith(".properties")) {
                try {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        Properties props = new Properties();
                        props.load(fis);
                        for (String key : props.stringPropertyNames()) {
                            FileSystemVariable sbv = new FileSystemVariable(file, key, props.getProperty(key));
                            this.fileSystemVariables.put(sbv.getName(), sbv);
                            deltaMap.put(key, ConfigComparator.DeltaType.ADDED);
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry", (String)"805", (Object)this, (Object[])new Object[]{createdFiles, deltaMap});
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry", (String)"805", (Object)this, (Object[])new Object[]{createdFiles, deltaMap});
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    fis.close();
                    continue;
                }
                catch (IOException fis) {
                    FFDCFilter.processException((Throwable)fis, (String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry", (String)"813", (Object)this, (Object[])new Object[]{createdFiles, deltaMap});
                    Tr.error((TraceComponent)tc, (String)"error.bad.variable.file", (Object[])new Object[]{file.getAbsolutePath()});
                    continue;
                }
            }
            FileSystemVariable sbv = new FileSystemVariable(file);
            this.fileSystemVariables.put(sbv.getName(), sbv);
            deltaMap.put(sbv.getName(), ConfigComparator.DeltaType.ADDED);
        }
        this.updateUserDefinedVariableMap();
    }

    public void modifyFileSystemVariables(Collection<File> modifiedFiles, Map<String, ConfigComparator.DeltaType> deltaMap) {
        for (File f : modifiedFiles) {
            if (!f.isFile()) continue;
            if (f.getName().endsWith(".properties")) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    try {
                        Properties props = new Properties();
                        props.load(fis);
                        Iterator<FileSystemVariable> iter = this.fileSystemVariables.values().iterator();
                        while (iter.hasNext()) {
                            FileSystemVariable var = iter.next();
                            if (!f.getName().equals(var.getPropertiesFileName())) continue;
                            iter.remove();
                            deltaMap.put(var.getName(), ConfigComparator.DeltaType.REMOVED);
                            this.registry.removeVariable(var.getName());
                        }
                        for (String key : props.stringPropertyNames()) {
                            FileSystemVariable sbv = new FileSystemVariable(f, key, props.getProperty(key));
                            this.fileSystemVariables.put(sbv.getName(), sbv);
                            deltaMap.put(key, ConfigComparator.DeltaType.MODIFIED);
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry", (String)"831", (Object)this, (Object[])new Object[]{modifiedFiles, deltaMap});
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry", (String)"831", (Object)this, (Object[])new Object[]{modifiedFiles, deltaMap});
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    fis.close();
                    continue;
                }
                catch (IOException fis) {
                    FFDCFilter.processException((Throwable)fis, (String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry", (String)"852", (Object)this, (Object[])new Object[]{modifiedFiles, deltaMap});
                    Tr.error((TraceComponent)tc, (String)"error.bad.variable.file", (Object[])new Object[]{f.getAbsolutePath()});
                    continue;
                }
            }
            FileSystemVariable var = new FileSystemVariable(f);
            this.fileSystemVariables.put(var.getName(), var);
            this.registry.removeVariable(var.getName());
            deltaMap.put(var.getName(), ConfigComparator.DeltaType.MODIFIED);
        }
        this.updateUserDefinedVariableMap();
    }

    @Override
    public List<String> getFileSystemVariableRootDirectories() {
        return this.fileVariableRootDirs;
    }

    public String getFileSystemVariableName(File f) {
        String name = f.getName();
        for (File fsVarRootDirectoryFile : this.fsVarRootDirectoryFiles) {
            if (f.getParentFile().compareTo(fsVarRootDirectoryFile) != 0) continue;
            return name;
        }
        return f.getParentFile().getName() + "/" + name;
    }

    @Trivial
    private static final class CommandLineVariable
    extends AbstractLibertyVariable {
        private final String name;
        private final String value;
        private final boolean isValid;

        public CommandLineVariable(String cmdArg) {
            int idx = cmdArg.indexOf(61);
            if (!cmdArg.startsWith("--") || idx <= 2) {
                this.isValid = false;
                this.name = null;
                this.value = null;
            } else {
                this.isValid = true;
                this.name = cmdArg.substring(2, idx);
                this.value = cmdArg.substring(idx + 1);
            }
        }

        public boolean isValid() {
            return this.isValid;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isSensitive() {
            return false;
        }

        @Override
        public LibertyVariable.Source getSource() {
            return LibertyVariable.Source.COMMAND_LINE;
        }

        @Override
        public String getDefaultValue() {
            return null;
        }

        @Trivial
        public String toString() {
            StringBuilder builder = new StringBuilder("CommandLineVariable[");
            builder.append("name=").append(this.name).append(", ");
            builder.append("value=").append(this.getObscuredValue()).append(", ");
            builder.append("source=").append((Object)LibertyVariable.Source.COMMAND_LINE);
            builder.append("]");
            return builder.toString();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected final class FileSystemVariable
    extends AbstractLibertyVariable {
        final String propertiesFileName;
        final String name;
        final File variableFile;
        final String varFileName;
        String value;
        static final long serialVersionUID = 1521248475884948171L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FileSystemVariable(File varFile) {
            this.propertiesFileName = null;
            this.name = null;
            this.variableFile = varFile;
            this.varFileName = ConfigVariableRegistry.this.getFileSystemVariableName(varFile);
            this.value = null;
        }

        public FileSystemVariable(File propertiesFile, String name, String value) {
            this.propertiesFileName = propertiesFile.getName();
            this.name = name;
            this.variableFile = null;
            this.varFileName = null;
            this.value = value;
        }

        @Override
        public String getValue() {
            if (this.value != null) {
                return this.value;
            }
            try {
                List<String> contents = Files.readAllLines(this.variableFile.toPath());
                if (contents != null && !contents.isEmpty()) {
                    this.value = contents.get(0);
                }
            }
            catch (IOException contents) {
                FFDCFilter.processException((Throwable)contents, (String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry$FileSystemVariable", (String)"326", (Object)this, (Object[])new Object[0]);
                Tr.error((TraceComponent)tc, (String)"error.bad.variable.file", (Object[])new Object[]{this.variableFile.getAbsolutePath()});
            }
            return this.value;
        }

        @Override
        @Trivial
        public String getName() {
            return this.name == null ? this.varFileName : this.name;
        }

        @Override
        @Trivial
        public boolean isSensitive() {
            return true;
        }

        @Override
        @Trivial
        public LibertyVariable.Source getSource() {
            return LibertyVariable.Source.FILE_SYSTEM;
        }

        @Override
        @Trivial
        public String getDefaultValue() {
            return null;
        }

        @Trivial
        public String getPropertiesFileName() {
            return this.propertiesFileName;
        }

        @Trivial
        public String toString() {
            StringBuilder builder = new StringBuilder("FileSystemVariable[");
            builder.append("name=").append(this.getName()).append(", ");
            builder.append("source=").append((Object)LibertyVariable.Source.FILE_SYSTEM);
            builder.append("]");
            return builder.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry$FileSystemVariable", FileSystemVariable.class, null, null);
        }
    }
}

