/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.ltc.impl;

import com.ibm.tx.ltc.impl.LocalTranCoordImpl;
import com.ibm.tx.ltc.impl.LocalTranCurrentSet;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.uow.UOWScope;
import com.ibm.ws.uow.UOWScopeCallback;
import com.ibm.ws.uow.UOWScopeLTCAware;

public class LTCUOWCallback
implements UOWScopeCallback {
    private static final TraceComponent tc = Tr.register(LTCUOWCallback.class, (String)"Transaction", (String)"com.ibm.ws.LocalTransaction.resources.LocalTranMsgs");
    protected ThreadLocal<Byte> _beginContext = new ThreadLocal();
    protected ThreadLocal<Byte> _endContext = new ThreadLocal();
    protected static final LocalTransactionCurrent _ltCurrent = LocalTranCurrentSet.instance();
    protected int _uowType;
    public static final int UOW_TYPE_TRANSACTION = 0;
    protected static LTCUOWCallback userTranCallback;

    public static UOWScopeCallback createUserTransactionCallback() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createUserTransactionCallback", (Object[])new Object[0]);
        }
        if (userTranCallback == null) {
            userTranCallback = new LTCUOWCallback(0);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createUserTransactionCallback", (Object)userTranCallback);
        }
        return userTranCallback;
    }

    public static UOWScopeCallback getUserTransactionCallback() {
        return LTCUOWCallback.createUserTransactionCallback();
    }

    public LTCUOWCallback(int uowType) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LTCUOWCallback", (Object[])new Object[]{uowType});
        }
        this._uowType = uowType;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LTCUOWCallback", (Object)this);
        }
    }

    @Override
    public void contextChange(int typeOfChange, UOWScope scope) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contextChange", (Object[])new Object[]{Util.printUOWStatusChangeType(typeOfChange), scope, this});
        }
        try {
            switch (typeOfChange) {
                case 0: {
                    this.uowPreBegin();
                    break;
                }
                case 1: {
                    this.uowPostBegin(scope);
                    break;
                }
                case 2: {
                    this.uowPreEnd(scope);
                    break;
                }
                case 3: {
                    this.uowPostEnd();
                    break;
                }
                default: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unknown typeOfChange: " + typeOfChange), (Object[])new Object[0]);
                    }
                    break;
                }
            }
        }
        catch (IllegalStateException ise) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"contextChange", (Object)ise);
            }
            throw ise;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contextChange");
        }
    }

    protected void uowPreBegin() throws IllegalStateException {
        LocalTranCoordImpl ltc;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uowPreBegin", (Object[])new Object[]{this});
        }
        if ((ltc = (LocalTranCoordImpl)_ltCurrent.getLocalTranCoord()) != null) {
            this._beginContext.set(null);
            if (ltc.hasWork()) {
                if (this._uowType == 0) {
                    Tr.error((TraceComponent)tc, (String)"ERR_BEGIN_GLOBAL_TX", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("Cannot start a new UOW. A LocalTransactionContainment is already active with work.");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"transactionPreBegin", (Object)ise);
                }
                throw ise;
            }
            try {
                ltc.complete(1);
                this._beginContext.set(ltc.getConfiguredMetadata());
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.tx.ltc.LTCUOWCallback.uowPreBegin", (String)"243", (Object)this);
                IllegalStateException ise = new IllegalStateException();
                ise.initCause(e);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"uowPreBegin", (Object)ise);
                }
                throw ise;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uowPreBegin");
        }
    }

    protected void uowPostBegin(UOWScope scope) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uowPostBegin", (Object[])new Object[]{scope, this});
        }
        if (scope == null) {
            Byte ltcCompleted;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"uowPostBegin detected null UOW scope", (Object[])new Object[0]);
            }
            if ((ltcCompleted = this._beginContext.get()) != null) {
                boolean resolverIsCAB;
                byte ltcData = ltcCompleted;
                boolean asScoped = LocalTranCoordImpl.BOUNDARY_ACTIVITYSESSION == (ltcData & 1);
                boolean unresActionIsCommit = (ltcData & 2) == 2;
                boolean bl = resolverIsCAB = (ltcData & 4) == 4;
                if ((ltcData & 8) == 8) {
                    _ltCurrent.beginShareable(asScoped, unresActionIsCommit, resolverIsCAB);
                } else {
                    _ltCurrent.begin(asScoped, unresActionIsCommit, resolverIsCAB);
                }
            }
            String msg = "Failed to start global transaction";
            IllegalStateException ise = new IllegalStateException("Failed to start global transaction");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"transactionPostBegin", (Object)ise);
            }
            throw ise;
        }
        Byte completedLTCBoundary = this._beginContext.get();
        if (scope instanceof UOWScopeLTCAware) {
            ((UOWScopeLTCAware)scope).setCompletedLTCBoundary(completedLTCBoundary);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uowPostBegin");
        }
    }

    protected void uowPreEnd(UOWScope scope) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uowPreEnd", (Object[])new Object[]{scope, this});
        }
        this._endContext.set(null);
        this._beginContext.set(null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Set the _beginContext and _endContext to NULL", (Object[])new Object[0]);
        }
        if (scope != null) {
            Byte completedLTCBoundary = null;
            if (scope instanceof UOWScopeLTCAware) {
                completedLTCBoundary = ((UOWScopeLTCAware)scope).getCompletedLTCBoundary();
            }
            this._endContext.set(completedLTCBoundary);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uowPreEnd");
        }
    }

    protected void uowPostEnd() throws IllegalStateException {
        Byte completedLTCBoundary;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uowPostEnd", (Object[])new Object[]{this});
        }
        if ((completedLTCBoundary = this._endContext.get()) != null) {
            boolean resolverIsCAB;
            byte ltcData = completedLTCBoundary;
            boolean asScoped = LocalTranCoordImpl.BOUNDARY_ACTIVITYSESSION == (ltcData & 1);
            boolean unresActionIsCommit = (ltcData & 2) == 2;
            boolean bl = resolverIsCAB = (ltcData & 4) == 4;
            if ((ltcData & 8) == 8) {
                _ltCurrent.beginShareable(asScoped, unresActionIsCommit, resolverIsCAB);
            } else {
                _ltCurrent.begin(asScoped, unresActionIsCommit, resolverIsCAB);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uowPostEnd");
        }
    }

    public static void destroyUserTransactionCallback() {
        LTCUOWCallback.userTranCallback._endContext.set(null);
        userTranCallback = null;
    }
}

