/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.EmptyMetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorageUtils;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class TemporalMetricStorage<T, U extends ExemplarData> {
    private final Aggregator<T, U> aggregator;
    private final boolean isSynchronous;
    private final RegisteredReader registeredReader;
    private Map<Attributes, T> lastAccumulation = new HashMap<Attributes, T>();
    private final AggregationTemporality temporality;
    private final MetricDescriptor metricDescriptor;

    TemporalMetricStorage(Aggregator<T, U> aggregator, boolean isSynchronous, RegisteredReader registeredReader, AggregationTemporality aggregationTemporality, MetricDescriptor metricDescriptor) {
        this.aggregator = aggregator;
        this.isSynchronous = isSynchronous;
        this.registeredReader = registeredReader;
        this.temporality = aggregationTemporality;
        this.metricDescriptor = metricDescriptor;
    }

    synchronized MetricData buildMetricFor(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, Map<Attributes, T> currentAccumulation, long startEpochNanos, long epochNanos) {
        Map<Attributes, T> result = currentAccumulation;
        long lastCollectionEpoch = this.registeredReader.getLastCollectEpochNanos();
        if (this.temporality == AggregationTemporality.DELTA && !this.isSynchronous) {
            MetricStorageUtils.diffInPlace(this.lastAccumulation, currentAccumulation, this.aggregator);
            result = this.lastAccumulation;
        } else if (this.temporality == AggregationTemporality.CUMULATIVE && this.isSynchronous) {
            MetricStorageUtils.mergeAndPreserveInPlace(this.lastAccumulation, currentAccumulation, this.aggregator);
            if (this.lastAccumulation.size() > 2000) {
                MetricStorageUtils.removeUnseen(this.lastAccumulation, currentAccumulation);
            }
            result = this.lastAccumulation;
        }
        this.lastAccumulation = this.isSynchronous ? result : currentAccumulation;
        if (result.isEmpty()) {
            return EmptyMetricData.getInstance();
        }
        return this.aggregator.toMetricData(resource, instrumentationScopeInfo, this.metricDescriptor, result, this.temporality, startEpochNanos, lastCollectionEpoch, epochNanos);
    }
}

