/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.TemporalMetricStorage;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DefaultSynchronousMetricStorage<T, U extends ExemplarData>
implements SynchronousMetricStorage {
    private static final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(DefaultSynchronousMetricStorage.class.getName()));
    private static final BoundStorageHandle NOOP_STORAGE_HANDLE = new NoopBoundHandle();
    private final RegisteredReader registeredReader;
    private final MetricDescriptor metricDescriptor;
    private final Aggregator<T, U> aggregator;
    private final ConcurrentHashMap<Attributes, AggregatorHandle<T, U>> activeCollectionStorage = new ConcurrentHashMap();
    private final TemporalMetricStorage<T, U> temporalMetricStorage;
    private final AttributesProcessor attributesProcessor;
    private final BoundStorageHandle lateBoundStorageHandle = new BoundStorageHandle(){

        @Override
        public void release() {
        }

        @Override
        public void recordLong(long value, Attributes attributes, Context context) {
            DefaultSynchronousMetricStorage.this.recordLong(value, attributes, context);
        }

        @Override
        public void recordDouble(double value, Attributes attributes, Context context) {
            DefaultSynchronousMetricStorage.this.recordDouble(value, attributes, context);
        }
    };

    DefaultSynchronousMetricStorage(RegisteredReader registeredReader, MetricDescriptor metricDescriptor, Aggregator<T, U> aggregator, AttributesProcessor attributesProcessor) {
        this.registeredReader = registeredReader;
        this.metricDescriptor = metricDescriptor;
        AggregationTemporality aggregationTemporality = registeredReader.getReader().getAggregationTemporality(metricDescriptor.getSourceInstrument().getType());
        this.aggregator = aggregator;
        this.temporalMetricStorage = new TemporalMetricStorage<T, U>(aggregator, true, registeredReader, aggregationTemporality, metricDescriptor);
        this.attributesProcessor = attributesProcessor;
    }

    @Override
    public BoundStorageHandle bind(Attributes attributes) {
        Objects.requireNonNull(attributes, "attributes");
        if (this.attributesProcessor.usesContext()) {
            return this.lateBoundStorageHandle;
        }
        return this.doBind(this.attributesProcessor.process(attributes, Context.current()));
    }

    private BoundStorageHandle doBind(Attributes attributes) {
        AggregatorHandle<T, U> aggregatorHandle = this.activeCollectionStorage.get(attributes);
        if (aggregatorHandle != null && aggregatorHandle.acquire()) {
            return aggregatorHandle;
        }
        aggregatorHandle = this.aggregator.createHandle();
        while (true) {
            if (this.activeCollectionStorage.size() >= 2000) {
                logger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has exceeded the maximum allowed accumulations (" + 2000 + ").");
                return NOOP_STORAGE_HANDLE;
            }
            AggregatorHandle<T, U> boundAggregatorHandle = this.activeCollectionStorage.putIfAbsent(attributes, aggregatorHandle);
            if (boundAggregatorHandle == null) break;
            if (boundAggregatorHandle.acquire()) {
                return boundAggregatorHandle;
            }
            this.activeCollectionStorage.remove(attributes, boundAggregatorHandle);
        }
        return aggregatorHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordLong(long value, Attributes attributes, Context context) {
        Objects.requireNonNull(attributes, "attributes");
        attributes = this.attributesProcessor.process(attributes, context);
        BoundStorageHandle handle = this.doBind(attributes);
        try {
            handle.recordLong(value, attributes, context);
        }
        finally {
            handle.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordDouble(double value, Attributes attributes, Context context) {
        Objects.requireNonNull(attributes, "attributes");
        attributes = this.attributesProcessor.process(attributes, context);
        BoundStorageHandle handle = this.doBind(attributes);
        try {
            handle.recordDouble(value, attributes, context);
        }
        finally {
            handle.release();
        }
    }

    @Override
    public MetricData collectAndReset(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long startEpochNanos, long epochNanos) {
        HashMap<Attributes, T> accumulations = new HashMap<Attributes, T>();
        for (Map.Entry<Attributes, AggregatorHandle<T, U>> entry : this.activeCollectionStorage.entrySet()) {
            T accumulation;
            boolean unmappedEntry = entry.getValue().tryUnmap();
            if (unmappedEntry) {
                this.activeCollectionStorage.remove(entry.getKey(), entry.getValue());
            }
            if ((accumulation = entry.getValue().accumulateThenReset(entry.getKey())) == null) continue;
            accumulations.put(entry.getKey(), accumulation);
        }
        return this.temporalMetricStorage.buildMetricFor(resource, instrumentationScopeInfo, accumulations, startEpochNanos, epochNanos);
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    @Override
    public RegisteredReader getRegisteredReader() {
        return this.registeredReader;
    }

    private static class NoopBoundHandle
    implements BoundStorageHandle {
        private NoopBoundHandle() {
        }

        @Override
        public void recordLong(long value, Attributes attributes, Context context) {
        }

        @Override
        public void recordDouble(double value, Attributes attributes, Context context) {
        }

        @Override
        public void release() {
        }
    }
}

