/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.common.enums;

import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.Visibility;
import java.util.Collection;
import java.util.Collections;

public enum FilterableAttribute {
    TYPE("type", ResourceType.class),
    PRODUCT_ID("wlpInformation.appliesToFilterInfo.productId", String.class),
    VISIBILITY("wlpInformation.visibility", "wlpInformation2.visibility", Collections.singleton(Visibility.INSTALL.toString()), Visibility.class),
    PRODUCT_MIN_VERSION("wlpInformation.appliesToFilterInfo.minVersion.value", String.class),
    PRODUCT_HAS_MAX_VERSION("wlpInformation.appliesToFilterInfo.hasMaxVersion", Boolean.class),
    SYMBOLIC_NAME("wlpInformation.provideFeature", String.class),
    SHORT_NAME("wlpInformation.shortName", String.class),
    LOWER_CASE_SHORT_NAME("wlpInformation.lowerCaseShortName", String.class),
    VANITY_URL("wlpInformation.vanityRelativeURL", String.class);

    private final String attributeName;
    private final String secondaryAttributeName;
    private final Collection<String> valuesInSecondaryAttributeName;
    private final Class<?> type;

    private FilterableAttribute(String attributeName, Class<?> type) {
        this.attributeName = attributeName;
        this.secondaryAttributeName = null;
        this.valuesInSecondaryAttributeName = null;
        this.type = type;
    }

    private FilterableAttribute(String attributeName, String secondaryAttributeName, Collection<String> valuesInSecondaryAttributeName, Class<?> type) {
        this.attributeName = attributeName;
        this.secondaryAttributeName = secondaryAttributeName;
        this.valuesInSecondaryAttributeName = valuesInSecondaryAttributeName;
        this.type = type;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getSecondaryAttributeName() {
        return this.secondaryAttributeName;
    }

    public Collection<String> getValuesInSecondaryAttributeName() {
        return this.valuesInSecondaryAttributeName;
    }

    public Class<?> getType() {
        return this.type;
    }
}

