/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.subsystem;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.FeatureDefinition;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils;
import com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component
public class FeatureIntrospector
implements Introspector {
    private final FeatureProvisioner provisioner;
    static final long serialVersionUID = -5283257258742823768L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    public FeatureIntrospector(@Reference FeatureProvisioner provisioner) {
        this.provisioner = provisioner;
    }

    public String getIntrospectorName() {
        return "FeatureIntrospector";
    }

    public String getIntrospectorDescription() {
        return "Lists all the features enabled in the server.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspect(PrintWriter out) throws Exception {
        Set<String> features = this.provisioner.getInstalledFeatures();
        for (String feature : features) {
            FeatureDefinition featureDef = this.provisioner.getFeatureDefinition(feature);
            out.println(featureDef.getFeatureName());
            out.println("    Visibility: " + (Object)((Object)featureDef.getVisibility()));
            out.println("    Version: " + featureDef.getVersion());
            out.println("    Simple Name: " + featureDef.getFeatureName());
            out.println("    Symbolic Name: " + featureDef.getSymbolicName());
            if (!(featureDef instanceof ProvisioningFeatureDefinition)) continue;
            ProvisioningFeatureDefinition proFeatDef = (ProvisioningFeatureDefinition)featureDef;
            String bundleRepType = proFeatDef.getBundleRepositoryType();
            out.println("    Bundle Repository Type: " + (bundleRepType == null || bundleRepType.isEmpty() ? "core" : bundleRepType));
            out.println("    Auto Feature: " + proFeatDef.isAutoFeature());
            out.println("    Singleton: " + proFeatDef.isSingleton());
            if (!(proFeatDef instanceof SubsystemFeatureDefinitionImpl)) continue;
            SubsystemFeatureDefinitionImpl subSysFeatureDef = (SubsystemFeatureDefinitionImpl)proFeatDef;
            FeatureDefinitionUtils.ProvisioningDetails details = subSysFeatureDef.getProvisioningDetails();
            boolean detailsAreSet = false;
            try {
                if (details == null) {
                    try {
                        details = new FeatureDefinitionUtils.ProvisioningDetails(subSysFeatureDef.getImmutableAttributes().featureFile, null);
                        details.setImmutableAttributes(subSysFeatureDef.getImmutableAttributes());
                        subSysFeatureDef.setProvisioningDetails(details);
                        detailsAreSet = true;
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureIntrospector", (String)"94", (Object)this, (Object[])new Object[]{out});
                    }
                }
                boolean isSuperseded = details.isSuperseded();
                out.println("    Superseded: " + isSuperseded);
                if (isSuperseded) {
                    out.println("        Superseded by: " + details.getSupersededBy());
                }
                Collection<FeatureResource> constituents = details.getConstituents(null);
                out.println("    Constituents: ");
                for (FeatureResource constituent : constituents) {
                    List<String> tolerates = constituent.getTolerates();
                    String toleratesString = tolerates == null ? "" : ": tolerates:=" + tolerates;
                    out.println("        " + constituent.getSymbolicName() + " " + toleratesString);
                    out.println("            " + constituent.getAttributes().toString());
                }
            }
            finally {
                if (!detailsAreSet) continue;
                subSysFeatureDef.setProvisioningDetails(null);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureIntrospector", FeatureIntrospector.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    }
}

