/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.internal.WebReply;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RedirectReply
extends WebReply {
    private final List<Cookie> cookieList;
    static final long serialVersionUID = 4693941778852976082L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RedirectReply(String url, List<Cookie> list) {
        super(302, url);
        this.cookieList = list;
    }

    @Override
    public void writeResponse(HttpServletResponse resp) throws IOException {
        if (resp.isCommitted()) {
            return;
        }
        if (this.cookieList != null && this.cookieList.size() > 0) {
            CookieHelper.addCookiesToResponse(this.cookieList, resp);
        }
        if (this.getStatusCode() != 303) {
            resp.sendRedirect(resp.encodeURL(this.message));
        } else if (resp instanceof IExtendedResponse) {
            ((IExtendedResponse)resp).sendRedirect303(resp.encodeURL(this.message));
        } else {
            resp.sendRedirect(resp.encodeURL(this.message));
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.internal.RedirectReply", RedirectReply.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    }
}

