/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OBPortableServer;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.IOP.ServiceContexts;
import org.apache.yoko.orb.OB.BootManager_impl;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ObjectKey;
import org.apache.yoko.orb.OB.ObjectKeyData;
import org.apache.yoko.orb.OB.Upcall;
import org.apache.yoko.orb.OB.UpcallReturn;
import org.apache.yoko.orb.OBPortableServer.POAManager_impl;
import org.apache.yoko.orb.OBPortableServer.POA_impl;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.MinorCodes;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHolder;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;

final class POAOAInterface_impl
extends LocalObject
implements OAInterface {
    static final Logger logger = Logger.getLogger(POAOAInterface_impl.class.getName());
    private ORBInstance orbInstance_;
    private POAManager_impl poaManager_;
    private BootManager_impl bootManagerImpl_;
    private boolean discard_;

    POAOAInterface_impl(POAManager_impl poaManager, ORBInstance orbInstance) {
        this.poaManager_ = poaManager;
        this.orbInstance_ = orbInstance;
        this.bootManagerImpl_ = (BootManager_impl)orbInstance.getBootManager();
    }

    @Override
    public Upcall createUpcall(UpcallReturn upcallReturn, ProfileInfo profileInfo, TransportInfo transportInfo, int requestId, String op, InputStream in, ServiceContexts requestContexts) {
        Upcall upcall;
        block13: {
            upcall = null;
            logger.fine("Creating upcall for operation " + op);
            try {
                if (this.discard_) {
                    throw new TRANSIENT("Requests are being discarded", 0, CompletionStatus.COMPLETED_NO);
                }
                ObjectKeyData data = new ObjectKeyData();
                if (ObjectKey.ParseObjectKey(profileInfo.key, data)) {
                    while (true) {
                        POA poa;
                        if ((poa = this.poaManager_._OB_locatePOA(data)) == null) {
                            logger.fine(() -> "Unable to locate POA " + data + " using POAManager " + this.poaManager_.get_id());
                        } else {
                            POA_impl poaImpl = (POA_impl)poa;
                            upcall = poaImpl._OB_createUpcall(data.oid, upcallReturn, profileInfo, transportInfo, requestId, op, in, requestContexts);
                            if (upcall == null) {
                                continue;
                            }
                        }
                        break;
                    }
                } else if (upcallReturn != null) {
                    logger.fine("Error parsing object key data");
                    IOR ior = this.bootManagerImpl_._OB_locate(profileInfo.key);
                    if (ior != null) {
                        throw new LocationForward(ior, false);
                    }
                }
                if (upcall != null) break block13;
                if (op.equals("_non_existent") || op.equals("_not_existent")) {
                    upcall = new Upcall(this.orbInstance_, upcallReturn, profileInfo, transportInfo, requestId, op, in, requestContexts);
                    upcall.preUnmarshal();
                    upcall.postUnmarshal();
                    upcall.postinvoke();
                    OutputStream out = upcall.preMarshal();
                    out.write_boolean(true);
                    upcall.postMarshal();
                    break block13;
                }
                throw new OBJECT_NOT_EXIST(MinorCodes.describeObjectNotExist((int)1330446338), 1330446338, CompletionStatus.COMPLETED_NO);
            }
            catch (SystemException ex) {
                logger.log(Level.FINE, "System exception creating upcall", ex);
                upcall = new Upcall(this.orbInstance_, upcallReturn, profileInfo, transportInfo, requestId, op, in, requestContexts);
                upcall.setSystemException(ex);
            }
            catch (LocationForward ex) {
                logger.log(Level.FINE, "Location forward request creating upcall.", ex);
                upcall = new Upcall(this.orbInstance_, upcallReturn, profileInfo, transportInfo, requestId, op, in, requestContexts);
                upcall.setLocationForward(ex.ior, ex.perm);
            }
        }
        Assert.ensure((upcall != null ? 1 : 0) != 0);
        return upcall;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int findByKey(byte[] key, IORHolder ior) {
        ObjectKeyData data = new ObjectKeyData();
        if (ObjectKey.ParseObjectKey(key, data)) {
            try {
                logger.fine("Locate request for object key " + data);
                POA poa = this.poaManager_._OB_locatePOA(data);
                if (poa == null) return 0;
                POA_impl poaImpl = (POA_impl)poa;
                poaImpl._OB_locateServant(data.oid);
                return 1;
            }
            catch (SystemException poa) {
                return 0;
            }
            catch (LocationForward fwd) {
                ior.value = fwd.ior;
                if (!fwd.perm) return 2;
                return 3;
            }
        } else {
            logger.fine("Checking boot manager for object with key " + data);
            ior.value = this.bootManagerImpl_._OB_locate(key);
            if (ior.value == null) return 0;
            return 2;
        }
    }

    @Override
    public ProfileInfo[] getUsableProfiles(IOR ior, Policy[] policies) {
        try {
            Acceptor[] acceptors = this.poaManager_.get_acceptors();
            Vector<ProfileInfo> seq = new Vector<ProfileInfo>();
            for (int i = 0; i < acceptors.length; ++i) {
                ProfileInfo[] seq2 = acceptors[i].get_local_profiles(ior);
                for (int j = 0; j < seq2.length; ++j) {
                    seq.addElement(seq2[j]);
                }
            }
            Object[] result = new ProfileInfo[seq.size()];
            seq.copyInto(result);
            return result;
        }
        catch (AdapterInactive ex) {
            throw Assert.fail((Throwable)ex);
        }
    }

    @Override
    public void discard() {
        this.discard_ = true;
    }

    @Override
    public void activate() {
        this.discard_ = false;
    }
}

