/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.FailureException;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.TimeHelper;
import org.apache.yoko.orb.OBMessaging.Poller_impl;
import org.apache.yoko.orb.OBMessaging.ReplyHandler_impl;
import org.apache.yoko.util.Assert;
import org.omg.CORBA.Object;
import org.omg.CORBA.REBIND;
import org.omg.CORBA.SystemException;
import org.omg.Messaging.ReplyHandler;
import org.omg.TimeBase.UtcT;

public class OrbAsyncHandler {
    protected LinkedList uncompletedMsgList_ = null;
    protected LinkedList completedMsgList_ = null;
    protected java.lang.Object sendMonitor_ = null;
    protected java.lang.Object recvMonitor_ = null;
    protected OAH_Worker[] worker_ = null;
    protected int numWorkers_;
    protected int state_ = 0;

    OrbAsyncHandler(int worker_threads) {
        this.numWorkers_ = worker_threads;
        if (this.numWorkers_ <= 0) {
            this.numWorkers_ = 1;
        }
    }

    public synchronized void activate() {
        Assert.ensure((this.state_ != 2 ? 1 : 0) != 0);
        if (this.state_ == 1) {
            return;
        }
        this.state_ = 1;
        this.uncompletedMsgList_ = new LinkedList();
        this.completedMsgList_ = new LinkedList();
        this.sendMonitor_ = new java.lang.Object();
        this.recvMonitor_ = new java.lang.Object();
        this.worker_ = new OAH_Worker[this.numWorkers_];
        for (int i = 0; i < this.numWorkers_; ++i) {
            this.worker_[i] = new OAH_Worker();
            this.worker_[i].handler(this);
            this.worker_[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.state_ == 2) {
            return;
        }
        if (this.state_ == 0) {
            this.state_ = 2;
            return;
        }
        this.state_ = 2;
        for (int i = 0; i < this.numWorkers_; ++i) {
            this.worker_[i].shutdown();
        }
        java.lang.Object i = this.sendMonitor_;
        synchronized (i) {
            this.sendMonitor_.notifyAll();
        }
        block6: for (int i2 = 0; i2 < this.numWorkers_; ++i2) {
            while (true) {
                try {
                    this.worker_[i2].join();
                    continue block6;
                }
                catch (InterruptedException ex) {
                    continue;
                }
                break;
            }
        }
        this.uncompletedMsgList_.clear();
        this.completedMsgList_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Downcall down, Poller_impl poller) {
        Assert.ensure((down != null ? 1 : 0) != 0);
        Assert.ensure((poller != null ? 1 : 0) != 0);
        this.activate();
        AsyncMessage msg = new AsyncMessage();
        msg.object = null;
        msg.poller = poller;
        msg.downcall = down;
        msg.reply = null;
        java.lang.Object object = this.sendMonitor_;
        synchronized (object) {
            this.uncompletedMsgList_.addLast(msg);
            this.sendMonitor_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Downcall down, ReplyHandler reply) {
        Assert.ensure((down != null ? 1 : 0) != 0);
        Assert.ensure((reply != null ? 1 : 0) != 0);
        this.activate();
        AsyncMessage msg = new AsyncMessage();
        msg.object = null;
        msg.poller = null;
        msg.downcall = down;
        msg.reply = reply;
        java.lang.Object object = this.sendMonitor_;
        synchronized (object) {
            this.uncompletedMsgList_.addLast(msg);
            this.sendMonitor_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean is_ready(Poller_impl poller, int timeout) {
        Assert.ensure((poller != null ? 1 : 0) != 0);
        boolean waitInfinite = false;
        if (timeout == -1) {
            waitInfinite = true;
        }
        while (true) {
            long start_time = System.currentTimeMillis();
            java.lang.Object object = this.recvMonitor_;
            synchronized (object) {
                ListIterator i = this.completedMsgList_.listIterator(0);
                while (i.hasNext()) {
                    AsyncMessage msg = (AsyncMessage)i.next();
                    if (msg.poller != poller) continue;
                    UtcT replyEndTime = msg.downcall.policies().replyEndTime;
                    return !TimeHelper.notEqual(replyEndTime, TimeHelper.utcMin()) || !TimeHelper.lessThan(replyEndTime, TimeHelper.utcNow(0L));
                    {
                    }
                }
            }
            if (timeout == 0) {
                return false;
            }
            try {
                object = this.recvMonitor_;
                synchronized (object) {
                    if (waitInfinite) {
                        this.recvMonitor_.wait();
                    } else {
                        this.recvMonitor_.wait(timeout);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (waitInfinite) continue;
            long end_time = System.currentTimeMillis();
            long diff_time = end_time - start_time;
            if (diff_time > (long)timeout) {
                timeout = 0;
                continue;
            }
            timeout = (int)((long)timeout - diff_time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnResponse(int timeout) {
        try {
            java.lang.Object object = this.recvMonitor_;
            synchronized (object) {
                if (timeout == -1) {
                    this.recvMonitor_.wait();
                } else {
                    this.recvMonitor_.wait(timeout);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Downcall poll_response(Poller_impl poller) {
        Assert.ensure((poller != null ? 1 : 0) != 0);
        java.lang.Object object = this.recvMonitor_;
        synchronized (object) {
            ListIterator iter = this.completedMsgList_.listIterator(0);
            while (iter.hasNext()) {
                AsyncMessage msg = (AsyncMessage)iter.next();
                if (msg.poller != poller) continue;
                iter.remove();
                return msg.downcall;
            }
        }
        throw Assert.fail();
    }

    final class State {
        public static final int OAH_STATE_DORMANT = 0;
        public static final int OAH_STATE_ACTIVE = 1;
        public static final int OAH_STATE_SHUTDOWN = 2;

        State() {
        }
    }

    class OAH_Worker
    extends Thread {
        protected OrbAsyncHandler handler_;
        protected boolean shutdown_;

        OAH_Worker() {
            super("Yoko:Client:OrbAsyncHandler:OAH_Worker");
            this.handler_ = null;
            this.shutdown_ = false;
        }

        public void handler(OrbAsyncHandler parent) {
            Assert.ensure((parent != null ? 1 : 0) != 0);
            this.handler_ = parent;
        }

        public OrbAsyncHandler handler() {
            return this.handler_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                UtcT replyStartTime;
                java.lang.Object requestEndTime;
                AsyncMessage msg;
                block29: {
                    java.lang.Object object;
                    msg = null;
                    java.lang.Object object2 = this.handler_.sendMonitor_;
                    synchronized (object2) {
                        object = this;
                        synchronized (object) {
                            if (this.shutdown_) {
                                break;
                            }
                        }
                        try {
                            if (this.handler_.uncompletedMsgList_.size() == 0) {
                                this.handler_.sendMonitor_.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.handler_.uncompletedMsgList_.size() > 0) {
                            msg = (AsyncMessage)this.handler_.uncompletedMsgList_.removeFirst();
                        }
                    }
                    if (msg == null) continue;
                    if (msg.downcall.unsent()) {
                        UtcT requestStartTime = msg.downcall.policies().requestStartTime;
                        if (TimeHelper.notEqual(requestStartTime, TimeHelper.utcMin()) && TimeHelper.greaterThan(requestStartTime, TimeHelper.utcNow(0L))) {
                            object = this.handler_.sendMonitor_;
                            synchronized (object) {
                                this.handler_.uncompletedMsgList_.addLast(msg);
                                this.handler_.sendMonitor_.notifyAll();
                            }
                        }
                        requestEndTime = msg.downcall.policies().requestEndTime;
                        if (TimeHelper.notEqual(requestEndTime, TimeHelper.utcMin()) && TimeHelper.lessThan(requestEndTime, TimeHelper.utcNow(0L))) continue;
                        try {
                            msg.downcall.request();
                        }
                        catch (LocationForward ex) {
                            if (msg.downcall.policies().rebindMode != 2) break block29;
                            msg.downcall.setSystemException((SystemException)new REBIND());
                        }
                        catch (FailureException ex) {
                            continue;
                        }
                    }
                }
                if (TimeHelper.notEqual(replyStartTime = msg.downcall.policies().replyStartTime, TimeHelper.utcMin()) && TimeHelper.greaterThan(replyStartTime, TimeHelper.utcNow(0L))) {
                    requestEndTime = this.handler_.sendMonitor_;
                    synchronized (requestEndTime) {
                        this.handler_.uncompletedMsgList_.addLast(msg);
                        this.handler_.sendMonitor_.notifyAll();
                    }
                }
                UtcT replyEndTime = msg.downcall.policies().replyEndTime;
                if (TimeHelper.notEqual(replyEndTime, TimeHelper.utcMin()) && TimeHelper.lessThan(replyEndTime, TimeHelper.utcNow(0L))) continue;
                if (msg.reply != null) {
                    ReplyHandler_impl reply = (ReplyHandler_impl)msg.reply;
                    reply._OB_invoke(msg.downcall);
                    continue;
                }
                Assert.ensure((msg.poller != null ? 1 : 0) != 0);
                ReplyHandler msgReply = msg.poller.associated_handler();
                if (msgReply != null) {
                    ReplyHandler_impl reply = (ReplyHandler_impl)msgReply;
                    reply._OB_invoke(msg.downcall);
                    continue;
                }
                java.lang.Object object = this.handler_.recvMonitor_;
                synchronized (object) {
                    this.handler_.completedMsgList_.addLast(msg);
                    this.handler_.recvMonitor_.notifyAll();
                }
            }
        }

        public synchronized void shutdown() {
            this.shutdown_ = true;
        }
    }

    class AsyncMessage {
        public Object object;
        public Poller_impl poller;
        public Downcall downcall;
        public ReplyHandler reply;

        AsyncMessage() {
        }
    }
}

