/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.interrupt.internal;

import com.ibm.websphere.interrupt.InterruptObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.request.interrupt.internal.InterruptManager;
import com.ibm.ws.request.interrupt.internal.JVMInterruptObject;
import com.ibm.ws.request.interrupt.status.InterruptibleThreadObjectOdiStatus;
import com.ibm.ws.request.interrupt.status.InterruptibleThreadObjectStatus;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InterruptibleThreadObject {
    private static final TraceComponent tc = Tr.register(InterruptibleThreadObject.class, (String)"requestInterrupt");
    private Deque<InterruptObject> odis;
    private Class<?> _interruptibleIOContextClass;
    private Object _interruptibleIOContextObject;
    private Method _iOContextisBlockedMethod;
    private Method _iOContextunblockMethod;
    private Class<?> _interruptibleLockContextClass;
    private Object _interruptibleLockContextObject;
    private Method _lockContextisBlockedMethod;
    private Method _lockContextunblockMethod;
    private JVMInterruptObject jvmInterruptObject;
    private boolean isReady;
    private String requestId;
    private InterruptManager currentInterruptManager;
    private final long threadId;
    private Calendar dispatchStartTime;
    static final long serialVersionUID = -6596067016129036428L;

    /*
     * WARNING - void declaration
     */
    public InterruptibleThreadObject(Class<?> interruptibleIOContextClass, Class<?> interruptibleLockContextClass) {
        block20: {
            block17: {
                this.odis = new LinkedList<InterruptObject>();
                this._interruptibleIOContextClass = null;
                this._interruptibleIOContextObject = null;
                this._iOContextisBlockedMethod = null;
                this._iOContextunblockMethod = null;
                this._interruptibleLockContextClass = null;
                this._interruptibleLockContextObject = null;
                this._lockContextisBlockedMethod = null;
                this._lockContextunblockMethod = null;
                this.jvmInterruptObject = null;
                this.isReady = false;
                this.requestId = null;
                this.currentInterruptManager = null;
                this.dispatchStartTime = null;
                this.threadId = Thread.currentThread().getId();
                if (interruptibleIOContextClass != null) {
                    block16: {
                        block15: {
                            this._interruptibleIOContextClass = interruptibleIOContextClass;
                            try {
                                this._interruptibleIOContextObject = this._interruptibleIOContextClass.newInstance();
                            }
                            catch (Exception exception) {
                                void e;
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.request.interrupt.internal.InterruptibleThreadObject", (String)"132", (Object)this, (Object[])new Object[]{interruptibleIOContextClass, interruptibleLockContextClass});
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                                Tr.debug((TraceComponent)tc, (String)"Exception getting object for interruptible IO Context Class", (Object[])new Object[]{e});
                            }
                        }
                        try {
                            this._iOContextisBlockedMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){
                                static final long serialVersionUID = -2005053727137759012L;
                                private static final /* synthetic */ TraceComponent $$$tc$$$;

                                @Override
                                public Method run() throws Exception {
                                    return InterruptibleThreadObject.this._interruptibleIOContextClass.getMethod("isBlocked", new Class[0]);
                                }

                                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                static {
                                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.request.interrupt.internal.InterruptibleThreadObject$1", 1.class, (String)"requestInterrupt", null);
                                }
                            });
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.request.interrupt.internal.InterruptibleThreadObject", (String)"144", (Object)this, (Object[])new Object[]{interruptibleIOContextClass, interruptibleLockContextClass});
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                            Tr.debug((TraceComponent)tc, (String)"Exception getting method isBlocked on IO context", (Object[])new Object[]{e});
                        }
                    }
                    try {
                        this._iOContextunblockMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){
                            static final long serialVersionUID = -242415480697091597L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public Method run() throws Exception {
                                return InterruptibleThreadObject.this._interruptibleIOContextClass.getMethod("unblock", new Class[0]);
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"com.ibm.ws.request.interrupt.internal.InterruptibleThreadObject$2", 2.class, (String)"requestInterrupt", null);
                            }
                        });
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.request.interrupt.internal.InterruptibleThreadObject", (String)"156", (Object)this, (Object[])new Object[]{interruptibleIOContextClass, interruptibleLockContextClass});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block17;
                        Tr.debug((TraceComponent)tc, (String)"Exception getting method unblock on IO context", (Object[])new Object[]{e});
                    }
                }
            }
            if (interruptibleLockContextClass != null) {
                block19: {
                    block18: {
                        this._interruptibleLockContextClass = interruptibleLockContextClass;
                        try {
                            this._interruptibleLockContextObject = this._interruptibleLockContextClass.newInstance();
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.request.interrupt.internal.InterruptibleThreadObject", (String)"167", (Object)this, (Object[])new Object[]{interruptibleIOContextClass, interruptibleLockContextClass});
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block18;
                            Tr.debug((TraceComponent)tc, (String)"Exception getting object for interruptible lock Context Class", (Object[])new Object[]{e});
                        }
                    }
                    try {
                        this._lockContextisBlockedMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){
                            static final long serialVersionUID = -1460327365877734124L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public Method run() throws Exception {
                                return InterruptibleThreadObject.this._interruptibleLockContextClass.getMethod("isBlocked", new Class[0]);
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"com.ibm.ws.request.interrupt.internal.InterruptibleThreadObject$3", 3.class, (String)"requestInterrupt", null);
                            }
                        });
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.request.interrupt.internal.InterruptibleThreadObject", (String)"179", (Object)this, (Object[])new Object[]{interruptibleIOContextClass, interruptibleLockContextClass});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block19;
                        Tr.debug((TraceComponent)tc, (String)"Exception getting method isBlocked on lock context", (Object[])new Object[]{e});
                    }
                }
                try {
                    this._lockContextunblockMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){
                        static final long serialVersionUID = 2571702050681870212L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Method run() throws Exception {
                            return InterruptibleThreadObject.this._interruptibleLockContextClass.getMethod("unblock", new Class[0]);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.request.interrupt.internal.InterruptibleThreadObject$4", 4.class, (String)"requestInterrupt", null);
                        }
                    });
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.request.interrupt.internal.InterruptibleThreadObject", (String)"191", (Object)this, (Object[])new Object[]{interruptibleIOContextClass, interruptibleLockContextClass});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block20;
                    Tr.debug((TraceComponent)tc, (String)"Exception getting method unblock on lock context", (Object[])new Object[]{e});
                }
            }
        }
        if (this._interruptibleIOContextObject != null && (this._iOContextisBlockedMethod != null || this._iOContextunblockMethod != null) || this._interruptibleLockContextObject != null && (this._lockContextisBlockedMethod != null || this._lockContextunblockMethod != null)) {
            this.jvmInterruptObject = new JVMInterruptObject(this._interruptibleIOContextObject, this._iOContextisBlockedMethod, this._iOContextunblockMethod, this._interruptibleLockContextObject, this._lockContextisBlockedMethod, this._lockContextunblockMethod);
        }
    }

    public synchronized void clear(boolean newRequest, String requestId) {
        IllegalStateException ise;
        if (Thread.currentThread().getId() != this.threadId) {
            throw new IllegalStateException("An attempt was made to clear this InterruptibleThreadObject from a thread ID other than " + this.threadId);
        }
        if (!newRequest && this.jvmInterruptObject != null) {
            this.deregister(this.jvmInterruptObject);
        }
        if (!this.odis.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (InterruptObject io : this.odis) {
                sb.append(io.getName());
                sb.append(" :: ");
            }
            String requestType = newRequest ? "start" : "end";
            IllegalStateException e = new IllegalStateException("The following interrupt objects were present at request " + requestType + ": " + sb.toString());
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"42", (Object)this);
        }
        this.odis.clear();
        this.isReady = newRequest;
        if (newRequest) {
            if (this.requestId != null) {
                ise = new IllegalStateException("A new request was detected but this InterruptObject was already registered with request ID " + this.requestId);
                FFDCFilter.processException((Throwable)ise, (String)this.getClass().getName(), (String)"73", (Object)this);
            }
            this.requestId = requestId;
            this.dispatchStartTime = Calendar.getInstance();
        } else {
            if (this.requestId == null || !this.requestId.equals(requestId)) {
                ise = new IllegalStateException("Request " + requestId + " was ending but this InterruptObject was registered with request ID " + this.requestId);
                FFDCFilter.processException((Throwable)ise, (String)this.getClass().getName(), (String)"80", (Object)this);
            }
            this.requestId = null;
            this.dispatchStartTime = null;
        }
        if (this.currentInterruptManager != null) {
            this.currentInterruptManager.cancel();
            this.currentInterruptManager = null;
        }
        if (newRequest && this.jvmInterruptObject != null) {
            this.jvmInterruptObject.reset();
            this.register(this.jvmInterruptObject);
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public synchronized void register(InterruptObject odi) {
        if (!this.isReady) {
            throw new IllegalStateException("The current thread is not currently accepting InterruptObject registration");
        }
        if (odi == null) {
            throw new IllegalArgumentException("A null InterruptObject was supplied");
        }
        this.odis.addFirst(odi);
    }

    public synchronized void deregister(InterruptObject odi) {
        if (!this.isReady) {
            throw new IllegalStateException("The current thread is not currently accepting InterruptObject deregistration");
        }
        if (odi == null) {
            throw new IllegalArgumentException("A null InterruptObject was supplied");
        }
        if (this.odis.contains(odi)) {
            InterruptObject cur = null;
            while (cur != odi) {
                cur = this.odis.removeFirst();
            }
        } else {
            IllegalArgumentException iae = new IllegalArgumentException("This InterruptObject was not currently registered: " + odi.toString());
            FFDCFilter.processException((Throwable)iae, (String)this.getClass().getName(), (String)"84", (Object)this);
        }
    }

    synchronized InterruptObject findNewestUndrivenInterruptObject() {
        InterruptObject firstUndrivenOdi = null;
        for (InterruptObject odi : this.odis) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking to see if ODI has been driven", (Object[])new Object[]{odi});
            }
            if (odi.queryTried()) continue;
            firstUndrivenOdi = odi;
            break;
        }
        return firstUndrivenOdi;
    }

    synchronized void interruptCurrentRequest(String requestId, ScheduledExecutorService scheduledExecutor) {
        if (this.currentInterruptManager == null) {
            InterruptManager im;
            this.currentInterruptManager = im = new InterruptManager(requestId, this, scheduledExecutor);
            scheduledExecutor.execute(im);
        } else {
            IllegalStateException ise = new IllegalStateException("Cannot create an InterruptManager for request " + requestId + ", because this InterruptObject already has an InterruptManager scheduled for request " + this.currentInterruptManager.getRequestId());
            FFDCFilter.processException((Throwable)ise, (String)this.getClass().getName(), (String)"142", (Object)this);
        }
    }

    synchronized InterruptibleThreadObjectStatus getStatus() {
        if (!this.isReady) {
            return null;
        }
        InterruptibleThreadObjectStatus status = new InterruptibleThreadObjectStatus(this.threadId, this.requestId, this.currentInterruptManager != null ? Boolean.TRUE : Boolean.FALSE, this.currentInterruptManager != null ? this.currentInterruptManager.isFinished() : false, DateFormat.getDateTimeInstance(2, 0).format(this.dispatchStartTime.getTime()), this.dispatchStartTime.getTimeInMillis());
        ArrayList<InterruptibleThreadObjectOdiStatus> odiStatusList = new ArrayList<InterruptibleThreadObjectOdiStatus>();
        int currentPosition = 0;
        for (InterruptObject odi : this.odis) {
            InterruptibleThreadObjectOdiStatus odiStatus = new InterruptibleThreadObjectOdiStatus(currentPosition++, odi.getName(), odi.getDisplayInfo(), odi.queryTried());
            odiStatusList.add(odiStatus);
        }
        status.addOdiStatus(odiStatusList);
        return status;
    }
}

