/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.embeddable.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.tx.jta.embeddable.impl.EmbeddableTransactionImpl;
import com.ibm.tx.jta.impl.TimeoutManager;
import com.ibm.tx.jta.impl.TransactionImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;

public class EmbeddableTimeoutManager
extends TimeoutManager {
    private static final TraceComponent tc = Tr.register(EmbeddableTimeoutManager.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final Hashtable<EmbeddableTransactionImpl, TimeoutInfo> inactivityTimeouts = new Hashtable();

    public static void setTimeout(EmbeddableTransactionImpl tran, int timeoutType, int seconds) {
        boolean traceOn = TraceComponent.isAnyTracingEnabled();
        if (traceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTimeout", (Object)new Object[]{tran, timeoutType, seconds});
        }
        if (tran == null) {
            throw new IllegalArgumentException("setTimeout called with null tran");
        }
        TimeoutInfo info = null;
        switch (timeoutType) {
            case 1: 
            case 2: 
            case 3: {
                info = (TimeoutInfo)tran.setTimeoutInfo(new TimeoutInfo(tran, seconds, timeoutType));
                if (!traceOn || !tc.isDebugEnabled() || info == null || timeoutType == 3) break;
                Tr.debug((TraceComponent)tc, (String)("Found existing timeout for transaction: " + (Object)((Object)info)));
                break;
            }
            case 4: {
                if (seconds == 0) {
                    info = inactivityTimeouts.remove(tran);
                    if (null != info) {
                        info.cancelAlarm();
                        break;
                    }
                    if (!traceOn || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Failed to find existing timeout for transaction: " + tran));
                    break;
                }
                info = new TimeoutInfo(tran, seconds, timeoutType);
                info = inactivityTimeouts.put(tran, info);
                if (!traceOn || !tc.isDebugEnabled() || info == null) break;
                Tr.debug((TraceComponent)tc, (String)("Found existing inactivity timeout for transaction: " + (Object)((Object)info)));
                break;
            }
            default: {
                info = (TimeoutInfo)tran.setTimeoutInfo(null);
                if (null != info) {
                    info.cancelAlarm();
                    break;
                }
                if (!traceOn || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("Failed to find existing timeout for transaction: " + tran));
            }
        }
        if (traceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTimeout");
        }
    }

    static class TimeoutInfo
    extends TimeoutManager.TimeoutInfo {
        TimeoutInfo(TransactionImpl tran, int duration, int type) {
            super(tran, duration, type);
        }

        public void alarm(Object alarmContext) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"alarm", (Object)this._tran);
            }
            switch (this._timeoutType) {
                case 1: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Transaction timeout", (Object)this._tran);
                    }
                    this._tran.timeoutTransaction(true);
                    Tr.info((TraceComponent)tc, (String)"WTRN0006_TRANSACTION_HAS_TIMED_OUT", (Object)new Object[]{this._tran.getTranName(), this._duration});
                    Thread thread = this._tran.getMostRecentThread();
                    if (thread == null) break;
                    StackTraceElement[] stack = thread.getStackTrace();
                    StringWriter writer = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(writer);
                    printWriter.println();
                    for (StackTraceElement element : stack) {
                        printWriter.println("\t" + element);
                    }
                    Tr.info((TraceComponent)tc, (String)"WTRN0124_TIMED_OUT_TRANSACTION_STACK", (Object)new Object[]{thread, writer.getBuffer()});
                    break;
                }
                case 3: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Transaction repeat timeout", (Object)this._tran);
                    }
                    this._tran.timeoutTransaction(false);
                    break;
                }
                case 4: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Transaction inactivity timeout", (Object)this._tran);
                    }
                    Tr.info((TraceComponent)tc, (String)"WTRN0080_CLIENT_INACTIVITY_TIMEOUT", (Object)new Object[]{this._tran.getTranName(), new Integer(this._duration)});
                    inactivityTimeouts.remove(this._tran);
                    ((EmbeddableTransactionImpl)this._tran).inactivityTimeout();
                    break;
                }
                case 2: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"In doubt timeout", (Object)this._tran);
                    }
                    this._tran.setTimeoutInfo(null);
                    this._tran.recover();
                    break;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }
}

