/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.wsspi.webcontainer.IPlatformHelper;
import com.ibm.wsspi.webcontainer.WebContainerConfig;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebContainer
extends com.ibm.websphere.servlet.container.WebContainer {
    private static volatile WebContainer self;
    private static com.ibm.ws.webcontainer.WebContainer webcontainer;
    private WebContainerConfig wcConfig;
    protected static Logger logger;
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.WebContainer";
    protected static TraceNLS nls;

    private WebContainer(com.ibm.ws.webcontainer.WebContainer webcontainer) {
        WebContainer.webcontainer = webcontainer;
        if (webcontainer == null) {
            logger.logp(Level.WARNING, CLASS_NAME, "WebContainer", "WebContainer has not been initialized");
        }
    }

    public String getURIEncoding() {
        if (webcontainer != null) {
            return webcontainer.getURIEncoding();
        }
        throw new RuntimeException(nls.getString("webcontainer.not.initialized", "WebContainer has not been initialized."));
    }

    public static WebContainer getWebContainer() {
        if (self == null) {
            self = new WebContainer(com.ibm.ws.webcontainer.WebContainer.getWebContainer());
        }
        return self;
    }

    @Override
    public void handleRequest(IRequest req, IResponse res) throws Exception {
        if (webcontainer == null) {
            throw new RuntimeException(nls.getString("webcontainer.not.initialized", "WebContainer has not been initialized."));
        }
        webcontainer.handleRequest(req, res);
    }

    public static void registerExtensionFactory(ExtensionFactory fac) {
        webcontainer.addExtensionFactory(fac);
    }

    public static Properties getWebContainerProperties() {
        return com.ibm.ws.webcontainer.WebContainer.getWebContainerProperties();
    }

    public WebContainerConfig getWebContainerConfig() {
        if (webcontainer == null) {
            return null;
        }
        return webcontainer.getWebContainerConfig();
    }

    public boolean isCollaboratorEnabled(String type) {
        Properties props = WebContainer.getWebContainerProperties();
        return Boolean.valueOf(props.getProperty("com.ibm.wsspi.webcontainer.enablecollab", "true"));
    }

    public void setServletCachingInitNeeded(boolean bool) {
        com.ibm.ws.webcontainer.WebContainer.setServletCachingInitNeeded(bool);
    }

    public boolean isCachingEnabled() {
        return webcontainer.isCachingEnabled();
    }

    public IPlatformHelper getPlatformHelper() {
        return webcontainer.getPlatformHelper();
    }

    public Integer getKeySize(String cipherSuite) {
        return webcontainer.getKeySize(cipherSuite);
    }

    public ClassLoader getExtClassLoader() {
        if (webcontainer == null) {
            return null;
        }
        return webcontainer.getExtClassLoader();
    }

    public static TraceNLS getNls() {
        return nls;
    }

    public synchronized void setWebContainerStopping(boolean isStopped) {
        webcontainer.setWebContainerStopping(isStopped);
    }

    public void decrementNumRequests() {
        webcontainer.decrementNumRequests();
    }

    static {
        logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer");
        nls = TraceNLS.getTraceNLS(WebContainer.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    }
}

