/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.stream.Field;

public abstract class SimpleContentHandler
extends AbstractContentHandler {
    private final FieldParser<? extends ParsedField> fieldParser;
    private final DecodeMonitor monitor;
    private Header currHeader;

    public SimpleContentHandler(FieldParser<? extends ParsedField> fieldParser, DecodeMonitor monitor) {
        this.fieldParser = fieldParser != null ? fieldParser : LenientFieldParser.getParser();
        this.monitor = monitor != null ? monitor : DecodeMonitor.SILENT;
    }

    public SimpleContentHandler() {
        this(null, null);
    }

    public abstract void headers(Header var1);

    @Override
    public final void startHeader() {
        this.currHeader = new HeaderImpl();
    }

    @Override
    public final void field(Field field) throws MimeException {
        ParsedField parsedField = field instanceof ParsedField ? (ParsedField)field : this.fieldParser.parse(field, this.monitor);
        this.currHeader.addField(parsedField);
    }

    @Override
    public final void endHeader() {
        Header tmp = this.currHeader;
        this.currHeader = null;
        this.headers(tmp);
    }
}

