/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.j2c.CommonFunction;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.resource.ResourceRefInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class CMConfigDataImpl
implements CMConfigData {
    private static final long serialVersionUID = 2034951388889375702L;
    private boolean res_sharing_scope = false;
    private int res_isolation_level = 999;
    private int res_resolution_control = 999;
    private int res_auth = 999;
    private String cf_name = "undefined";
    private String jndiName;
    private String cfDetailsKey = "undefined";
    private String _CfKey;
    private String loginConfigurationName = null;
    private Map<String, String> loginConfigProperties = null;
    private String loginConfigPropsKeyString = null;
    private int _commitPriority = 0;
    private int _branchCoupling = 999;
    private String qmid = null;
    private transient String _ConfigDumpId = "";
    private transient String _resRefName = null;
    private transient String _containerAlias = null;
    private static final TraceComponent TC = Tr.register(CMConfigDataImpl.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("cf_name", String.class), new ObjectStreamField("cfDetailsKey", String.class), new ObjectStreamField("_CfKey", String.class), new ObjectStreamField("_PmiName", String.class), new ObjectStreamField("res_auth", Integer.TYPE), new ObjectStreamField("res_isolation_level", Integer.TYPE), new ObjectStreamField("res_resolution_control", Integer.TYPE), new ObjectStreamField("res_sharing_scope", Boolean.TYPE), new ObjectStreamField("loginConfigurationName", String.class), new ObjectStreamField("loginConfigProperties", Map.class), new ObjectStreamField("loginConfigPropsKeyString", String.class), new ObjectStreamField("_commitPriority", Integer.TYPE), new ObjectStreamField("_branchCoupling", Integer.TYPE), new ObjectStreamField("qmid", String.class)};

    protected CMConfigDataImpl(String jndiName, int sharingScope, int isolationLevel, int auth, String cfKey, String loginConfigurationName, Map<String, String> loginConfigProperties, String resRefName, int commitPriority, int branchCoupling, Properties mmProps) {
        this.jndiName = jndiName;
        this._ConfigDumpId = jndiName;
        this._CfKey = cfKey != null ? cfKey : jndiName;
        this._resRefName = resRefName;
        this.setSharingScope(sharingScope);
        this.res_isolation_level = isolationLevel;
        this.res_auth = auth;
        this.loginConfigurationName = loginConfigurationName;
        this.loginConfigProperties = loginConfigProperties;
        if (loginConfigProperties != null && !loginConfigProperties.isEmpty()) {
            this.loginConfigPropsKeyString = loginConfigProperties.toString();
        }
        if (mmProps != null) {
            this._containerAlias = mmProps.getProperty("authDataAlias");
        }
        this._commitPriority = commitPriority;
        this.setBranchCoupling(branchCoupling);
        StringBuffer sb = new StringBuffer(128);
        sb.append(Integer.toString(sharingScope));
        sb.append(Integer.toString(this.res_isolation_level));
        sb.append(Integer.toString(this.res_auth));
        sb.append(Integer.toString(0));
        sb.append(Integer.toString(commitPriority));
        sb.append(Integer.toString(branchCoupling));
        if (loginConfigurationName != null) {
            sb.append(loginConfigurationName);
        }
        if (this.loginConfigPropsKeyString != null) {
            sb.append(this.loginConfigPropsKeyString);
        }
        if (resRefName != null) {
            sb.append(resRefName);
        }
        this.cfDetailsKey = this._CfKey + sb.toString();
        if (TC.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)TC, (String)("cfDetailsKey = " + this.cfDetailsKey + " for " + jndiName), (Object[])new Object[0]);
        }
    }

    public int getSharingScope() {
        return this.res_sharing_scope ? 0 : 1;
    }

    @Override
    public int getIsolationLevel() {
        return this.res_isolation_level;
    }

    @Override
    public int getAuth() {
        return this.res_auth;
    }

    @Override
    public String getCFDetailsKey() {
        return this.cfDetailsKey;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    @Override
    public String getLoginConfigurationName() {
        return this.loginConfigurationName;
    }

    @Override
    public Map<String, String> getLoginConfigProperties() {
        return this.loginConfigProperties;
    }

    public List<? extends ResourceRefInfo.Property> getLoginPropertyList() {
        LinkedList<PropertyImpl> props = new LinkedList<PropertyImpl>();
        if (this.loginConfigProperties == null) {
            return props;
        }
        for (Map.Entry<String, String> entry : this.loginConfigProperties.entrySet()) {
            props.add(new PropertyImpl(entry.getKey(), entry.getValue()));
        }
        return props;
    }

    @Override
    public String getContainerAlias() {
        return this._containerAlias;
    }

    protected void setSharingScope(int i) {
        if (i == 0) {
            this.res_sharing_scope = true;
        } else if (i == 1) {
            this.res_sharing_scope = false;
        } else {
            Tr.warning((TraceComponent)TC, (String)"INVALID_OR_UNEXPECTED_SETTING_J2CA0067", (Object[])new Object[]{"sharing scope", i, false});
            this.res_sharing_scope = false;
        }
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(256);
        String nl = CommonFunction.nl;
        String res_sharing_scopeString = "UNSHAREABLE";
        String res_isolation_levelString = "undefined";
        String res_authString = "undefined";
        if (this.res_sharing_scope) {
            res_sharing_scopeString = "SHAREABLE";
        }
        switch (this.res_isolation_level) {
            case 0: {
                res_isolation_levelString = "TRANSACTION_NONE";
                break;
            }
            case 1: {
                res_isolation_levelString = "TRANSACTION_READ_UNCOMMITTED";
                break;
            }
            case 2: {
                res_isolation_levelString = "TRANSACTION_READ_COMMITTED";
                break;
            }
            case 4: {
                res_isolation_levelString = "TRANSACTION_REPEATABLE_READ";
                break;
            }
            case 8: {
                res_isolation_levelString = "TRANSACTION_SERIALIZABLE";
                break;
            }
        }
        if (this.res_auth == 0) {
            res_authString = "CONTAINER";
        } else if (this.res_auth == 1) {
            res_authString = "APPLICATION";
        }
        buf.append(nl);
        buf.append("[Resource-ref CMConfigData key items]" + nl);
        buf.append(nl);
        buf.append("\tres-sharing-scope:        ");
        int ss = this.res_sharing_scope ? 0 : 1;
        buf.append(ss);
        buf.append(" (");
        buf.append(res_sharing_scopeString);
        buf.append(")");
        buf.append(nl);
        buf.append("\tres-isolation-level:      ");
        buf.append(this.res_isolation_level);
        buf.append(" (");
        buf.append(res_isolation_levelString);
        buf.append(")");
        buf.append(nl);
        buf.append("\tres-auth:                 ");
        buf.append(this.res_auth);
        buf.append(" (");
        buf.append(res_authString);
        buf.append(")");
        buf.append(nl);
        buf.append("\tcommitPriority            ");
        buf.append(this._commitPriority);
        buf.append(nl);
        buf.append("\tbranchCoupling            ");
        buf.append(this._branchCoupling);
        buf.append(nl);
        buf.append("\tloginConfigurationName:   ");
        buf.append(this.loginConfigurationName);
        buf.append(nl);
        buf.append("\tloginConfigProperties:    ");
        buf.append(this.loginConfigProperties);
        buf.append(nl);
        String resRefNameString = this._resRefName == null ? "not set" : this._resRefName;
        buf.append("\tResource ref name:        ");
        buf.append(resRefNameString);
        buf.append(nl);
        String qmidString = this.qmid == null ? "not set" : this.qmid;
        buf.append("\tQueue manager id:        ");
        buf.append(qmidString);
        buf.append(nl);
        return buf.toString();
    }

    @Override
    public String getCfKey() {
        return this._CfKey;
    }

    public boolean equals(Object o) {
        boolean rVal = false;
        if (o != null) {
            if (this == o) {
                rVal = true;
            } else {
                try {
                    CMConfigDataImpl compare = (CMConfigDataImpl)o;
                    if (this.cfDetailsKey == compare.cfDetailsKey || this.cfDetailsKey != null && this.cfDetailsKey.equals(compare.cfDetailsKey)) {
                        rVal = true;
                    }
                }
                catch (ClassCastException cce) {
                    rVal = false;
                }
            }
        }
        return rVal;
    }

    public int hashCode() {
        int rVal = 0;
        long tempHC = 0L;
        rVal = Long.valueOf((tempHC += (long)this.cfDetailsKey.hashCode()) / 10L).intValue();
        return rVal;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (TC.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)TC, (String)"readObject", (Object[])new Object[]{stream});
        }
        ObjectInputStream.GetField getField = stream.readFields();
        if (TC.isDebugEnabled()) {
            for (int i = 0; i < serialPersistentFields.length; ++i) {
                String fieldName = serialPersistentFields[i].getName();
                if (!getField.defaulted(fieldName)) continue;
                Tr.debug((Object)this, (TraceComponent)TC, (String)("Could not de-serialize field " + fieldName + " in class " + this.getClass().getName() + "; default value will be used"), (Object[])new Object[0]);
            }
        }
        this.cf_name = (String)getField.get("cf_name", null);
        this.cfDetailsKey = (String)getField.get("cfDetailsKey", null);
        this._CfKey = (String)getField.get("_CfKey", null);
        this.jndiName = (String)getField.get("_PmiName", null);
        this.res_auth = getField.get("res_auth", 999);
        this.res_isolation_level = getField.get("res_isolation_level", 999);
        this.res_resolution_control = getField.get("res_resolution_control", 999);
        this.res_sharing_scope = getField.get("res_sharing_scope", false);
        this.loginConfigurationName = (String)getField.get("loginConfigurationName", null);
        this.loginConfigProperties = (Map)getField.get("loginConfigProperties", Collections.EMPTY_MAP);
        this.loginConfigPropsKeyString = (String)getField.get("loginConfigPropsKeyString", null);
        this._commitPriority = getField.get("_commitPriority", 0);
        this._branchCoupling = getField.get("_branchCoupling", 999);
        this.qmid = (String)getField.get("qmid", null);
        if (TC.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)TC, (String)"readObject", (Object)new Object[]{this.cf_name, this.cfDetailsKey, this._CfKey, this.jndiName, this.res_auth, this.res_isolation_level, this.res_resolution_control, this.res_sharing_scope, this.loginConfigurationName, this.loginConfigProperties, this.loginConfigPropsKeyString, this._containerAlias, this._commitPriority, this._branchCoupling});
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (TC.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)TC, (String)"writeObject", (Object[])new Object[0]);
        }
        ObjectOutputStream.PutField putField = stream.putFields();
        putField.put("cf_name", this.cf_name);
        putField.put("cfDetailsKey", this.cfDetailsKey);
        putField.put("_CfKey", this._CfKey);
        putField.put("_PmiName", this.jndiName);
        putField.put("res_auth", this.res_auth);
        putField.put("res_isolation_level", this.res_isolation_level);
        putField.put("res_resolution_control", this.res_resolution_control);
        putField.put("res_sharing_scope", this.res_sharing_scope);
        putField.put("loginConfigurationName", this.loginConfigurationName);
        putField.put("loginConfigProperties", this.loginConfigProperties);
        putField.put("loginConfigPropsKeyString", this.loginConfigPropsKeyString);
        putField.put("_commitPriority", this._commitPriority);
        putField.put("_branchCoupling", this._branchCoupling);
        putField.put("qmid", this.qmid);
        stream.writeFields();
        if (TC.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)TC, (String)"writeObject");
        }
    }

    @Override
    public LinkedHashMap<String, Object> getConfigDump(String aLocalId, boolean aRegisteredOnly) {
        if (TC.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)TC, (String)"getConfigDump", (Object[])new Object[0]);
        }
        LinkedHashMap<String, Object> cp = new LinkedHashMap<String, Object>();
        if (TC.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)TC, (String)"getConfigDump");
        }
        return cp;
    }

    @Override
    public String getConfigDumpId() {
        return this._ConfigDumpId;
    }

    public void setConfigDumpId(String configDumpId) {
        this._ConfigDumpId = configDumpId;
    }

    public String getName() {
        return this._resRefName;
    }

    @Override
    public int getCommitPriority() {
        return this._commitPriority;
    }

    @Override
    public int getBranchCoupling() {
        return this._branchCoupling;
    }

    public void setBranchCoupling(int coupling) {
        this._branchCoupling = coupling;
    }

    public String getDescription() {
        throw new UnsupportedOperationException();
    }

    public String getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getQmid() {
        return this.qmid;
    }

    public void setQmid(String qmid) {
        this.qmid = qmid;
    }

    private static class PropertyImpl
    implements ResourceRefInfo.Property {
        private final String name;
        private final String value;

        PropertyImpl(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return '[' + this.name + '=' + this.value + ']';
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

