/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.faulttolerance30.internal.metrics.integration;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorderProvider;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryResultCategory;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.faulttolerance30.internal.metrics.integration.Type;
import java.util.EnumMap;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractMetricRecorder30Impl
implements MetricRecorder {
    private static final EnumMap<RetryResultCategory, Tag> RETRY_RESULT_TAGS;
    private static final EnumMap<MetricRecorder.RetriesOccurred, Tag> RETRIES_OCCURRED_TAGS;
    private final EnumMap<MetricRecorder.FallbackOccurred, Counter> invocationSuccessCounter;
    private final EnumMap<MetricRecorder.FallbackOccurred, Counter> invocationFailedCounter;
    private final EnumMap<RetryResultCategory, EnumMap<MetricRecorder.RetriesOccurred, Counter>> retryCallsCounter;
    private final Counter retryRetriesCounter;
    private final Histogram timeoutDurationHistogram;
    private final Counter timeoutTrueCalls;
    private final Counter timeoutFalseCalls;
    private final Counter circuitBreakerCallsSuccessCounter;
    private final Counter circuitBreakerCallsFailureCounter;
    private final Counter circuitBreakerCallsOpenCounter;
    private final Gauge<Long> circuitBreakerOpenTime;
    private final Gauge<Long> circuitBreakerHalfOpenTime;
    private final Gauge<Long> circuitBreakerClosedTime;
    private final Counter circuitBreakerTimesOpenedCounter;
    private final Gauge<Long> bulkheadConcurrentExecutions;
    private final Counter bulkheadRejectionsCounter;
    private final Counter bulkheadAcceptedCounter;
    private final Histogram bulkheadExecutionDuration;
    private final Gauge<Long> bulkheadQueuePopulation;
    private final Histogram bulkheadQueueWaitTimeHistogram;
    private LongSupplier concurrentExecutionCountSupplier = null;
    private LongSupplier queuePopulationSupplier = null;
    private long openNanos;
    private long halfOpenNanos;
    private long closedNanos;
    private CircuitBreakerState circuitBreakerState = CircuitBreakerState.CLOSED;
    protected long lastCircuitBreakerTransitionTime;
    static final long serialVersionUID = -3575861989126653458L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AbstractMetricRecorder30Impl(String methodName, MetricRegistry registry, RetryPolicy retryPolicy, CircuitBreakerPolicy circuitBreakerPolicy, TimeoutPolicy timeoutPolicy, BulkheadPolicy bulkheadPolicy, FallbackPolicy fallbackPolicy, MetricRecorderProvider.AsyncType isAsync) {
        Tag methodTag = new Tag("method", methodName);
        if (retryPolicy != null || timeoutPolicy != null || circuitBreakerPolicy != null || bulkheadPolicy != null || fallbackPolicy != null) {
            Metadata invocationsMetadata = this.metadata("ft.invocations.total", Type.COUNTER);
            Tag valueReturnedTag = new Tag("result", "valueReturned");
            Tag exceptionThrownTag = new Tag("result", "exceptionThrown");
            this.invocationSuccessCounter = new EnumMap(MetricRecorder.FallbackOccurred.class);
            this.invocationFailedCounter = new EnumMap(MetricRecorder.FallbackOccurred.class);
            if (fallbackPolicy != null) {
                Tag withFallbackTag = new Tag("fallback", "applied");
                Tag withoutFallbackTag = new Tag("fallback", "notApplied");
                this.invocationSuccessCounter.put(MetricRecorder.FallbackOccurred.NO_FALLBACK, registry.counter(invocationsMetadata, new Tag[]{methodTag, valueReturnedTag, withoutFallbackTag}));
                this.invocationSuccessCounter.put(MetricRecorder.FallbackOccurred.WITH_FALLBACK, registry.counter(invocationsMetadata, new Tag[]{methodTag, valueReturnedTag, withFallbackTag}));
                this.invocationFailedCounter.put(MetricRecorder.FallbackOccurred.NO_FALLBACK, registry.counter(invocationsMetadata, new Tag[]{methodTag, exceptionThrownTag, withoutFallbackTag}));
                this.invocationFailedCounter.put(MetricRecorder.FallbackOccurred.WITH_FALLBACK, registry.counter(invocationsMetadata, new Tag[]{methodTag, exceptionThrownTag, withFallbackTag}));
            } else {
                Tag noFallbackTag = new Tag("fallback", "notDefined");
                Counter invocationSuccess = registry.counter(invocationsMetadata, new Tag[]{methodTag, valueReturnedTag, noFallbackTag});
                this.invocationSuccessCounter.put(MetricRecorder.FallbackOccurred.NO_FALLBACK, invocationSuccess);
                this.invocationSuccessCounter.put(MetricRecorder.FallbackOccurred.WITH_FALLBACK, invocationSuccess);
                Counter invocationFailed = registry.counter(invocationsMetadata, new Tag[]{methodTag, exceptionThrownTag, noFallbackTag});
                this.invocationFailedCounter.put(MetricRecorder.FallbackOccurred.NO_FALLBACK, invocationFailed);
                this.invocationFailedCounter.put(MetricRecorder.FallbackOccurred.WITH_FALLBACK, invocationFailed);
            }
        } else {
            this.invocationSuccessCounter = null;
            this.invocationFailedCounter = null;
        }
        if (retryPolicy != null) {
            this.retryCallsCounter = new EnumMap(RetryResultCategory.class);
            for (RetryResultCategory resultCategory : RETRY_RESULT_TAGS.keySet()) {
                EnumMap<MetricRecorder.RetriesOccurred, Counter> submap = new EnumMap<MetricRecorder.RetriesOccurred, Counter>(MetricRecorder.RetriesOccurred.class);
                this.retryCallsCounter.put(resultCategory, submap);
                for (MetricRecorder.RetriesOccurred retriesOccurred : RETRIES_OCCURRED_TAGS.keySet()) {
                    submap.put(retriesOccurred, registry.counter("ft.retry.calls.total", new Tag[]{methodTag, RETRY_RESULT_TAGS.get(resultCategory), RETRIES_OCCURRED_TAGS.get(retriesOccurred)}));
                }
            }
            this.retryRetriesCounter = registry.counter("ft.retry.retries.total", new Tag[]{methodTag});
        } else {
            this.retryCallsCounter = null;
            this.retryRetriesCounter = null;
        }
        if (timeoutPolicy != null) {
            Metadata timeoutDurationMetadata = this.metadata("ft.timeout.executionDuration", Type.HISTOGRAM, "nanoseconds");
            this.timeoutDurationHistogram = registry.histogram(timeoutDurationMetadata, new Tag[]{methodTag});
            Metadata timeoutCallsMetadata = this.metadata("ft.timeout.calls.total", Type.COUNTER);
            this.timeoutTrueCalls = registry.counter(timeoutCallsMetadata, new Tag[]{methodTag, new Tag("timedOut", "true")});
            this.timeoutFalseCalls = registry.counter(timeoutCallsMetadata, new Tag[]{methodTag, new Tag("timedOut", "false")});
        } else {
            this.timeoutDurationHistogram = null;
            this.timeoutTrueCalls = null;
            this.timeoutFalseCalls = null;
        }
        if (circuitBreakerPolicy != null) {
            Metadata cbCallsMetadata = this.metadata("ft.circuitbreaker.calls.total", Type.COUNTER);
            this.circuitBreakerCallsFailureCounter = registry.counter(cbCallsMetadata, new Tag[]{methodTag, new Tag("circuitBreakerResult", "failure")});
            this.circuitBreakerCallsSuccessCounter = registry.counter(cbCallsMetadata, new Tag[]{methodTag, new Tag("circuitBreakerResult", "success")});
            this.circuitBreakerCallsOpenCounter = registry.counter(cbCallsMetadata, new Tag[]{methodTag, new Tag("circuitBreakerResult", "circuitBreakerOpen")});
            Metadata cbStateTimeMetadata = this.metadata("ft.circuitbreaker.state.total", Type.GAUGE, "nanoseconds");
            this.circuitBreakerOpenTime = this.gauge(registry, cbStateTimeMetadata, this::getCircuitBreakerAccumulatedOpen, methodTag, new Tag("state", "open"));
            this.circuitBreakerHalfOpenTime = this.gauge(registry, cbStateTimeMetadata, this::getCircuitBreakerAccumulatedHalfOpen, methodTag, new Tag("state", "halfOpen"));
            this.circuitBreakerClosedTime = this.gauge(registry, cbStateTimeMetadata, this::getCircuitBreakerAccumulatedClosed, methodTag, new Tag("state", "closed"));
            this.circuitBreakerTimesOpenedCounter = registry.counter("ft.circuitbreaker.opened.total", new Tag[]{methodTag});
        } else {
            this.circuitBreakerCallsFailureCounter = null;
            this.circuitBreakerCallsSuccessCounter = null;
            this.circuitBreakerCallsOpenCounter = null;
            this.circuitBreakerOpenTime = null;
            this.circuitBreakerHalfOpenTime = null;
            this.circuitBreakerClosedTime = null;
            this.circuitBreakerTimesOpenedCounter = null;
        }
        if (bulkheadPolicy != null) {
            Metadata bulkheadCallsMetadata = this.metadata("ft.bulkhead.calls.total", Type.COUNTER);
            this.bulkheadAcceptedCounter = registry.counter(bulkheadCallsMetadata, new Tag[]{methodTag, new Tag("bulkheadResult", "accepted")});
            this.bulkheadRejectionsCounter = registry.counter(bulkheadCallsMetadata, new Tag[]{methodTag, new Tag("bulkheadResult", "rejected")});
            Metadata executionsRunningMetadata = this.metadata("ft.bulkhead.executionsRunning", Type.GAUGE);
            this.bulkheadConcurrentExecutions = this.gauge(registry, executionsRunningMetadata, this::getConcurrentExecutions, methodTag);
            Metadata runningDurationMetadata = this.metadata("ft.bulkhead.runningDuration", Type.HISTOGRAM, "nanoseconds");
            this.bulkheadExecutionDuration = registry.histogram(runningDurationMetadata, new Tag[]{methodTag});
        } else {
            this.bulkheadRejectionsCounter = null;
            this.bulkheadAcceptedCounter = null;
            this.bulkheadConcurrentExecutions = null;
            this.bulkheadExecutionDuration = null;
        }
        if (bulkheadPolicy != null && isAsync == MetricRecorderProvider.AsyncType.ASYNC) {
            Metadata executionsWaitingMetadata = this.metadata("ft.bulkhead.executionsWaiting", Type.GAUGE);
            this.bulkheadQueuePopulation = this.gauge(registry, executionsWaitingMetadata, this::getQueuePopulation, methodTag);
            Metadata waitingDurationMetadata = this.metadata("ft.bulkhead.waitingDuration", Type.HISTOGRAM, "nanoseconds");
            this.bulkheadQueueWaitTimeHistogram = registry.histogram(waitingDurationMetadata, new Tag[]{methodTag});
        } else {
            this.bulkheadQueuePopulation = null;
            this.bulkheadQueueWaitTimeHistogram = null;
        }
        this.lastCircuitBreakerTransitionTime = System.nanoTime();
    }

    public abstract Metadata metadata(String var1, Type var2, String var3);

    public abstract Metadata metadata(String var1, Type var2);

    @Trivial
    public void incrementInvocationSuccessCount(MetricRecorder.FallbackOccurred fallbackOccurred) {
        if (this.invocationSuccessCounter != null) {
            this.invocationSuccessCounter.get(fallbackOccurred).inc();
        }
    }

    @Trivial
    public void incrementInvocationFailedCount(MetricRecorder.FallbackOccurred fallbackOccurred) {
        if (this.invocationFailedCounter != null) {
            this.invocationFailedCounter.get(fallbackOccurred).inc();
        }
    }

    @Trivial
    public void incrementRetryCalls(RetryResultCategory resultCategory, MetricRecorder.RetriesOccurred retriesOccurred) {
        if (this.retryCallsCounter != null) {
            this.retryCallsCounter.get(resultCategory).get(retriesOccurred).inc();
        }
    }

    @Trivial
    public void incrementRetriesCount() {
        if (this.retryRetriesCounter != null) {
            this.retryRetriesCounter.inc();
        }
    }

    @Trivial
    public void recordTimeoutExecutionTime(long executionNanos) {
        if (this.timeoutDurationHistogram != null) {
            this.timeoutDurationHistogram.update(executionNanos);
        }
    }

    @Trivial
    public void incrementTimeoutTrueCount() {
        if (this.timeoutTrueCalls != null) {
            this.timeoutTrueCalls.inc();
        }
    }

    @Trivial
    public void incrementTimeoutFalseCount() {
        if (this.timeoutFalseCalls != null) {
            this.timeoutFalseCalls.inc();
        }
    }

    @Trivial
    public void incrementCircuitBreakerCallsCircuitOpenCount() {
        if (this.circuitBreakerCallsOpenCounter != null) {
            this.circuitBreakerCallsOpenCounter.inc();
        }
    }

    @Trivial
    public void incrementCircuitBreakerCallsSuccessCount() {
        if (this.circuitBreakerCallsSuccessCounter != null) {
            this.circuitBreakerCallsSuccessCounter.inc();
        }
    }

    @Trivial
    public void incrementCircuitBreakerCallsFailureCount() {
        if (this.circuitBreakerCallsFailureCounter != null) {
            this.circuitBreakerCallsFailureCounter.inc();
        }
    }

    @Trivial
    public void incrementBulkheadRejectedCount() {
        if (this.bulkheadRejectionsCounter != null) {
            this.bulkheadRejectionsCounter.inc();
        }
    }

    @Trivial
    public void incrementBulkeadAcceptedCount() {
        if (this.bulkheadAcceptedCounter != null) {
            this.bulkheadAcceptedCounter.inc();
        }
    }

    @Trivial
    public synchronized void reportCircuitOpen(long now) {
        if (this.circuitBreakerState != CircuitBreakerState.OPEN) {
            this.recordEndOfCircuitBreakerState(this.circuitBreakerState);
            this.circuitBreakerState = CircuitBreakerState.OPEN;
            this.circuitBreakerTimesOpenedCounter.inc();
        }
    }

    @Trivial
    public synchronized void reportCircuitHalfOpen(long now) {
        if (this.circuitBreakerState != CircuitBreakerState.HALF_OPEN) {
            this.recordEndOfCircuitBreakerState(this.circuitBreakerState);
            this.circuitBreakerState = CircuitBreakerState.HALF_OPEN;
        }
    }

    @Trivial
    public synchronized void reportCircuitClosed(long now) {
        if (this.circuitBreakerState != CircuitBreakerState.CLOSED) {
            this.recordEndOfCircuitBreakerState(this.circuitBreakerState);
            this.circuitBreakerState = CircuitBreakerState.CLOSED;
        }
    }

    @Trivial
    private void recordEndOfCircuitBreakerState(CircuitBreakerState oldState) {
        long now = System.nanoTime();
        switch (oldState) {
            case CLOSED: {
                this.closedNanos += now - this.lastCircuitBreakerTransitionTime;
                break;
            }
            case HALF_OPEN: {
                this.halfOpenNanos += now - this.lastCircuitBreakerTransitionTime;
                break;
            }
            case OPEN: {
                this.openNanos += now - this.lastCircuitBreakerTransitionTime;
            }
        }
        this.lastCircuitBreakerTransitionTime = now;
    }

    @Trivial
    public void reportQueueWaitTime(long queueWaitNanos) {
        if (this.bulkheadQueueWaitTimeHistogram != null) {
            this.bulkheadQueueWaitTimeHistogram.update(queueWaitNanos);
        }
    }

    @Trivial
    private synchronized long getCircuitBreakerAccumulatedOpen() {
        long computedNanos = this.openNanos;
        if (this.circuitBreakerState == CircuitBreakerState.OPEN) {
            computedNanos += System.nanoTime() - this.lastCircuitBreakerTransitionTime;
        }
        return computedNanos;
    }

    @Trivial
    private synchronized long getCircuitBreakerAccumulatedHalfOpen() {
        long computedNanos = this.halfOpenNanos;
        if (this.circuitBreakerState == CircuitBreakerState.HALF_OPEN) {
            computedNanos += System.nanoTime() - this.lastCircuitBreakerTransitionTime;
        }
        return computedNanos;
    }

    @Trivial
    private synchronized long getCircuitBreakerAccumulatedClosed() {
        long computedNanos = this.closedNanos;
        if (this.circuitBreakerState == CircuitBreakerState.CLOSED) {
            computedNanos += System.nanoTime() - this.lastCircuitBreakerTransitionTime;
        }
        return computedNanos;
    }

    @Trivial
    private Long getConcurrentExecutions() {
        if (this.concurrentExecutionCountSupplier != null) {
            return this.concurrentExecutionCountSupplier.getAsLong();
        }
        return 0L;
    }

    @Trivial
    public void setBulkheadConcurentExecutionCountSupplier(LongSupplier concurrentExecutionCountSupplier) {
        this.concurrentExecutionCountSupplier = concurrentExecutionCountSupplier;
    }

    @Trivial
    private Long getQueuePopulation() {
        if (this.queuePopulationSupplier != null) {
            return this.queuePopulationSupplier.getAsLong();
        }
        return 0L;
    }

    @Trivial
    public void setBulkheadQueuePopulationSupplier(LongSupplier queuePopulationSupplier) {
        this.queuePopulationSupplier = queuePopulationSupplier;
    }

    @Trivial
    public void recordBulkheadExecutionTime(long executionTime) {
        if (this.bulkheadExecutionDuration != null) {
            this.bulkheadExecutionDuration.update(executionTime);
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private Gauge<Long> gauge(MetricRegistry registry, Metadata gaugeMeta, Supplier<Long> supplier, Tag ... tags) {
        Gauge result = null;
        try {
            result = registry.gauge(gaugeMeta, supplier, tags);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.faulttolerance30.internal.metrics.integration.AbstractMetricRecorder30Impl", AbstractMetricRecorder30Impl.class, (String)"FAULTTOLERANCE", null);
        RETRY_RESULT_TAGS = new EnumMap(RetryResultCategory.class);
        RETRIES_OCCURRED_TAGS = new EnumMap(MetricRecorder.RetriesOccurred.class);
        RETRY_RESULT_TAGS.put(RetryResultCategory.NO_EXCEPTION, new Tag("retryResult", "valueReturned"));
        RETRY_RESULT_TAGS.put(RetryResultCategory.EXCEPTION_IN_ABORT_ON, new Tag("retryResult", "exceptionNotRetryable"));
        RETRY_RESULT_TAGS.put(RetryResultCategory.EXCEPTION_NOT_IN_RETRY_ON, new Tag("retryResult", "exceptionNotRetryable"));
        RETRY_RESULT_TAGS.put(RetryResultCategory.MAX_DURATION_REACHED, new Tag("retryResult", "maxDurationReached"));
        RETRY_RESULT_TAGS.put(RetryResultCategory.MAX_RETRIES_REACHED, new Tag("retryResult", "maxRetriesReached"));
        RETRIES_OCCURRED_TAGS.put(MetricRecorder.RetriesOccurred.WITH_RETRIES, new Tag("retried", "true"));
        RETRIES_OCCURRED_TAGS.put(MetricRecorder.RetriesOccurred.NO_RETRIES, new Tag("retried", "false"));
    }

    private static enum CircuitBreakerState {
        CLOSED,
        HALF_OPEN,
        OPEN;

    }
}

