/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.context;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContext;
import io.openliberty.concurrent.internal.context.ThirdPartyContextCoordinator;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import jakarta.enterprise.concurrent.spi.ThreadContextRestorer;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ThirdPartyContext
implements ThreadContext {
    private static final TraceComponent tc = Tr.register(ThirdPartyContext.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.resources.CWWKCMessages");
    private static final long serialVersionUID = 1L;
    static final String CLEARED = "C";
    static final String PROPAGATED = "P";
    static final String UNCHANGED = "U";
    static final String REMAINING = "R";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("C", List.class), new ObjectStreamField("P", List.class), new ObjectStreamField("U", List.class), new ObjectStreamField("R", String.class)};
    private transient List<String> cleared;
    private transient List<String> propagated;
    private transient List<String> unchanged;
    private transient boolean isAnyPropagated;
    private transient String remaining;
    private transient ArrayList<ThreadContextRestorer> restorers;
    private transient ArrayList<ThreadContextSnapshot> snapshots;
    private transient ArrayList<Boolean> snapshots_propagate;

    @Trivial
    private ThirdPartyContext() {
    }

    ThirdPartyContext(ThirdPartyContextCoordinator coordinator, Map<String, String> execProps) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.unchanged = Collections.emptyList();
        this.propagated = this.unchanged;
        this.cleared = this.unchanged;
        this.remaining = "cleared";
        this.snapshots = new ArrayList();
        this.snapshots_propagate = new ArrayList();
        for (ThreadContextProvider provider : coordinator.getProviders()) {
            ThreadContextSnapshot snapshot = provider.clearedContext(execProps);
            this.snapshots.add(snapshot);
            this.snapshots_propagate.add(false);
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)("will clear " + provider.getThreadContextType() + " context " + String.valueOf(snapshot)), (Object[])new Object[0]);
        }
    }

    ThirdPartyContext(ThirdPartyContextCoordinator coordinator, Map<String, String> execProps, Map<String, ?> threadContextConfig) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.cleared = (List)threadContextConfig.get("cleared");
        this.propagated = (List)threadContextConfig.get("propagated");
        this.unchanged = (List)threadContextConfig.get("unchanged");
        this.remaining = (String)threadContextConfig.get("remaining");
        this.snapshots = new ArrayList();
        this.snapshots_propagate = new ArrayList();
        for (ThreadContextProvider provider : coordinator.getProviders()) {
            ThreadContextSnapshot snapshot;
            String action;
            String type = provider.getThreadContextType();
            String string = Collections.binarySearch(this.cleared, type) >= 0 ? "cleared" : (Collections.binarySearch(this.propagated, type) >= 0 ? "propagated" : (action = Collections.binarySearch(this.unchanged, type) >= 0 ? "unchanged" : this.remaining));
            if ("cleared".equals(action)) {
                snapshot = provider.clearedContext(execProps);
                this.snapshots.add(snapshot);
                this.snapshots_propagate.add(false);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("will clear " + type + " context " + String.valueOf(snapshot)), (Object[])new Object[0]);
                continue;
            }
            if ("propagated".equals(action)) {
                snapshot = provider.currentContext(execProps);
                this.snapshots.add(snapshot);
                this.snapshots_propagate.add(true);
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("will propagate " + type + " context " + String.valueOf(snapshot)), (Object[])new Object[0]);
                }
                this.isAnyPropagated = true;
                continue;
            }
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)("will ignore " + type + " context"), (Object[])new Object[0]);
        }
    }

    @Trivial
    public ThirdPartyContext clone() {
        ThirdPartyContext clone = new ThirdPartyContext();
        clone.cleared = this.cleared;
        clone.propagated = this.propagated;
        clone.unchanged = this.unchanged;
        clone.remaining = this.remaining;
        clone.snapshots = this.snapshots;
        clone.snapshots_propagate = this.snapshots_propagate;
        return clone;
    }

    void initPostDeserialize(ThirdPartyContextCoordinator coordinator, Map<String, String> execProps) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.snapshots = new ArrayList();
        this.snapshots_propagate = new ArrayList();
        for (ThreadContextProvider provider : coordinator.getProviders()) {
            boolean clear;
            String type = provider.getThreadContextType();
            boolean bl = clear = Collections.binarySearch(this.cleared, type) >= 0 || Collections.binarySearch(this.propagated, type) >= 0 || Collections.binarySearch(this.unchanged, type) < 0 && !"unchanged".equals(this.remaining);
            if (clear) {
                ThreadContextSnapshot snapshot = provider.clearedContext(execProps);
                this.snapshots.add(snapshot);
                this.snapshots_propagate.add(false);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("will clear " + type + " context " + String.valueOf(snapshot)), (Object[])new Object[0]);
                continue;
            }
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)("will ignore " + type + " context"), (Object[])new Object[0]);
        }
    }

    @Trivial
    public boolean isSerializable() {
        UnsupportedOperationException x = null;
        if (this.isAnyPropagated) {
            ArrayList<String> unser = new ArrayList<String>(this.propagated);
            if ("propagated".equals(this.remaining)) {
                unser.add("Remaining");
            }
            x = new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1204.not.serializable", (Object[])new Object[]{unser}));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"isSerializable?", (Object[])new Object[]{this.propagated, "remaining=" + this.remaining, x == null ? Boolean.valueOf(true) : x});
        }
        if (x == null) {
            return true;
        }
        throw x;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public void taskStarting() throws RejectedExecutionException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.restorers = new ArrayList();
        try {
            for (int i = 0; i < this.snapshots.size(); ++i) {
                ThreadContextSnapshot snapshot = this.snapshots.get(i);
                if (trace && tc.isDebugEnabled()) {
                    if (this.snapshots_propagate.get(i).booleanValue()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("propagate " + String.valueOf(snapshot)), (Object[])new Object[0]);
                    } else {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("clear     " + String.valueOf(snapshot)), (Object[])new Object[0]);
                    }
                }
                this.restorers.add(snapshot.begin());
            }
        }
        catch (Throwable i) {
            void x;
            FFDCFilter.processException((Throwable)i, (String)"io.openliberty.concurrent.internal.context.ThirdPartyContext", (String)"232", (Object)this, (Object[])new Object[0]);
            this.taskStopping();
            throw new RejectedExecutionException((Throwable)x);
        }
    }

    @Trivial
    public void taskStopping() {
        int i = this.restorers.size();
        while (--i >= 0) {
            try {
                ThreadContextRestorer restorer = this.restorers.remove(i);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("restore   " + String.valueOf(restorer)), (Object[])new Object[0]);
                }
                restorer.endContext();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.concurrent.internal.context.ThirdPartyContext", (String)"249", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder(100).append(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(this.hashCode())).append(" cleared=").append(this.cleared).append(" propagated=").append(this.propagated).append(" unchanged=").append(this.unchanged).append(" with remaining ").append(this.remaining).append("; context: ").append(this.snapshots);
        return sb.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.cleared = (List)fields.get(CLEARED, Collections.EMPTY_LIST);
        this.propagated = (List)fields.get(PROPAGATED, Collections.EMPTY_LIST);
        this.unchanged = (List)fields.get(UNCHANGED, Collections.EMPTY_LIST);
        this.remaining = (String)fields.get(REMAINING, this.cleared);
    }

    private void writeObject(ObjectOutputStream outStream) throws IOException {
        if (!this.isSerializable()) {
            throw new UnsupportedOperationException();
        }
        ObjectOutputStream.PutField fields = outStream.putFields();
        fields.put(CLEARED, this.cleared);
        fields.put(PROPAGATED, this.propagated);
        fields.put(UNCHANGED, this.unchanged);
        fields.put(REMAINING, this.remaining);
        outStream.writeFields();
    }
}

