/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.zipkin;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterMetrics;
import io.opentelemetry.exporter.zipkin.OtelToZipkinSpanTransformer;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.Callback;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.Encoding;
import zipkin2.reporter.Sender;

public final class ZipkinSpanExporter
implements SpanExporter {
    public static final Logger baseLogger = Logger.getLogger(ZipkinSpanExporter.class.getName());
    public static final String DEFAULT_ENDPOINT = "http://localhost:9411/api/v2/spans";
    private final ThrottlingLogger logger = new ThrottlingLogger(baseLogger);
    private final BytesEncoder<Span> encoder;
    private final Sender sender;
    private final ExporterMetrics exporterMetrics;
    private final OtelToZipkinSpanTransformer transformer;

    ZipkinSpanExporter(BytesEncoder<Span> encoder, Sender sender, MeterProvider meterProvider, OtelToZipkinSpanTransformer transformer) {
        this.encoder = encoder;
        this.sender = sender;
        this.exporterMetrics = sender.encoding() == Encoding.JSON ? ExporterMetrics.createHttpJson("zipkin", "span", meterProvider) : ExporterMetrics.createHttpProtobuf("zipkin", "span", meterProvider);
        this.transformer = transformer;
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spanDataList) {
        final int numItems = spanDataList.size();
        this.exporterMetrics.addSeen(numItems);
        ArrayList<byte[]> encodedSpans = new ArrayList<byte[]>(numItems);
        for (SpanData spanData : spanDataList) {
            Span zipkinSpan = this.transformer.generateSpan(spanData);
            encodedSpans.add(this.encoder.encode((Object)zipkinSpan));
        }
        final CompletableResultCode result = new CompletableResultCode();
        this.sender.sendSpans(encodedSpans).enqueue((Callback)new Callback<Void>(){

            public void onSuccess(Void value) {
                ZipkinSpanExporter.this.exporterMetrics.addSuccess(numItems);
                result.succeed();
            }

            public void onError(Throwable t) {
                ZipkinSpanExporter.this.exporterMetrics.addFailed(numItems);
                ZipkinSpanExporter.this.logger.log(Level.WARNING, "Failed to export spans", t);
                result.fail();
            }
        });
        return result;
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        try {
            this.sender.close();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Exception while closing the Zipkin Sender instance", e);
        }
        return CompletableResultCode.ofSuccess();
    }

    public static ZipkinSpanExporterBuilder builder() {
        return new ZipkinSpanExporterBuilder();
    }
}

