/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.processor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.javaee.dd.common.DataSource;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefType;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.sql.DataSourceDefinition;

public class DataSourceDefinitionInjectionBinding
extends InjectionBinding<DataSourceDefinition> {
    private static final TraceComponent tc = Tr.register(DataSourceDefinitionInjectionBinding.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_CLASS_NAME = "className";
    private static final String KEY_SERVER_NAME = "serverName";
    private static final String KEY_PORT_NUMBER = "portNumber";
    private static final String KEY_DATABASE_NAME = "databaseName";
    private static final String KEY_URL = "url";
    private static final String KEY_USER = "user";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_LOGIN_TIMEOUT = "loginTimeout";
    private static final String KEY_TRANSACTIONAL = "transactional";
    private static final String KEY_ISOLATION_LEVEL = "isolationLevel";
    private static final String KEY_INITIAL_POOL_SIZE = "initialPoolSize";
    private static final String KEY_MAX_POOL_SIZE = "maxPoolSize";
    private static final String KEY_MIN_POOL_SIZE = "minPoolSize";
    private static final String KEY_MAX_IDLE_TIME = "maxIdleTime";
    private static final String KEY_MAX_STATEMENTS = "maxStatements";
    private static final Map<Integer, String> ISOLATION_LEVEL_NAMES = new TreeMap<Integer, String>();
    private final String ivBinding;
    private Set<String> ivAttributeErrors;
    private Set<String> ivPropertyErrors;
    private String ivDescription;
    private boolean ivXMLDescription;
    private String ivClassName;
    private boolean ivXMLClassName;
    private String ivServerName;
    private boolean ivXMLServerName;
    private Integer ivPortNumber;
    private boolean ivXMLPortNumber;
    private String ivDatabaseName;
    private boolean ivXMLDatabaseName;
    private String ivURL;
    private boolean ivXMLURL;
    private String ivUser;
    private boolean ivXMLUser;
    private String ivPassword;
    private boolean ivXMLPassword;
    private Map<String, String> ivProperties;
    private final Set<String> ivXMLProperties = new HashSet<String>();
    private Integer ivLoginTimeout;
    private boolean ivXMLLoginTimeout;
    private Boolean ivTransactional;
    private boolean ivXMLTransactional;
    private Integer ivIsolationLevel;
    private boolean ivXMLIsolationLevel;
    private Integer ivInitialPoolSize;
    private boolean ivXMLInitialPoolSize;
    private Integer ivMaxPoolSize;
    private boolean ivXMLMaxPoolSize;
    private Integer ivMinPoolSize;
    private boolean ivXMLMinPoolSize;
    private Integer ivMaxIdleTime;
    private boolean ivXMLMaxIdleTime;
    private Integer ivMaxStatements;
    private boolean ivXMLMaxStatements;

    DataSourceDefinitionInjectionBinding(String jndiName, ComponentNameSpaceConfiguration compNSConfig) {
        super(null, compNSConfig);
        this.setJndiName(jndiName);
        Map<String, String> dsdBindings = compNSConfig.getDataSourceDefinitionBindings();
        this.ivBinding = dsdBindings == null ? null : dsdBindings.get(this.getJndiName());
    }

    @Override
    protected JNDIEnvironmentRefType getJNDIEnvironmentRefType() {
        return JNDIEnvironmentRefType.DataSource;
    }

    @Override
    public void merge(DataSourceDefinition annotation, Class<?> instanceClass, Member member) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("merge: name=" + this.getJndiName() + ", " + annotation), (Object[])new Object[0]);
        }
        if (member != null) {
            throw new IllegalArgumentException(member.toString());
        }
        this.ivDescription = this.mergeAnnotationValue(this.ivDescription, this.ivXMLDescription, annotation.description(), KEY_DESCRIPTION, "");
        this.ivClassName = this.mergeAnnotationValue(this.ivClassName, this.ivXMLClassName, annotation.className(), KEY_CLASS_NAME, "");
        this.ivServerName = this.mergeAnnotationValue(this.ivServerName, this.ivXMLServerName, annotation.serverName(), KEY_SERVER_NAME, "localhost");
        this.ivPortNumber = this.mergeAnnotationInteger(this.ivPortNumber, this.ivXMLPortNumber, annotation.portNumber(), KEY_PORT_NUMBER, -1, null);
        this.ivDatabaseName = this.mergeAnnotationValue(this.ivDatabaseName, this.ivXMLDatabaseName, annotation.databaseName(), KEY_DATABASE_NAME, "");
        this.ivURL = this.mergeAnnotationValue(this.ivURL, this.ivXMLURL, annotation.url(), KEY_URL, "");
        this.ivUser = this.mergeAnnotationValue(this.ivUser, this.ivXMLUser, annotation.user(), KEY_USER, "");
        this.ivPassword = this.mergeAnnotationValue(this.ivPassword, this.ivXMLPassword, annotation.password(), KEY_PASSWORD, "");
        this.ivProperties = this.mergeAnnotationProperties(this.ivProperties, this.ivXMLProperties, annotation.properties());
        this.ivLoginTimeout = this.mergeAnnotationInteger(this.ivLoginTimeout, this.ivXMLLoginTimeout, annotation.loginTimeout(), KEY_LOGIN_TIMEOUT, 0, null);
        this.ivTransactional = this.mergeAnnotationBoolean(this.ivTransactional, this.ivXMLTransactional, annotation.transactional(), KEY_TRANSACTIONAL, true);
        this.ivIsolationLevel = this.mergeAnnotationIsolationLevel(this.ivIsolationLevel, this.ivXMLIsolationLevel, annotation.isolationLevel(), KEY_ISOLATION_LEVEL, -1);
        this.ivInitialPoolSize = this.mergeAnnotationInteger(this.ivInitialPoolSize, this.ivXMLInitialPoolSize, annotation.initialPoolSize(), KEY_INITIAL_POOL_SIZE, -1, null);
        this.ivMaxPoolSize = this.mergeAnnotationInteger(this.ivMaxPoolSize, this.ivXMLMaxPoolSize, annotation.maxPoolSize(), KEY_MAX_POOL_SIZE, -1, null);
        this.ivMinPoolSize = this.mergeAnnotationInteger(this.ivMinPoolSize, this.ivXMLMinPoolSize, annotation.minPoolSize(), KEY_MIN_POOL_SIZE, -1, null);
        this.ivMaxIdleTime = this.mergeAnnotationInteger(this.ivMaxIdleTime, this.ivXMLMaxIdleTime, annotation.maxIdleTime(), KEY_MAX_IDLE_TIME, -1, null);
        this.ivMaxStatements = this.mergeAnnotationInteger(this.ivMaxStatements, this.ivXMLMaxStatements, annotation.maxStatements(), KEY_MAX_STATEMENTS, -1, null);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"merge");
        }
    }

    @Override
    protected void mergeError(Object oldValue, Object newValue, boolean xml, String elementName, boolean property, String key) throws InjectionConfigurationException {
        block10: {
            boolean failable = true;
            if (this.ivBinding != null) {
                if (property) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("mergeError: ignorable property conflict for " + key + ": old=" + oldValue + ", new=" + newValue), (Object[])new Object[0]);
                    }
                    if (this.ivPropertyErrors == null) {
                        this.ivPropertyErrors = new HashSet<String>();
                    }
                    this.ivPropertyErrors.add(key);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("mergeError: ignorable conflict for " + key + ": old=" + oldValue + ", new=" + newValue), (Object[])new Object[0]);
                    }
                    if (this.ivAttributeErrors == null) {
                        this.ivAttributeErrors = new HashSet<String>();
                    }
                    this.ivAttributeErrors.add(key);
                }
                if (!this.isValidationLoggable()) {
                    return;
                }
                failable = this.isValidationFailable();
            }
            try {
                super.mergeError(oldValue, newValue, xml, elementName, property, key);
            }
            catch (InjectionConfigurationException e) {
                if (!failable) break block10;
                throw e;
            }
        }
    }

    private void annotationIsolationLevelMergeError(Object newValue, String elementName) throws InjectionConfigurationException {
        boolean failable = true;
        if (this.ivBinding != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("annotationIsolationLevelError: ignorable: new=" + newValue), (Object[])new Object[0]);
            }
            if (this.ivAttributeErrors == null) {
                this.ivAttributeErrors = new HashSet<String>();
            }
            this.ivAttributeErrors.add(elementName);
            if (!this.isValidationLoggable()) {
                return;
            }
            failable = this.isValidationFailable();
        }
        String component = this.ivNameSpaceConfig.getDisplayName();
        String module = this.ivNameSpaceConfig.getModuleName();
        String application = this.ivNameSpaceConfig.getApplicationName();
        String jndiName = this.getJndiName();
        Tr.error((TraceComponent)tc, (String)"INVALID_DATA_SOURCE_ANNOTATION_ISOLATION_LEVEL_CWNEN0067E", (Object[])new Object[]{jndiName, component, module, application, newValue});
        if (failable) {
            String exMsg = "The @DataSourceDefinition source code annotation with the " + jndiName + " name attribute for the " + component + " component in the " + module + " module of the " + application + " application has configuration data for the isolationLevel attribute that is not valid: " + newValue;
            throw new InjectionConfigurationException(exMsg);
        }
    }

    private Integer mergeAnnotationIsolationLevel(Integer oldValue, boolean oldValueXML, int newValue, String elementName, int defaultValue) throws InjectionConfigurationException {
        if (newValue != defaultValue && !ISOLATION_LEVEL_NAMES.containsKey(newValue)) {
            this.annotationIsolationLevelMergeError(newValue, elementName);
            return oldValue;
        }
        return this.mergeAnnotationInteger(oldValue, oldValueXML, newValue, elementName, defaultValue, ISOLATION_LEVEL_NAMES);
    }

    @Override
    protected void mergeAnnotationPropertyError(String property) throws InjectionConfigurationException {
        block5: {
            boolean failable = true;
            if (this.ivBinding != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("annotationPropertyError: ignorable " + property), (Object[])new Object[0]);
                }
                if (!this.isValidationLoggable()) {
                    return;
                }
                failable = this.isValidationFailable();
            }
            try {
                super.mergeAnnotationPropertyError(property);
            }
            catch (InjectionConfigurationException e) {
                if (!failable) break block5;
                throw e;
            }
        }
    }

    void mergeXML(DataSource dsd) throws InjectionConfigurationException {
        int isolationLevel;
        String password;
        String user;
        String url;
        String databaseName;
        String serverName;
        String className;
        String description;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("mergeXML: name=" + this.getJndiName() + ", binding=" + this.ivBinding + ", " + dsd), (Object[])new Object[0]);
        }
        if ((description = dsd.getDescription()) != null) {
            this.ivDescription = this.mergeXMLValue(this.ivDescription, description, KEY_DESCRIPTION, KEY_DESCRIPTION, null);
            this.ivXMLDescription = true;
        }
        if ((className = dsd.getClassNameValue()) != null) {
            this.ivClassName = this.mergeXMLValue(this.ivClassName, className, "class-name", KEY_CLASS_NAME, null);
            this.ivXMLClassName = true;
        }
        if ((serverName = dsd.getServerName()) != null) {
            this.ivServerName = this.mergeXMLValue(this.ivServerName, serverName, "server-name", KEY_SERVER_NAME, null);
            this.ivXMLServerName = true;
        }
        if (dsd.isSetPortNumber()) {
            this.ivPortNumber = this.mergeXMLValue(this.ivPortNumber, dsd.getPortNumber(), "port-number", KEY_PORT_NUMBER, null);
            this.ivXMLPortNumber = true;
        }
        if ((databaseName = dsd.getDatabaseName()) != null) {
            this.ivDatabaseName = this.mergeXMLValue(this.ivDatabaseName, databaseName, "database-name", KEY_DATABASE_NAME, null);
            this.ivXMLDatabaseName = true;
        }
        if ((url = dsd.getUrl()) != null) {
            this.ivURL = this.mergeXMLValue(this.ivURL, url, KEY_URL, KEY_URL, null);
            this.ivXMLURL = true;
        }
        if ((user = dsd.getUser()) != null) {
            this.ivUser = this.mergeXMLValue(this.ivUser, user, KEY_USER, KEY_USER, null);
            this.ivXMLUser = true;
        }
        if ((password = dsd.getPassword()) != null) {
            this.ivPassword = this.mergeXMLValue(this.ivPassword, password, KEY_PASSWORD, KEY_PASSWORD, null);
            this.ivXMLPassword = true;
        }
        List dsdProps = dsd.getProperties();
        this.ivProperties = this.mergeXMLProperties(this.ivProperties, this.ivXMLProperties, dsdProps);
        if (dsd.isSetLoginTimeout()) {
            this.ivLoginTimeout = this.mergeXMLValue(this.ivLoginTimeout, dsd.getLoginTimeout(), "login-timeout", KEY_LOGIN_TIMEOUT, null);
            this.ivXMLLoginTimeout = true;
        }
        if (dsd.isSetTransactional()) {
            this.ivTransactional = this.mergeXMLValue(this.ivTransactional, dsd.isTransactional(), KEY_TRANSACTIONAL, KEY_TRANSACTIONAL, null);
            this.ivXMLTransactional = true;
        }
        if ((isolationLevel = dsd.getIsolationLevelValue()) != 0) {
            this.ivIsolationLevel = this.mergeXMLValue(this.ivIsolationLevel, isolationLevel, "isolation-level", KEY_ISOLATION_LEVEL, ISOLATION_LEVEL_NAMES);
            this.ivXMLIsolationLevel = true;
        }
        if (dsd.isSetInitialPoolSize()) {
            this.ivInitialPoolSize = this.mergeXMLValue(this.ivInitialPoolSize, dsd.getInitialPoolSize(), "initial-pool-size", KEY_INITIAL_POOL_SIZE, null);
            this.ivXMLInitialPoolSize = true;
        }
        if (dsd.isSetMaxPoolSize()) {
            this.ivMaxPoolSize = this.mergeXMLValue(this.ivMaxPoolSize, dsd.getMaxPoolSize(), "max-pool-size", KEY_MAX_POOL_SIZE, null);
            this.ivXMLMaxPoolSize = true;
        }
        if (dsd.isSetMinPoolSize()) {
            this.ivMinPoolSize = this.mergeXMLValue(this.ivMinPoolSize, dsd.getMinPoolSize(), "min-pool-size", KEY_MIN_POOL_SIZE, null);
            this.ivXMLMinPoolSize = true;
        }
        if (dsd.isSetMaxIdleTime()) {
            this.ivMaxIdleTime = this.mergeXMLValue(this.ivMaxIdleTime, dsd.getMaxIdleTime(), "max-idle-time", KEY_MAX_IDLE_TIME, null);
            this.ivXMLMaxIdleTime = true;
        }
        if (dsd.isSetMaxStatements()) {
            this.ivMaxStatements = this.mergeXMLValue(this.ivMaxStatements, dsd.getMaxStatements(), "max-statements", KEY_MAX_STATEMENTS, null);
            this.ivXMLMaxStatements = true;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mergeXML");
        }
    }

    @Override
    public void mergeSaved(InjectionBinding<DataSourceDefinition> injectionBinding) throws InjectionException {
        DataSourceDefinitionInjectionBinding dsdBinding = (DataSourceDefinitionInjectionBinding)injectionBinding;
        if (this.ivBinding != null) {
            this.mergeSavedValue(this.ivBinding, dsdBinding.ivBinding, "binding-name");
        } else {
            this.mergeSavedValue(null, dsdBinding.ivBinding, "binding-name");
            this.mergeSavedValue(this.ivDescription, dsdBinding.ivDescription, KEY_DESCRIPTION);
            this.mergeSavedValue(this.ivClassName, dsdBinding.ivClassName, "class-name");
            this.mergeSavedValue(this.ivServerName, dsdBinding.ivServerName, "server-name");
            this.mergeSavedValue(this.ivPortNumber, dsdBinding.ivPortNumber, "port-number");
            this.mergeSavedValue(this.ivDatabaseName, dsdBinding.ivDatabaseName, "database-name");
            this.mergeSavedValue(this.ivURL, dsdBinding.ivURL, KEY_URL);
            this.mergeSavedValue(this.ivUser, dsdBinding.ivUser, KEY_USER);
            this.mergeSavedValue(this.ivPassword, dsdBinding.ivPassword, KEY_PASSWORD);
            this.mergeSavedValue(this.ivProperties, dsdBinding.ivProperties, "properties");
            this.mergeSavedValue(this.ivLoginTimeout, dsdBinding.ivLoginTimeout, "login-timeout");
            this.mergeSavedValue(this.ivTransactional, dsdBinding.ivTransactional, KEY_TRANSACTIONAL);
            this.mergeSavedValue(this.ivIsolationLevel, dsdBinding.ivIsolationLevel, "isolation-level");
            this.mergeSavedValue(this.ivInitialPoolSize, dsdBinding.ivInitialPoolSize, "initial-pool-size");
            this.mergeSavedValue(this.ivMaxPoolSize, dsdBinding.ivMaxPoolSize, "max-pool-size");
            this.mergeSavedValue(this.ivMinPoolSize, dsdBinding.ivMinPoolSize, "min-pool-size");
            this.mergeSavedValue(this.ivMaxIdleTime, dsdBinding.ivMaxIdleTime, "maxidle-time");
            this.mergeSavedValue(this.ivMaxStatements, dsdBinding.ivMaxStatements, "max-statements");
        }
    }

    void resolve() throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resolve", (Object[])new Object[0]);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.ivProperties != null) {
            for (Map.Entry<String, String> entry : this.ivProperties.entrySet()) {
                String key = entry.getKey();
                if (this.ivPropertyErrors != null && this.ivPropertyErrors.contains(key)) continue;
                props.put(key, entry.getValue());
            }
        }
        this.addValidOrRemoveProperty(props, KEY_DESCRIPTION, this.ivDescription);
        this.addValidOrRemoveProperty(props, KEY_CLASS_NAME, this.ivClassName);
        this.addValidOrRemoveProperty(props, KEY_SERVER_NAME, this.ivServerName);
        this.addValidOrRemoveProperty(props, KEY_PORT_NUMBER, this.ivPortNumber);
        this.addValidOrRemoveProperty(props, KEY_DATABASE_NAME, this.ivDatabaseName);
        this.addValidOrRemoveProperty(props, KEY_URL, this.ivURL);
        this.addValidOrRemoveProperty(props, KEY_USER, this.ivUser);
        this.addValidOrRemoveProperty(props, KEY_PASSWORD, this.ivPassword);
        this.addValidOrRemoveProperty(props, KEY_LOGIN_TIMEOUT, this.ivLoginTimeout);
        this.addValidOrRemoveProperty(props, KEY_TRANSACTIONAL, this.ivTransactional);
        this.addValidOrRemoveProperty(props, KEY_ISOLATION_LEVEL, this.ivIsolationLevel);
        this.addValidOrRemoveProperty(props, KEY_INITIAL_POOL_SIZE, this.ivInitialPoolSize);
        this.addValidOrRemoveProperty(props, KEY_MIN_POOL_SIZE, this.ivMinPoolSize);
        this.addValidOrRemoveProperty(props, KEY_MAX_POOL_SIZE, this.ivMaxPoolSize);
        this.addValidOrRemoveProperty(props, KEY_MAX_IDLE_TIME, this.ivMaxIdleTime);
        this.addValidOrRemoveProperty(props, KEY_MAX_STATEMENTS, this.ivMaxStatements);
        this.setObjects(null, this.createDefinitionReference(this.ivBinding, javax.sql.DataSource.class.getName(), props));
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolve");
        }
    }

    private void addValidOrRemoveProperty(Map<String, Object> props, String key, Object value) {
        if (this.ivAttributeErrors != null && this.ivAttributeErrors.contains(key)) {
            value = null;
        }
        DataSourceDefinitionInjectionBinding.addOrRemoveProperty(props, key, value);
    }

    @Override
    public Class<?> getAnnotationType() {
        return DataSourceDefinition.class;
    }

    static {
        ISOLATION_LEVEL_NAMES.put(0, "TRANSACTION_NONE");
        ISOLATION_LEVEL_NAMES.put(1, "TRANSACTION_READ_UNCOMMITTED");
        ISOLATION_LEVEL_NAMES.put(2, "TRANSACTION_READ_COMMITTED");
        ISOLATION_LEVEL_NAMES.put(4, "TRANSACTION_REPEATABLE_READ");
        ISOLATION_LEVEL_NAMES.put(8, "TRANSACTION_SERIALIZABLE");
    }
}

