/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.endpoint;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.endpoint.JaxWsWebEndpoint;
import com.ibm.ws.jaxws.endpoint.WebServicesConfigHolder;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.jaxws.support.JaxWsInstanceManager;
import com.ibm.ws.jaxws.support.LibertyJaxWsCompatibleWSDLGetInterceptor;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.jaxws.utils.StringUtils;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.jaxws.jaxb.IgnoreUnexpectedElementValidationEventHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.frontend.WSDLGetInterceptor;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.servlet.BaseUrlHelper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractJaxWsWebEndpoint
implements JaxWsWebEndpoint {
    private static final TraceComponent tc = Tr.register(AbstractJaxWsWebEndpoint.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    public static final String DISABLE_ADDRESS_UPDATES = "disable-address-updates";
    public static final String BASE_ADDRESS = "base-address";
    private static final String HTTP_PREFIX = "http";
    private static final String SET_JAXB_VALIDATION_EVENT_HANDLER = "set-jaxb-validation-event-handler";
    protected final EndpointInfo endpointInfo;
    protected final JaxWsModuleMetaData jaxWsModuleMetaData;
    protected Server server;
    protected ServletConfig servletConfig;
    protected AbstractHTTPDestination destination;
    protected boolean disableAddressUpdates;
    protected String forcedBaseAddress;
    private static boolean issuedBetaMessage = false;
    static final long serialVersionUID = -7802015627762196821L;

    public AbstractJaxWsWebEndpoint(EndpointInfo endpointInfo, JaxWsModuleMetaData jaxWsModuleMetaData) {
        this.endpointInfo = endpointInfo;
        this.jaxWsModuleMetaData = jaxWsModuleMetaData;
    }

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        String isForcedBaseAddress;
        this.servletConfig = servletConfig;
        String isDisableAddressUpdates = servletConfig.getInitParameter(DISABLE_ADDRESS_UPDATES);
        if (!StringUtils.isEmpty(isDisableAddressUpdates)) {
            this.disableAddressUpdates = Boolean.valueOf(isDisableAddressUpdates);
        }
        if (!StringUtils.isEmpty(isForcedBaseAddress = servletConfig.getInitParameter(BASE_ADDRESS))) {
            this.forcedBaseAddress = isForcedBaseAddress;
        }
    }

    protected void customizeWSDLGetInterceptor(Class<?> implBeanClass) {
        String wsdlLocation = this.endpointInfo.getWsdlLocation();
        URL wsdlUrl = JaxWsUtils.resolve(wsdlLocation, this.jaxWsModuleMetaData.getModuleContainer());
        boolean wsdlLocationExisted = true;
        boolean wsdlLocationEmpty = StringUtils.isEmpty(wsdlLocation);
        if (!wsdlLocationEmpty && wsdlUrl == null) {
            wsdlLocationExisted = false;
            OASISCatalogManager catalogManager = (OASISCatalogManager)this.jaxWsModuleMetaData.getServerMetaData().getServerBus().getExtension(OASISCatalogManager.class);
            String resolvedLocation = null;
            if (catalogManager != null) {
                try {
                    resolvedLocation = catalogManager.resolveSystem(wsdlLocation);
                    if (resolvedLocation == null) {
                        resolvedLocation = catalogManager.resolveURI(wsdlLocation);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.jaxws.endpoint.AbstractJaxWsWebEndpoint", (String)"140", (Object)this, (Object[])new Object[]{implBeanClass});
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jaxws.endpoint.AbstractJaxWsWebEndpoint", (String)"142", (Object)this, (Object[])new Object[]{implBeanClass});
                }
            }
            if (resolvedLocation != null) {
                wsdlLocationExisted = true;
            }
        }
        if (!wsdlLocationEmpty && wsdlLocationExisted) {
            return;
        }
        String protocolBinding = this.endpointInfo.getProtocolBinding();
        if (!JaxWsUtils.isWSDLGenerationSupported(protocolBinding) || !wsdlLocationExisted) {
            List inInterceptors = this.server.getEndpoint().getInInterceptors();
            inInterceptors.remove(WSDLGetInterceptor.INSTANCE);
            inInterceptors.add(new LibertyJaxWsCompatibleWSDLGetInterceptor(implBeanClass.getCanonicalName(), wsdlLocation, wsdlLocationExisted));
        }
    }

    protected void enableLogging(EndpointInfo libertyEndpointInfo) {
        Map<String, String> endpointProperties = libertyEndpointInfo.getEndpointProperties();
        if (null != endpointProperties && Boolean.valueOf(endpointProperties.get("enableLoggingInOutInterceptor")).booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"enableLoggingInOutInterceptor has been enabled, enabling SOAP Message Logging with the LibertyLoggingInInterceptor and LibertyLoggingOutInterceptor", (Object[])new Object[0]);
            }
            if (this.jaxWsModuleMetaData != null) {
                LoggingFeature loggingFeature;
                LibertyApplicationBus bus;
                Collection featureList;
                if (this.jaxWsModuleMetaData.getServerMetaData().getServerBus() != null) {
                    LoggingFeature loggingFeature2;
                    LibertyApplicationBus bus2 = this.jaxWsModuleMetaData.getServerMetaData().getServerBus();
                    Collection featureList2 = bus2.getFeatures();
                    if (!featureList2.contains(LoggingFeature.class) && !featureList2.contains(loggingFeature2 = new LoggingFeature())) {
                        loggingFeature2.setPrettyLogging(true);
                        loggingFeature2.initialize((Bus)bus2);
                        featureList2.add(loggingFeature2);
                        bus2.setFeatures(featureList2);
                    }
                } else if (this.jaxWsModuleMetaData.getClientMetaData() != null && !(featureList = (bus = this.jaxWsModuleMetaData.getClientMetaData().getClientBus()).getFeatures()).contains(LoggingFeature.class) && !featureList.contains(loggingFeature = new LoggingFeature())) {
                    loggingFeature.setPrettyLogging(true);
                    loggingFeature.initialize((Bus)bus);
                    featureList.add(loggingFeature);
                    bus.setFeatures(featureList);
                }
            }
        }
    }

    public AbstractHTTPDestination getDestination() {
        return this.destination;
    }

    @Override
    public void destroy() {
        this.invokePreDestroy();
        this.server.destroy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        block8: {
            try {
                this.updateDestination(request);
                final HttpServletRequest req = request;
                final HttpServletResponse resp = response;
                if (!ProductInfo.getBetaEdition()) {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                            static final long serialVersionUID = -1102115270133779245L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public Void run() throws IOException {
                                AbstractJaxWsWebEndpoint.this.destination.invoke(AbstractJaxWsWebEndpoint.this.servletConfig, AbstractJaxWsWebEndpoint.this.servletConfig.getServletContext(), req, resp);
                                return null;
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.endpoint.AbstractJaxWsWebEndpoint$1", 1.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
                            }
                        });
                        break block8;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        void pae;
                        FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.jaxws.endpoint.AbstractJaxWsWebEndpoint", (String)"252", (Object)this, (Object[])new Object[]{request, response});
                        throw (IOException)pae.getException();
                    }
                }
                if (!issuedBetaMessage) {
                    Tr.debug((TraceComponent)tc, (String)("BETA: A webService configuration beta method has been invoked for the class " + this.getClass().getName() + " for the first time."), (Object[])new Object[0]);
                    issuedBetaMessage = !issuedBetaMessage;
                }
                this.configureWebServicesConfig();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                        static final long serialVersionUID = 5028126260210242758L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Void run() throws IOException {
                            AbstractJaxWsWebEndpoint.this.destination.invoke(AbstractJaxWsWebEndpoint.this.servletConfig, AbstractJaxWsWebEndpoint.this.servletConfig.getServletContext(), req, resp);
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.endpoint.AbstractJaxWsWebEndpoint$2", 2.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    FFDCFilter.processException((Throwable)pae, (String)"com.ibm.ws.jaxws.endpoint.AbstractJaxWsWebEndpoint", (String)"272", (Object)this, (Object[])new Object[]{request, response});
                    throw (IOException)pae.getException();
                }
            }
            catch (IOException req) {
                void e;
                FFDCFilter.processException((Throwable)req, (String)"com.ibm.ws.jaxws.endpoint.AbstractJaxWsWebEndpoint", (String)"279", (Object)this, (Object[])new Object[]{request, response});
                throw new ServletException((Throwable)e);
            }
        }
    }

    private void configureWebServicesConfig() {
        boolean debug = tc.isDebugEnabled();
        if (!WebServicesConfigHolder.isConfigExists()) {
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)"No configuration found. Returning.", (Object[])new Object[0]);
            }
            return;
        }
        org.apache.cxf.service.model.EndpointInfo cxfEndpointInfo = this.destination.getEndpointInfo();
        QName portNameQname = this.endpointInfo.getWsdlPort();
        String portName = portNameQname.getLocalPart();
        if (debug) {
            Tr.debug((TraceComponent)tc, (String)(portName + " will be used to find webService Configuration"), (Object[])new Object[0]);
        }
        Object enableSchemaValidation = null;
        Object ignoreUnexpectedElements = null;
        Object enableDefaultValidation = null;
        if (portName != null) {
            if (WebServicesConfigHolder.getEnableSchemaValidation(portName) != null) {
                enableSchemaValidation = WebServicesConfigHolder.getEnableSchemaValidation(portName);
            } else if (WebServicesConfigHolder.getEnableSchemaValidation("default") != null) {
                enableSchemaValidation = WebServicesConfigHolder.getEnableSchemaValidation("default");
            }
            if (WebServicesConfigHolder.getIgnoreUnexpectedElements(portName) != null) {
                ignoreUnexpectedElements = WebServicesConfigHolder.getIgnoreUnexpectedElements(portName);
            } else if (WebServicesConfigHolder.getIgnoreUnexpectedElements("default") != null) {
                ignoreUnexpectedElements = WebServicesConfigHolder.getIgnoreUnexpectedElements("default");
            }
            if (WebServicesConfigHolder.getEnableDefaultValidation(portName) != null) {
                enableDefaultValidation = WebServicesConfigHolder.getEnableDefaultValidation(portName);
            } else if (WebServicesConfigHolder.getEnableDefaultValidation("default") != null) {
                enableDefaultValidation = WebServicesConfigHolder.getEnableDefaultValidation("default");
            }
        } else {
            enableSchemaValidation = WebServicesConfigHolder.getEnableSchemaValidation("default") != null ? WebServicesConfigHolder.getEnableSchemaValidation("default") : null;
            ignoreUnexpectedElements = WebServicesConfigHolder.getIgnoreUnexpectedElements("default") != null ? WebServicesConfigHolder.getIgnoreUnexpectedElements("default") : null;
            Object object = enableDefaultValidation = WebServicesConfigHolder.getEnableDefaultValidation("default") != null ? WebServicesConfigHolder.getEnableDefaultValidation("default") : null;
        }
        if (enableSchemaValidation == null && ignoreUnexpectedElements == null && enableDefaultValidation == null) {
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)"No webService configuration found. returning.", (Object[])new Object[0]);
            }
            return;
        }
        if (enableSchemaValidation != null) {
            cxfEndpointInfo.setProperty("schema-validation-enabled", enableSchemaValidation);
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)("Set schema-validation-enabled to " + enableSchemaValidation), (Object[])new Object[0]);
            }
        } else if (debug) {
            Tr.debug((TraceComponent)tc, (String)"enableSchemaValdiation was null, not configuring schema-validation-enabled on the Web Service Endpoint", (Object[])new Object[0]);
        }
        if (ignoreUnexpectedElements != null && ((Boolean)ignoreUnexpectedElements).booleanValue()) {
            cxfEndpointInfo.setProperty(SET_JAXB_VALIDATION_EVENT_HANDLER, ignoreUnexpectedElements);
            IgnoreUnexpectedElementValidationEventHandler unexpectedElementValidationEventHandler = new IgnoreUnexpectedElementValidationEventHandler();
            cxfEndpointInfo.setProperty("jaxb-reader-validation-event-handler", (Object)unexpectedElementValidationEventHandler);
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)("Set JAXBDataBinding.SET_VALIDATION_EVENT_HANDLER to  " + ignoreUnexpectedElements), (Object[])new Object[0]);
            }
            if (enableDefaultValidation != null && ((Boolean)enableDefaultValidation).booleanValue()) {
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)"Both ignoreUnexpectedElements and enableDefaultValidation are enabled. EnableDefaultValidation will be ignored.", (Object[])new Object[0]);
                }
                return;
            }
        } else if (debug) {
            Tr.debug((TraceComponent)tc, (String)("IgnoreUnexpectedElements was " + ignoreUnexpectedElements + " not configuring ignoreUnexpectedElements on the Web Service Endpoint"), (Object[])new Object[0]);
        }
        if (enableDefaultValidation != null) {
            if (((Boolean)enableDefaultValidation).booleanValue()) {
                cxfEndpointInfo.setProperty(SET_JAXB_VALIDATION_EVENT_HANDLER, (Object)true);
                DefaultValidationEventHandler defaultValidationEventHandler = new DefaultValidationEventHandler();
                cxfEndpointInfo.setProperty("jaxb-reader-validation-event-handler", (Object)defaultValidationEventHandler);
            }
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)("Set JAXBDataBinding.SET_VALIDATION_EVENT_HANDLER to  " + enableDefaultValidation), (Object[])new Object[0]);
            }
        } else if (debug) {
            Tr.debug((TraceComponent)tc, (String)("enableDefaultValidation was " + enableDefaultValidation + " not configuring enableDefaultValidation on the Web Service Endpoint"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void invokePreDestroy() {
        List handlers = ((JaxWsEndpointImpl)this.server.getEndpoint()).getJaxwsBinding().getHandlerChain();
        JaxWsInstanceManager jaxWsInstanceManager = this.jaxWsModuleMetaData.getJaxWsInstanceManager();
        for (Handler handler : handlers) {
            try {
                jaxWsInstanceManager.destroyInstance(handler);
            }
            catch (JaxWsInstanceManager.InterceptException interceptException) {
                void e;
                FFDCFilter.processException((Throwable)interceptException, (String)"com.ibm.ws.jaxws.endpoint.AbstractJaxWsWebEndpoint", (String)"441", (Object)this, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"warn.invoke.handler.predestory", (Object[])new Object[]{handler.getClass().getName(), e.getMessage()});
            }
        }
    }

    protected void configureEndpointInfoProperties(EndpointInfo libertyEndpointInfo, org.apache.cxf.service.model.EndpointInfo cxfEndpointInfo) {
        cxfEndpointInfo.setProperty(SET_JAXB_VALIDATION_EVENT_HANDLER, (Object)false);
        cxfEndpointInfo.setProperty("autoRewriteSoapAddressForAllServices", (Object)true);
        try {
            String wsdlLocation = libertyEndpointInfo.getWsdlLocation();
            if (wsdlLocation != null && !wsdlLocation.isEmpty()) {
                URI wsdlDescription = new URI(wsdlLocation);
                cxfEndpointInfo.setProperty("URI", (Object)wsdlDescription);
            }
        }
        catch (URISyntaxException wsdlLocation) {
            FFDCFilter.processException((Throwable)wsdlLocation, (String)"com.ibm.ws.jaxws.endpoint.AbstractJaxWsWebEndpoint", (String)"467", (Object)this, (Object[])new Object[]{libertyEndpointInfo, cxfEndpointInfo});
        }
        Map<String, String> endpointProperties = libertyEndpointInfo.getEndpointProperties();
        if (endpointProperties != null && !endpointProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : endpointProperties.entrySet()) {
                cxfEndpointInfo.setProperty(entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDestination(HttpServletRequest request) {
        String ad = this.destination.getEndpointInfo().getAddress();
        if (ad != null && ad.startsWith(HTTP_PREFIX)) {
            return;
        }
        AbstractHTTPDestination abstractHTTPDestination = this.destination;
        synchronized (abstractHTTPDestination) {
            ad = this.destination.getEndpointInfo().getAddress();
            if (ad == null && this.destination.getAddress() != null && this.destination.getAddress().getAddress() != null && (ad = this.destination.getAddress().getAddress().getValue()) == null) {
                ad = "/";
            }
            if (ad != null && !ad.startsWith(HTTP_PREFIX)) {
                String base = this.getBaseURL(request);
                if (this.disableAddressUpdates) {
                    request.setAttribute("org.apache.cxf.transport.endpoint.address", (Object)(base + ad));
                } else if (this.destination.getEndpointInfo().getAddress() == null) {
                    BaseUrlHelper.setAddress((AbstractDestination)this.destination, (String)(base + ad));
                }
            }
        }
    }

    protected String getBaseURL(HttpServletRequest request) {
        String pathInfo;
        if (this.forcedBaseAddress != null) {
            return this.forcedBaseAddress;
        }
        String reqPrefix = request.getRequestURL().toString();
        String string = pathInfo = request.getPathInfo() == null ? "" : request.getPathInfo();
        if (!"/".equals(pathInfo) || reqPrefix.endsWith("/")) {
            StringBuilder sb = new StringBuilder();
            URI uri = URI.create(reqPrefix);
            sb.append(uri.getScheme()).append("://").append(uri.getRawAuthority());
            sb.append(request.getContextPath());
            reqPrefix = sb.toString();
        }
        return reqPrefix;
    }
}

