/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.Objects;
import org.eclipse.microprofile.metrics.DefaultMetadata;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;

public class MetadataBuilder {
    private String name;
    private String displayName;
    private String description;
    private MetricType type = MetricType.INVALID;
    private String unit = "none";
    private boolean reusable = true;

    MetadataBuilder(Metadata metadata) {
        this.name = metadata.getName();
        this.type = metadata.getTypeRaw();
        this.reusable = metadata.isReusable();
        this.displayName = metadata.getDisplayName();
        metadata.getDescription().ifPresent(this::withDescription);
        metadata.getUnit().ifPresent(this::withUnit);
    }

    public MetadataBuilder() {
    }

    public MetadataBuilder withName(String name) {
        this.name = Objects.requireNonNull(name, "name is required");
        return this;
    }

    public MetadataBuilder withDisplayName(String displayName) {
        this.displayName = Objects.requireNonNull(displayName, "displayName is required");
        return this;
    }

    public MetadataBuilder withDescription(String description) {
        this.description = Objects.requireNonNull(description, "description is required");
        return this;
    }

    public MetadataBuilder withType(MetricType type) {
        this.type = Objects.requireNonNull(type, "type is required");
        return this;
    }

    public MetadataBuilder withUnit(String unit) {
        this.unit = Objects.requireNonNull(unit, "unit is required");
        return this;
    }

    public MetadataBuilder reusable() {
        this.reusable = true;
        return this;
    }

    public MetadataBuilder notReusable() {
        this.reusable = false;
        return this;
    }

    public Metadata build() {
        if (Objects.isNull(this.name)) {
            throw new IllegalStateException("Name is required");
        }
        return new DefaultMetadata(this.name, this.displayName, this.description, this.type, this.unit, this.reusable);
    }
}

