/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.config.Component;
import com.ibm.ws.cache.config.Property;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;

public class CacheId {
    protected static TraceComponent tc = Tr.register(CacheId.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public int timeout;
    public int inactivity;
    public int priority;
    public String idGenerator;
    public String metaDataGenerator;
    public HashMap properties;
    public Component[] components;
    public Object idGeneratorImpl;
    public Object metaDataGeneratorImpl;
    public Object[] processorData = null;

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("timeout          : " + this.timeout);
        pw.println("inactivity       : " + this.inactivity);
        pw.println("priority         : " + this.priority);
        pw.println("idGenerator      : " + this.idGenerator);
        pw.println("metaDataGenerator: " + this.metaDataGenerator);
        pw.println("properties       : " + this.properties);
        for (int i = 0; this.components != null && i < this.components.length; ++i) {
            pw.println("Component " + i);
            pw.println(this.components[i]);
        }
        return sw.toString();
    }

    public String fancyFormat(int level) {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (i = level; i > 0; --i) {
            pw.print("\t");
        }
        pw.println("timeout          : " + this.timeout);
        for (i = level; i > 0; --i) {
            pw.print("\t");
        }
        pw.println("inactivity       : " + this.inactivity);
        for (i = level; i > 0; --i) {
            pw.print("\t");
        }
        pw.println("priority         : " + this.priority);
        for (i = level; i > 0; --i) {
            pw.print("\t");
        }
        pw.println("idGenerator      : " + this.idGenerator);
        for (i = level; i > 0; --i) {
            pw.print("\t");
        }
        pw.println("metaDataGenerator: " + this.metaDataGenerator);
        for (i = level; i > 0; --i) {
            pw.print("\t");
        }
        for (i = 0; this.properties != null && i < this.properties.size(); ++i) {
            for (int ii = level; ii > 0; --ii) {
                pw.print("\t");
            }
            pw.println("property " + i + ":");
            Iterator it = this.properties.values().iterator();
            while (it.hasNext()) {
                pw.println(((Property)it.next()).fancyFormat(level + 1));
            }
        }
        for (i = 0; this.components != null && i < this.components.length; ++i) {
            for (int ii = level; ii > 0; --ii) {
                pw.print("\t");
            }
            pw.println("Component " + i + ":");
            pw.println(this.components[i].fancyFormat(level + 1));
        }
        return sw.toString();
    }

    public Object clone() {
        CacheId c = new CacheId();
        c.timeout = this.timeout;
        c.inactivity = this.inactivity;
        c.priority = this.priority;
        c.idGenerator = this.idGenerator;
        c.metaDataGenerator = this.metaDataGenerator;
        if (this.properties != null) {
            c.properties = new HashMap(this.properties.size());
            for (Object key : this.properties.keySet()) {
                c.properties.put(key, ((Property)this.properties.get(key)).clone());
            }
        }
        if (this.components != null) {
            c.components = new Component[this.components.length];
            for (int i = 0; i < this.components.length; ++i) {
                c.components[i] = (Component)this.components[i].clone();
            }
        }
        if (this.processorData != null) {
            c.processorData = new Object[this.processorData.length];
            for (int i = 0; i < this.processorData.length; ++i) {
                c.processorData[i] = this.processorData[i];
            }
        }
        return c;
    }
}

