/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertyArrayConfiguration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HistogramBucketConfiguration
extends PropertyArrayConfiguration<Double> {
    private static final TraceComponent tc = Tr.register(HistogramBucketConfiguration.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = -440560434747170512L;

    public HistogramBucketConfiguration(String metricName, Double[] values) {
        super(metricName, values);
    }

    public static Collection<HistogramBucketConfiguration> parse(String input) {
        String[] metricValuePairs;
        ArrayDeque<HistogramBucketConfiguration> metricBucketConfiCollection = new ArrayDeque<HistogramBucketConfiguration>();
        if (input == null || input.length() == 0) {
            return null;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            HistogramBucketConfiguration metricBucketConfiguration = null;
            if (keyValueSplit.length == 1) continue;
            Object[] bucketValues = (Double[])Arrays.asList(keyValueSplit[1].split(",")).stream().map(s -> {
                if (s.matches("[0-9]+[.]*[0-9]*")) {
                    return Double.parseDouble(s);
                }
                Tr.warning((TraceComponent)tc, (String)"invalidHistogramValueConfigured.warning.CWMMC0015W", (Object[])new Object[]{s, "mp.metrics.distribution.histogram.buckets"});
                return null;
            }).filter(x -> x != null).toArray(Double[]::new);
            Arrays.sort(bucketValues);
            metricBucketConfiguration = new HistogramBucketConfiguration(metricName, (Double[])bucketValues);
            metricBucketConfiCollection.addFirst(metricBucketConfiguration);
        }
        return metricBucketConfiCollection;
    }
}

