/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.metadata.FormLoginConfiguration;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FormLoginAuthenticator
implements WebAuthenticator {
    private static final TraceComponent tc = Tr.register(FormLoginAuthenticator.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    private final WebAuthenticator ssoAuthenticator;
    private final WebAppSecurityConfig webAppSecurityConfig;
    private final PostParameterHelper postParameterHelper;
    private final WebProviderAuthenticatorProxy providerAuthenticatorProxy;
    static final long serialVersionUID = -508003929434200334L;

    public FormLoginAuthenticator(WebAuthenticator ssoAuthn, WebAppSecurityConfig webAppSecConfig, WebProviderAuthenticatorProxy providerAuthenticatorProxy) {
        this.webAppSecurityConfig = webAppSecConfig;
        this.ssoAuthenticator = ssoAuthn;
        this.providerAuthenticatorProxy = providerAuthenticatorProxy;
        this.postParameterHelper = new PostParameterHelper(webAppSecConfig);
    }

    @Override
    public AuthenticationResult authenticate(WebRequest webRequest) {
        return this.authenticate(webRequest, this.webAppSecurityConfig);
    }

    public AuthenticationResult authenticate(WebRequest webRequest, WebAppSecurityConfig webAppSecurityConfigImpl) {
        HttpServletRequest req = webRequest.getHttpServletRequest();
        HttpServletResponse res = webRequest.getHttpServletResponse();
        AuthenticationResult authResult = this.handleFormLogin(req, res, webRequest);
        return authResult;
    }

    /*
     * WARNING - void declaration
     */
    private AuthenticationResult handleFormLogin(HttpServletRequest req, HttpServletResponse res, WebRequest webRequest) {
        AuthenticationResult authResult = null;
        authResult = this.ssoAuthenticator.authenticate(webRequest);
        if (authResult != null) {
            authResult.setAuditCredType("FORM");
        }
        if (authResult != null && authResult.getStatus() != AuthResult.FAILURE) {
            this.postParameterHelper.restore(req, res);
            return authResult;
        }
        try {
            authResult = this.providerAuthenticatorProxy.authenticate(req, res, null);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.internal.FormLoginAuthenticator", (String)"101", (Object)this, (Object[])new Object[]{req, res, webRequest});
            return new AuthenticationResult(AuthResult.FAILURE, e.getLocalizedMessage());
        }
        if (authResult.getStatus() == AuthResult.CONTINUE) {
            authResult = null;
            if (webRequest.isFormLoginRedirectEnabled() && (authResult = this.handleRedirect(req, res, webRequest)) != null) {
                authResult.setAuditCredType("FORM");
                authResult.setAuditOutcome("redirect");
            }
        }
        return authResult;
    }

    private AuthenticationResult handleRedirect(HttpServletRequest req, HttpServletResponse res, WebRequest webRequest) {
        String loginURL = this.getFormLoginURL(req, webRequest, this.webAppSecurityConfig);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("form login URL: " + loginURL), (Object[])new Object[0]);
        }
        AuthenticationResult authResult = new AuthenticationResult(AuthResult.REDIRECT, loginURL);
        if (this.allowToAddCookieToResponse(this.webAppSecurityConfig, req)) {
            this.postParameterHelper.save(req, res, authResult);
            ReferrerURLCookieHandler referrerURLHandler = this.webAppSecurityConfig.createReferrerURLCookieHandler();
            Cookie c = referrerURLHandler.createReferrerURLCookie("WASReqURL", this.getReqURL(req), req);
            authResult.setCookie(c);
        }
        return authResult;
    }

    @Sensitive
    private String getReqURL(HttpServletRequest req) {
        Object url = null;
        StringBuffer reqURL = req.getRequestURL();
        if (req.getQueryString() != null) {
            reqURL.append("?");
            reqURL.append(req.getQueryString());
        }
        return reqURL.toString();
    }

    private String normalizeURL(String url, String contextPath) {
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        if (contextPath == null) {
            return url;
        }
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        return contextPath + url;
    }

    private String getFormLoginURL(HttpServletRequest req, WebRequest webRequest, WebAppSecurityConfig webAppSecConfig) {
        FormLoginConfiguration formLoginConfig = webRequest.getFormLoginConfiguration();
        String inURL = null;
        String contextPath = null;
        String authMech = webAppSecConfig.getOverrideHttpAuthMethod();
        if (authMech != null && (authMech.equals("CLIENT_CERT") && webAppSecConfig.getAllowFailOverToFormLogin() || authMech.equals("FORM"))) {
            inURL = webAppSecConfig.getLoginFormURL();
            contextPath = webAppSecConfig.getLoginFormContextRoot();
        } else if (formLoginConfig != null) {
            inURL = formLoginConfig.getLoginPage();
            if (inURL != null) {
                contextPath = req.getContextPath();
            } else {
                inURL = webAppSecConfig.getLoginFormURL();
            }
        }
        return this.buildFormLoginURL(req, inURL, contextPath);
    }

    private String buildFormLoginURL(HttpServletRequest req, String inURL, String contextPath) {
        if (inURL == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(req.getRequestURL());
        int hostIndex = builder.indexOf("//");
        int contextIndex = builder.indexOf("/", hostIndex + 2);
        builder.replace(contextIndex, builder.length(), this.normalizeURL(inURL, contextPath));
        return builder.toString();
    }

    private boolean allowToAddCookieToResponse(WebAppSecurityConfig config, HttpServletRequest req) {
        boolean secureRequest = req.isSecure();
        if (config.getSSORequiresSSL() && !secureRequest) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSO requires SSL. The cookie will not be sent back because the request is not over https.", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    public AuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, HashMap props) throws Exception {
        return null;
    }
}

