/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.xml.bind.JAXBContext;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.model.SoapBodyInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.interceptors.HolderOutInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class SwAOutInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SwAOutInterceptor.class);
    private static final Map<String, Method> SWA_REF_METHOD = new ConcurrentHashMap<String, Method>(4, 0.75f, 2);
    private static final Set<String> SWA_REF_NO_METHOD = Collections.newSetFromMap(new ConcurrentHashMap(4, 0.75f, 2));
    private static boolean skipHasSwaRef;
    AttachmentOutInterceptor attachOut;
    static final long serialVersionUID = 3429731309184277439L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SwAOutInterceptor() {
        super("pre-logical");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "<init>", new Object[0]);
        }
        this.attachOut = new AttachmentOutInterceptor();
        this.addAfter(HolderOutInterceptor.class.getName());
        this.addBefore(WrapperClassOutInterceptor.class.getName());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("WrapperClassOutInterceptor is added before and HolderOutInterceptor is added after SwAOutInterceptor.");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean callSWARefMethod(final JAXBContext ctx) {
        block14: {
            boolean bl;
            block15: {
                Method m;
                boolean isFinestEnabled;
                block13: {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "callSWARefMethod", new Object[]{ctx});
                    }
                    isFinestEnabled = LOG.isLoggable(Level.FINEST);
                    String cname = ctx.getClass().getName();
                    m = SWA_REF_METHOD.get(cname);
                    if (isFinestEnabled) {
                        LOG.finest("Method that is obtained from SWA_REF_METHOD with JAXBContext class name: " + cname + "  is : " + m);
                    }
                    if (m == null && !SWA_REF_NO_METHOD.contains(cname)) {
                        try {
                            m = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){
                                static final long serialVersionUID = -2473244584917779893L;
                                private static final /* synthetic */ TraceComponent $$$tc$$$;

                                @Override
                                public Method run() throws Exception {
                                    Method hasSwaRefMethod = ctx.getClass().getMethod("hasSwaRef", new Class[0]);
                                    if (!hasSwaRefMethod.isAccessible()) {
                                        hasSwaRefMethod.setAccessible(true);
                                    }
                                    return hasSwaRefMethod;
                                }

                                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                static {
                                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.interceptors.SwAOutInterceptor$1", 1.class, null, null);
                                }
                            });
                            if (isFinestEnabled) {
                                LOG.finest("Method that is obtained from SWA_REF_METHOD with JAXBContext class name: " + cname + " using privileged access: " + m);
                            }
                            if (m == null) {
                                SWA_REF_NO_METHOD.add(cname);
                                if (isFinestEnabled) {
                                    LOG.finest("JAXBContext class name: " + cname + " is added to SWA_REF_NO_METHOD.");
                                }
                            } else {
                                SWA_REF_METHOD.put(cname, m);
                                if (isFinestEnabled) {
                                    LOG.finest("Method : " + m + " is added to SWA_REF_METHOD with JAXBContext class name: " + cname);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!isFinestEnabled) break block13;
                            LOG.finest("Exception stacktrace while calling SWARefMethod: " + e.getStackTrace());
                        }
                    }
                }
                try {
                    if (m == null) break block14;
                    bl = (Boolean)m.invoke((Object)ctx, new Object[0]);
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block15;
                }
                catch (Exception e) {
                    if (!isFinestEnabled) break block14;
                    LOG.finest("Exception invoking method with JAXBContext: " + e.getStackTrace());
                }
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "callSWARefMethod", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "callSWARefMethod", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(@Sensitive SoapMessage message) throws Fault {
        SoapBodyInfo sbi;
        boolean client;
        BindingMessageInfo bmi;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "handleMessage", objectArray);
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        boolean isFineEnabled = LOG.isLoggable(Level.FINE);
        Exchange ex = message.getExchange();
        BindingOperationInfo bop = ex.getBindingOperationInfo();
        if (bop == null) {
            if (isFinestEnabled) {
                LOG.finest("BindingOperationInfo is null. Returning.");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "handleMessage");
            }
            return;
        }
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
            if (isFinestEnabled) {
                LOG.finest("BindingOperationInfo is switched to wrapped version.");
            }
        }
        BindingMessageInfo bindingMessageInfo = bmi = (client = this.isRequestor((Message)message)) ? bop.getInput() : bop.getOutput();
        if (bmi == null) {
            if (isFinestEnabled) {
                LOG.finest("BindingMessageInfo is null. Returning.");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "handleMessage");
            }
            return;
        }
        Boolean newAttachment = false;
        Message exOutMsg = ex.getOutMessage();
        if (exOutMsg != null) {
            newAttachment = MessageUtils.isTrue((Object)exOutMsg.getContextualProperty("cxf.add.attachments"));
            if (isFineEnabled) {
                LOG.fine("Request context attachment property: cxf.add.attachments is set to: " + newAttachment);
            }
        }
        if ((sbi = (SoapBodyInfo)bmi.getExtensor(SoapBodyInfo.class)) == null || sbi.getAttachments() == null || sbi.getAttachments().isEmpty()) {
            Service s = ex.getService();
            DataBinding db = s.getDataBinding();
            if (db instanceof JAXBDataBinding && this.hasSwaRef((JAXBDataBinding)db)) {
                Boolean includeAttachs = false;
                Message exInpMsg = ex.getInMessage();
                if (isFineEnabled) {
                    LOG.log(Level.FINE, "Exchange Input message: " + exInpMsg);
                }
                if (exInpMsg != null) {
                    includeAttachs = MessageUtils.isTrue((Object)exInpMsg.getContextualProperty("cxf.add.attachments"));
                }
                if (isFineEnabled) {
                    LOG.log(Level.FINE, "Add attachments message property: cxf.add.attachments value is " + includeAttachs);
                }
                if (!skipHasSwaRef || includeAttachs.booleanValue() || newAttachment.booleanValue()) {
                    this.setupAttachmentOutput(message);
                } else {
                    this.skipAttachmentOutput(message);
                }
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "handleMessage");
            }
            return;
        }
        this.processAttachments(message, sbi);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void processAttachments(@Sensitive SoapMessage message, SoapBodyInfo sbi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
            objectArray[1] = sbi;
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "processAttachments", objectArray);
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        Collection<Attachment> atts = this.setupAttachmentOutput(message);
        List outObjects = CastUtils.cast((List)((List)message.getContent(List.class)));
        for (MessagePartInfo mpi : sbi.getAttachments()) {
            DataHandler dh;
            int idx;
            Object o;
            String partName = mpi.getConcreteName().getLocalPart();
            String ct = (String)mpi.getProperty("Content-Type");
            String id = partName + '=' + UUID.randomUUID() + "@apache.org";
            if (isFinestEnabled) {
                LOG.finest("Id created for MessagePartInfo: " + id);
            }
            if ((o = outObjects.get(idx = mpi.getIndex())) == null) {
                if (!isFinestEnabled) continue;
                LOG.finest("MessagePartInfo with index: " + idx + " doesn't exist in message content.This MessagePartInfo will be skipped.");
                continue;
            }
            outObjects.set(idx, null);
            if (isFinestEnabled) {
                LOG.finest("Object that is obtained from message content with index: (" + idx + ") is : " + o);
            }
            if (o instanceof Source) {
                dh = new DataHandler(this.createDataSource((Source)o, ct));
                if (isFinestEnabled) {
                    LOG.finest("DataHandler constructed by DataSource creation with Source parameter: " + dh);
                }
            } else if (o instanceof Image) {
                final Image img = (Image)o;
                final String contentType = ct;
                dh = new DataHandler(o, ct){
                    static final long serialVersionUID = 3079759555681251180L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public InputStream getInputStream() throws IOException {
                        LoadingByteArrayOutputStream bout = new LoadingByteArrayOutputStream();
                        this.writeTo((OutputStream)bout);
                        return bout.createInputStream();
                    }

                    public void writeTo(OutputStream out) throws IOException {
                        ImageWriter writer = null;
                        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(contentType);
                        if (writers.hasNext()) {
                            writer = writers.next();
                        }
                        if (writer != null) {
                            BufferedImage bimg = SwAOutInterceptor.this.convertToBufferedImage(img);
                            ImageOutputStream iout = ImageIO.createImageOutputStream(out);
                            writer.setOutput(iout);
                            writer.write(bimg);
                            writer.dispose();
                            iout.flush();
                            out.flush();
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.interceptors.SwAOutInterceptor$2", 2.class, null, null);
                    }
                };
                if (isFinestEnabled) {
                    LOG.finest("DataHandler constructed by Stream creation: " + dh);
                }
            } else if (o instanceof DataHandler) {
                dh = (DataHandler)o;
                ct = dh.getContentType();
                try {
                    if ("text/xml".equals(ct) && dh.getContent() instanceof Source) {
                        dh = new DataHandler(this.createDataSource((Source)dh.getContent(), ct));
                    }
                }
                catch (IOException img) {
                    // empty catch block
                }
                if (isFinestEnabled) {
                    LOG.finest("DataHandler constructed by DataSource creation with DataHandler content as Source parameter: " + dh);
                }
            } else if (o instanceof byte[]) {
                if (ct == null) {
                    ct = "application/octet-stream";
                }
                dh = new DataHandler((DataSource)new ByteDataSource((byte[])o, ct));
                if (isFinestEnabled) {
                    LOG.finest("DataHandler constructed from ByteDataSource by byte[] object: " + dh);
                }
            } else if (o instanceof String) {
                if (ct == null) {
                    ct = "text/plain; charset='UTF-8'";
                }
                dh = new DataHandler((DataSource)new ByteDataSource(((String)o).getBytes(StandardCharsets.UTF_8), ct));
                if (isFinestEnabled) {
                    LOG.finest("DataHandler constructed with ByteDataSource by String object: " + dh);
                }
            } else {
                throw new Fault(new org.apache.cxf.common.i18n.Message("ATTACHMENT_NOT_SUPPORTED", LOG, new Object[]{o.getClass()}));
            }
            AttachmentImpl att = new AttachmentImpl(id);
            att.setDataHandler(dh);
            att.setHeader("Content-Type", ct);
            att.setHeader("Content-ID", "<" + id + ">");
            atts.add((Attachment)att);
            if (!isFinestEnabled) continue;
            LOG.finest("AttachmentImpl is added to attachment collection " + att + ", with DataHandler: " + dh + ", Content-Type: " + ct + ", Content-ID:" + id);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "processAttachments");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean hasSwaRef(JAXBDataBinding db) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "hasSwaRef", new Object[]{db});
        }
        JAXBContext context = db.getContext();
        boolean bl = this.callSWARefMethod(context);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "hasSwaRef", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private DataSource createDataSource(Source o, String ct) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "createDataSource", new Object[]{o, ct});
        }
        ByteDataSource ds = null;
        if (o instanceof StreamSource) {
            StreamSource src = (StreamSource)o;
            try {
                if (src.getInputStream() != null) {
                    try (ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);){
                        IOUtils.copy((InputStream)src.getInputStream(), (OutputStream)bos, (int)1024);
                        ds = new ByteDataSource(bos.toByteArray(), ct);
                    }
                }
                ds = new ByteDataSource(IOUtils.toString((Reader)src.getReader()).getBytes(StandardCharsets.UTF_8), ct);
            }
            catch (IOException e) {
                throw new Fault((Throwable)e);
            }
        } else {
            ByteArrayOutputStream bwriter = new ByteArrayOutputStream();
            XMLStreamWriter writer = null;
            try {
                writer = StaxUtils.createXMLStreamWriter((OutputStream)bwriter);
                StaxUtils.copy((Source)o, (XMLStreamWriter)writer);
                writer.flush();
                ds = new ByteDataSource(bwriter.toByteArray(), ct);
            }
            catch (XMLStreamException e1) {
                throw new Fault((Throwable)e1);
            }
            finally {
                StaxUtils.close((XMLStreamWriter)writer);
            }
        }
        ByteDataSource byteDataSource = ds;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            byteDataSource = byteDataSource;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "createDataSource", byteDataSource);
        }
        return byteDataSource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private BufferedImage convertToBufferedImage(Image image) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "convertToBufferedImage", new Object[]{image});
        }
        if (image instanceof BufferedImage) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Image is already a BufferedImage. Returning the cached image.");
            }
            BufferedImage bufferedImage = (BufferedImage)image;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bufferedImage = bufferedImage;
                LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "convertToBufferedImage", bufferedImage);
            }
            return bufferedImage;
        }
        MediaTracker tracker = new MediaTracker(new Component(){
            private static final long serialVersionUID = 6412221228374321325L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.interceptors.SwAOutInterceptor$3", 3.class, null, null);
            }
        });
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            throw new Fault((Throwable)e);
        }
        BufferedImage bufImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        BufferedImage bufferedImage = bufImage;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bufferedImage = bufferedImage;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "convertToBufferedImage", bufferedImage);
        }
        return bufferedImage;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Collection<Attachment> setupAttachmentOutput(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "setupAttachmentOutput", new Object[]{message});
        }
        message.getInterceptorChain().add((Interceptor)this.attachOut);
        message.put((Object)"write.attachments", (Object)Boolean.TRUE);
        ArrayList<Attachment> atts = message.getAttachments();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINE, "setupAttachmentOutput: getAttachments returned  " + atts);
        }
        if (atts == null) {
            atts = new ArrayList<Attachment>();
            message.setAttachments(atts);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("There is no attachment in the message. An empty list is created and set in the message.");
            }
        }
        ArrayList<Attachment> arrayList = atts;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "setupAttachmentOutput", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Collection<Attachment> skipAttachmentOutput(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "skipAttachmentOutput", new Object[]{message});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        ArrayList<Attachment> atts = message.getAttachments();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("skipAttachmentOutput: getAttachments returned  " + atts);
        }
        if (atts != null) {
            message.getInterceptorChain().add((Interceptor)this.attachOut);
            message.put((Object)"write.attachments", (Object)Boolean.TRUE);
            if (isFinestEnabled) {
                LOG.finest("AttachmentOutInterceptor is set into interceptor chain. write.attachments is set to true in message.");
            }
        } else {
            atts = new ArrayList<Attachment>();
            message.setAttachments(atts);
            if (isFinestEnabled) {
                LOG.finest("A newly created empty list is set as attachements.");
            }
        }
        ArrayList<Attachment> arrayList = atts;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAOutInterceptor", "skipAttachmentOutput", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        String skipSwaRef = System.getProperty("cxf.multipart.attachment");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("cxf.multipart.attachment property value: " + skipSwaRef);
        }
        skipHasSwaRef = skipSwaRef != null && skipSwaRef.trim().length() > 0 && skipSwaRef.trim().equalsIgnoreCase("false");
    }
}

