/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.encryption;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.encryption.AuditCrypto;
import com.ibm.ws.security.audit.source.utils.ByteArray;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuditKeyEncryptor {
    private final String algorithm = "SHA256";
    byte[] password;
    byte[] passwordDigestBytes;
    AuditCrypto des;
    static final long serialVersionUID = 4894245175811871690L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public AuditKeyEncryptor(byte[] password) {
        this.password = password;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA256");
            this.passwordDigestBytes = new byte[32];
            byte[] digest = md.digest(this.password);
            ByteArray.copy(digest, 0, digest.length, this.passwordDigestBytes, 0);
        }
        catch (NoSuchAlgorithmException digest) {
            void e;
            FFDCFilter.processException((Throwable)digest, (String)"com.ibm.ws.security.audit.encryption.AuditKeyEncryptor", (String)"36", (Object)this, (Object[])new Object[]{password});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.audit.encryption.AuditKeyEncryptor", (String)"21", (Object)this);
        }
        this.des = new AuditCrypto();
    }

    public byte[] decrypt(byte[] encrKey) {
        return AuditCrypto.decrypt(encrKey, this.passwordDigestBytes);
    }

    public byte[] encrypt(byte[] key) {
        return AuditCrypto.encrypt(key, this.passwordDigestBytes);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.audit.encryption.AuditKeyEncryptor", AuditKeyEncryptor.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
    }
}

