/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.rest.handler.RESTRequest;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

public class RequestNLS {
    private static final ThreadLocal<RESTRequest> tlReq = new ThreadLocal();

    public static void setRESTRequest(RESTRequest request) {
        tlReq.set(request);
    }

    public static RESTRequest getRESTRequest() {
        return tlReq.get();
    }

    public static void clearThreadLocal() {
        tlReq.remove();
    }

    public static Locale getLocale(Enumeration<Locale> locales) {
        while (locales.hasMoreElements()) {
            Locale requestedLocale = locales.nextElement();
            if (requestedLocale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
                return requestedLocale;
            }
            Locale loadedLocale = ResourceBundle.getBundle("com.ibm.ws.ui.internal.resources.UIMessages", requestedLocale).getLocale();
            if (loadedLocale.toString().isEmpty() || !requestedLocale.toString().startsWith(loadedLocale.toString())) continue;
            return loadedLocale;
        }
        return Locale.getDefault();
    }

    public static Locale getLocale() {
        Locale l = Locale.getDefault();
        RESTRequest req = tlReq.get();
        if (req != null) {
            l = RequestNLS.getLocale(req.getLocales());
        }
        return l;
    }

    public static final String formatMessage(TraceComponent tc, String msgKey, Object ... objs) {
        RESTRequest req = RequestNLS.getRESTRequest();
        if (req != null) {
            return Tr.formatMessage((TraceComponent)tc, (Enumeration)req.getLocales(), (String)msgKey, (Object[])objs);
        }
        return Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])objs);
    }
}

