/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannelProvider;
import io.grpc.ManagedChannelRegistry;
import io.openliberty.grpc.client.monitor.GrpcMonitoringClientInterceptorService;
import io.openliberty.grpc.internal.client.GrpcSSLService;
import io.openliberty.grpc.internal.client.LibertyManagedChannelProvider;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ApplicationStateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class GrpcClientComponent
implements ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(GrpcClientComponent.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.client.resources.grpcclientmessages");
    private final String FEATUREPROVISIONER_REFERENCE_NAME = "featureProvisioner";
    private final String GRPC_SSL_SERVICE_NAME = "GrpcSSLService";
    private final String GRPC_MONITOR_NAME = "GrpcMonitoringClientInterceptorService";
    private final AtomicServiceReference<FeatureProvisioner> featureProvisioner = new AtomicServiceReference("featureProvisioner");
    private static GrpcSSLService sslService = null;
    private static GrpcMonitoringClientInterceptorService monitorService = null;
    private ManagedChannelProvider provider = null;

    @Activate
    protected void activate(ComponentContext cc) {
        this.provider = new LibertyManagedChannelProvider();
        ManagedChannelRegistry.getDefaultRegistry().register(this.provider);
        this.featureProvisioner.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        ManagedChannelRegistry.getDefaultRegistry().deregister(this.provider);
        this.provider = null;
        this.featureProvisioner.deactivate(cc);
    }

    @Reference(name="featureProvisioner", service=FeatureProvisioner.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setFeatureProvisioner(ServiceReference<FeatureProvisioner> ref) {
        this.featureProvisioner.setReference(ref);
    }

    protected void unsetFeatureProvisioner(ServiceReference<FeatureProvisioner> ref) {
        this.featureProvisioner.unsetReference(ref);
    }

    @Reference(name="GRPC_SSL_SERVICE_NAME", service=GrpcSSLService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setGrpcSSLService(GrpcSSLService service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"registerGrpcSSLService", (Object[])new Object[0]);
        }
        sslService = service;
    }

    protected void unsetGrpcSSLService(GrpcSSLService service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"unregisterGrpcSSLService", (Object[])new Object[0]);
        }
        if (sslService == service) {
            sslService = null;
        }
    }

    @Reference(name="GRPC_MONITOR_NAME", service=GrpcMonitoringClientInterceptorService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setMonitoringService(GrpcMonitoringClientInterceptorService service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setMonitoringService", (Object[])new Object[0]);
        }
        monitorService = service;
    }

    protected void unsetMonitoringService(GrpcMonitoringClientInterceptorService service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"unsetMonitoringService", (Object[])new Object[0]);
        }
        if (monitorService == service) {
            monitorService = null;
        }
    }

    public static GrpcSSLService getGrpcSSLService() {
        return sslService;
    }

    public static ClientInterceptor getMonitoringClientInterceptor() {
        if (monitorService != null) {
            return monitorService.createInterceptor();
        }
        return null;
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
    }
}

