/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20Constants;
import com.ibm.websphere.crypto.InvalidPasswordEncodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EndpointUtils {
    private static TraceComponent tc = Tr.register(EndpointUtils.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static final String PBKDF2WithHmacSHA512 = "PBKDF2WithHmacSHA512";
    public static final String DEFAULT_HASH = "PBKDF2WithHmacSHA512";
    public static final String PLAIN = "plain";
    public static final String HASH = "hash";
    static final long serialVersionUID = 2677485352199670461L;

    public static boolean reachedTokenLimit(OAuth20Provider provider, HttpServletRequest request, String userName, String clientId) {
        long numtokens;
        long limit = provider.getClientTokenCacheSize();
        if (limit > 0L && (numtokens = (long)EndpointUtils.getTokensForUser(false, true, userName, clientId, provider).size()) >= limit) {
            Tr.error((TraceComponent)tc, (String)"security.oauth20.token.limit.error", (Object[])new Object[]{userName, clientId, limit});
            return true;
        }
        return false;
    }

    public static String getParameter(HttpServletRequest request, String param) {
        return request.getParameter(param);
    }

    public static Collection<OAuth20Token> getTokensForUser(boolean isAppPasswordRequest, boolean isTokenRequest, String userName, String clientId, OAuth20Provider provider) {
        String decUserName = userName;
        try {
            decUserName = URLDecoder.decode(userName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.web.EndpointUtils", (String)"74", null, (Object[])new Object[]{isAppPasswordRequest, isTokenRequest, userName, clientId, provider});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("raw user name: " + userName + " urlDecoded user name going to database: " + decUserName), (Object[])new Object[0]);
        }
        if (isTokenRequest) {
            Collection<OAuth20Token> tokens = provider.getTokenCache().getUserAndClientTokens(decUserName, clientId);
            return EndpointUtils.removeAppPasswordOrAppTokens(tokens);
        }
        String tokenType = isAppPasswordRequest ? "iamapppasswordstateid" : "iamapptokenstateid";
        return provider.getTokenCache().getMatchingTokens(decUserName, clientId, tokenType);
    }

    private static Collection<OAuth20Token> getTokensMatchingClientId(Collection<OAuth20Token> tokens, String clientId) {
        Iterator<OAuth20Token> it = tokens.iterator();
        HashSet<OAuth20Token> matchingTokens = new HashSet<OAuth20Token>();
        while (it.hasNext()) {
            OAuth20Token token = it.next();
            if (!clientId.equals(token.getClientId())) continue;
            matchingTokens.add(token);
        }
        return matchingTokens;
    }

    private static Collection<OAuth20Token> getTokensMatchingGrantType(Collection<OAuth20Token> tokens, String grantType) {
        Iterator<OAuth20Token> it = tokens.iterator();
        HashSet<OAuth20Token> matchingTokens = new HashSet<OAuth20Token>();
        while (it.hasNext()) {
            OAuth20Token token = it.next();
            if (!token.getGrantType().equals(grantType)) continue;
            matchingTokens.add(token);
        }
        return matchingTokens;
    }

    private static Collection<OAuth20Token> removeAppPasswordOrAppTokens(Collection<OAuth20Token> tokens) {
        HashSet<OAuth20Token> matchingTokens = new HashSet<OAuth20Token>();
        if (tokens != null) {
            Iterator<OAuth20Token> it = tokens.iterator();
            String appPasswdGrantType = "app_password";
            String appTokenGrantType = "app_token";
            while (it.hasNext()) {
                OAuth20Token token = it.next();
                if (token.getGrantType().equals(appPasswdGrantType) || token.getGrantType().equals(appTokenGrantType)) continue;
                matchingTokens.add(token);
            }
        }
        return matchingTokens;
    }

    @FFDCIgnore(value={InvalidPasswordEncodingException.class, UnsupportedCryptoAlgorithmException.class})
    public static String computeTokenHash(OAuth20Token entry, @Sensitive String lookupKeyParam, String grantType) {
        String lookupKey = lookupKeyParam;
        String gt = null;
        if (entry != null) {
            gt = entry.getGrantType();
        } else if (grantType != null) {
            gt = grantType;
        }
        if ("app_password".equals(gt) || "app_token".equals(gt)) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("option.notrim", "true");
            properties.put("hash.salt", OAuth20Constants.APP_PASSWORD_HASH_SALT);
            try {
                lookupKey = PasswordUtil.encode((String)lookupKeyParam, (String)HASH, properties);
            }
            catch (InvalidPasswordEncodingException invalidPasswordEncodingException) {
            }
            catch (UnsupportedCryptoAlgorithmException unsupportedCryptoAlgorithmException) {
                // empty catch block
            }
        }
        return lookupKey;
    }

    @Trivial
    public static String computeTokenHash(String lookupKeyParam) {
        return EndpointUtils.computeTokenHash(lookupKeyParam, null);
    }

    @FFDCIgnore(value={InvalidPasswordEncodingException.class, UnsupportedCryptoAlgorithmException.class})
    public static String computeTokenHash(String lookupKeyParam, String algorithm) {
        String lookupKey = lookupKeyParam;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("option.notrim", "true");
        properties.put("hash.salt", OAuth20Constants.APP_PASSWORD_HASH_SALT);
        properties.put("hash.algorithm", algorithm == null ? "PBKDF2WithHmacSHA512" : algorithm);
        try {
            lookupKey = PasswordUtil.encode((String)lookupKeyParam, (String)HASH, properties);
        }
        catch (InvalidPasswordEncodingException invalidPasswordEncodingException) {
        }
        catch (UnsupportedCryptoAlgorithmException unsupportedCryptoAlgorithmException) {
            // empty catch block
        }
        return lookupKey;
    }

    public static String escapeQuotesForJson(String in) {
        String quot = "\"";
        String bsh = "\\";
        if (!in.contains(quot)) {
            return in;
        }
        String prev = "";
        String next = "";
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            prev = next;
            next = in.substring(i, i + 1);
            if (next.equals(quot) && !prev.equals(bsh)) {
                out.append(bsh).append(next);
                continue;
            }
            out.append(next);
        }
        return out.toString();
    }
}

