/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.platform.PlatformServiceFactory;
import com.ibm.ws.security.oauth20.util.BoundedCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class DynaCacheUtils {
    private static TraceComponent tc = Tr.register(DynaCacheUtils.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    protected static final HashMap<String, Map> dynaCaches = new HashMap();
    protected static final HashMap<String, Map> serverCaches = new HashMap();
    static final long serialVersionUID = -6961305302882744627L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public DynaCacheUtils() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public static <K, V> Map<K, V> getDynamicCache(String jndiName, K[] arg0, V[] arg1) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDynamicCache");
        }
        Map result = null;
        result = dynaCaches.get(jndiName);
        if (result == null) {
            result = serverCaches.get(jndiName);
        }
        if (result == null && PlatformServiceFactory.getPlatformService().isDistributedCapable() && (result = PlatformServiceFactory.getPlatformService().getDistributedMap(jndiName, arg0, arg1)) != null) {
            dynaCaches.put(jndiName, result);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found dynacache for: " + jndiName));
            }
        }
        if (result == null) {
            result = Collections.synchronizedMap(new BoundedCache());
            serverCaches.put(jndiName, result);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No dynacache, generated BoundCache for:" + jndiName));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDynamicCache");
        }
        return result;
    }
}

