/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.mediator.impl;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.audit.OAuthAuditHandler;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MediatorException;
import com.ibm.oauth.core.api.oauth20.mediator.OAuth20Mediator;
import com.ibm.oauth.core.internal.audit.OAuthAuditEntryImpl;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OAuthAuditHandlerMediator
implements OAuth20Mediator {
    static final String CLASS = OAuthAuditHandlerMediator.class.getName();
    static final Logger _log = Logger.getLogger(CLASS);
    private OAuthAuditHandler _auditHandler;

    public OAuthAuditHandlerMediator(OAuthAuditHandler auditHandler) {
        this._auditHandler = auditHandler;
    }

    @Override
    public void init(OAuthComponentConfiguration config) {
        this._auditHandler.init(config);
    }

    @Override
    public void mediateAuthorize(AttributeList attributeList) throws OAuth20MediatorException {
        OAuthAuditEntryImpl entry = new OAuthAuditEntryImpl(attributeList);
        try {
            this._auditHandler.writeEntry(entry);
        }
        catch (OAuthException e) {
            _log.log(Level.SEVERE, "Fails to write audit entry", e);
        }
    }

    @Override
    public void mediateToken(AttributeList attributeList) throws OAuth20MediatorException {
        OAuthAuditEntryImpl entry = new OAuthAuditEntryImpl(attributeList);
        try {
            this._auditHandler.writeEntry(entry);
        }
        catch (OAuthException e) {
            _log.log(Level.SEVERE, "Fails to write audit entry", e);
        }
    }

    @Override
    public void mediateResource(AttributeList attributeList) throws OAuth20MediatorException {
        OAuthAuditEntryImpl entry = new OAuthAuditEntryImpl(attributeList);
        try {
            this._auditHandler.writeEntry(entry);
        }
        catch (OAuthException e) {
            _log.log(Level.SEVERE, "Fails to write audit entry", e);
        }
    }

    @Override
    public void mediateAuthorizeException(AttributeList attributeList, OAuthException exception) throws OAuth20MediatorException {
        OAuthAuditEntryImpl entry = new OAuthAuditEntryImpl(attributeList, exception);
        try {
            this._auditHandler.writeEntry(entry);
        }
        catch (OAuthException e) {
            _log.log(Level.SEVERE, "Fails to write audit entry", e);
        }
    }

    @Override
    public void mediateTokenException(AttributeList attributeList, OAuthException exception) throws OAuth20MediatorException {
        OAuthAuditEntryImpl entry = new OAuthAuditEntryImpl(attributeList, exception);
        try {
            this._auditHandler.writeEntry(entry);
        }
        catch (OAuthException e) {
            _log.log(Level.SEVERE, "Fails to write audit entry", e);
        }
    }

    @Override
    public void mediateResourceException(AttributeList attributeList, OAuthException exception) throws OAuth20MediatorException {
        OAuthAuditEntryImpl entry = new OAuthAuditEntryImpl(attributeList, exception);
        try {
            this._auditHandler.writeEntry(entry);
        }
        catch (OAuthException e) {
            _log.log(Level.SEVERE, "Fails to write audit entry", e);
        }
    }
}

