/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.exceptions.TokenRequestException;
import io.openliberty.security.oidcclientcore.token.JakartaOidcTokenRequest;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TokenRefresher {
    private HttpServletRequest request = null;
    private OidcClientConfig oidcClientConfig = null;
    private Boolean accessTokenExpired = null;
    private Boolean idTokenExpired = null;
    private String refreshTokenString = null;
    static final long serialVersionUID = 7424022330515395727L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TokenRefresher(HttpServletRequest request, OidcClientConfig oidcClientConfig, boolean accessTokenExpired, boolean idTokenExpired, String refreshTokenString) {
        this.request = request;
        this.oidcClientConfig = oidcClientConfig;
        this.accessTokenExpired = accessTokenExpired;
        this.idTokenExpired = idTokenExpired;
        this.refreshTokenString = refreshTokenString;
    }

    public boolean isTokenExpired() {
        return this.isAccessTokenExpired() || this.isIdTokenExpired();
    }

    public boolean isAccessTokenExpired() {
        return this.accessTokenExpired;
    }

    public boolean isIdTokenExpired() {
        return this.idTokenExpired;
    }

    public ProviderAuthenticationResult refreshToken() {
        ProviderAuthenticationResult authResult;
        JakartaOidcTokenRequest tokenRequest = new JakartaOidcTokenRequest(this.oidcClientConfig, this.request);
        try {
            authResult = tokenRequest.sendTokenRefreshRequest(this.refreshTokenString);
        }
        catch (TokenRequestException tokenRequestException) {
            FFDCFilter.processException((Throwable)tokenRequestException, (String)"io.openliberty.security.oidcclientcore.token.TokenRefresher", (String)"61", (Object)this, (Object[])new Object[0]);
            authResult = new ProviderAuthenticationResult(AuthResult.FAILURE, 401);
        }
        return authResult;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.oidcclientcore.token.TokenRefresher", TokenRefresher.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    }
}

