/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.authentication;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import io.openliberty.security.oidcclientcore.authentication.AbstractFlow;
import io.openliberty.security.oidcclientcore.authentication.JakartaOidcAuthenticationResponseValidator;
import io.openliberty.security.oidcclientcore.authentication.JakartaOidcAuthorizationRequest;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.exceptions.AuthenticationResponseException;
import io.openliberty.security.oidcclientcore.exceptions.TokenRequestException;
import io.openliberty.security.oidcclientcore.storage.OidcStorageUtils;
import io.openliberty.security.oidcclientcore.storage.Storage;
import io.openliberty.security.oidcclientcore.storage.StorageFactory;
import io.openliberty.security.oidcclientcore.token.JakartaOidcTokenRequest;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthorizationCodeFlow
extends AbstractFlow {
    public static final TraceComponent tc = Tr.register(AuthorizationCodeFlow.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    private final OidcClientConfig oidcClientConfig;
    static final long serialVersionUID = 3696283316817350599L;

    public AuthorizationCodeFlow(OidcClientConfig oidcClientConfig) {
        this.oidcClientConfig = oidcClientConfig;
    }

    @Override
    public ProviderAuthenticationResult startFlow(HttpServletRequest request, HttpServletResponse response) {
        JakartaOidcAuthorizationRequest authzRequest = new JakartaOidcAuthorizationRequest(request, response, this.oidcClientConfig);
        return authzRequest.sendRequest();
    }

    @Override
    public ProviderAuthenticationResult continueFlow(HttpServletRequest request, HttpServletResponse response) throws AuthenticationResponseException, TokenRequestException {
        JakartaOidcAuthenticationResponseValidator responseValidator = new JakartaOidcAuthenticationResponseValidator(request, response, this.oidcClientConfig);
        responseValidator.validateResponse();
        String state = request.getParameter("state");
        Storage storage = StorageFactory.instantiateStorage(request, response, this.oidcClientConfig.isUseSession());
        String originalRequestUrl = this.getOriginalRequestUrlWithoutQueryParams(storage, state);
        if (this.shouldRedirectToOriginalResource(request, originalRequestUrl)) {
            return this.getRedirectToOriginalResourceResult(request, originalRequestUrl);
        }
        this.removeStoredState(storage, state);
        JakartaOidcTokenRequest tokenRequest = new JakartaOidcTokenRequest(this.oidcClientConfig, request);
        return tokenRequest.sendRequest();
    }

    private String getOriginalRequestUrlWithoutQueryParams(Storage storage, String state) {
        String originalRequestUrl = storage.get(OidcStorageUtils.getOriginalReqUrlStorageKey(state));
        if (originalRequestUrl == null) {
            return null;
        }
        return originalRequestUrl.split(Pattern.quote("?"))[0];
    }

    private boolean shouldRedirectToOriginalResource(HttpServletRequest request, String originalRequestUrl) {
        String currentRequestUrl = request.getRequestURL().toString();
        return this.oidcClientConfig.isRedirectToOriginalResource() && !currentRequestUrl.equals(originalRequestUrl);
    }

    private ProviderAuthenticationResult getRedirectToOriginalResourceResult(HttpServletRequest request, String originalRequestUrl) {
        String redirectUrl = this.appendCodeAndStateParams(originalRequestUrl, request);
        return new ProviderAuthenticationResult(AuthResult.REDIRECT, 302, null, null, null, redirectUrl);
    }

    private String appendCodeAndStateParams(String originalRequestUrl, HttpServletRequest request) {
        originalRequestUrl = originalRequestUrl + "?code=" + request.getParameter("code");
        originalRequestUrl = originalRequestUrl + "&state=" + request.getParameter("state");
        return originalRequestUrl;
    }

    private void removeStoredState(Storage storage, String state) {
        storage.remove(OidcStorageUtils.getStateStorageKey(state));
    }
}

