/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client.internal.proxy;

import io.narayana.lra.client.NarayanaLRAClient;
import io.narayana.lra.client.internal.proxy.InvalidLRAStateException;
import io.narayana.lra.client.internal.proxy.LRAProxyParticipant;
import io.narayana.lra.client.internal.proxy.ParticipantProxy;
import io.narayana.lra.proxy.logging.LRAProxyLogger;
import java.io.Serializable;
import java.net.URI;
import java.net.URLEncoder;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;

@ApplicationScoped
public class ProxyService {
    private static final String TIMELIMIT_PARAM_NAME = "TimeLimit";
    private static List<ParticipantProxy> participants;
    private Client lcClient;
    private WebTarget lcTarget;
    private UriBuilder uriBuilder;

    @PostConstruct
    void init() {
        if (participants == null) {
            participants = new ArrayList<ParticipantProxy>();
        }
        int httpPort = Integer.getInteger("thorntail.http.port", 8081);
        String httpHost = System.getProperty("thorntail.http.host", "localhost");
        this.uriBuilder = UriBuilder.fromPath((String)"lraproxy/{lra}/{pid}");
        this.uriBuilder.scheme("http").host(httpHost).port(httpPort);
        String lcHost = System.getProperty("lra.http.host", "localhost");
        int lcPort = Integer.getInteger(NarayanaLRAClient.LRA_COORDINATOR_PORT_KEY, 8080);
        String lcPath = System.getProperty(NarayanaLRAClient.LRA_COORDINATOR_PATH_KEY, "lra-coordinator");
        UriBuilder urib = UriBuilder.fromPath((String)lcPath).scheme("http").host(lcHost).port(lcPort);
        this.lcClient = ClientBuilder.newClient();
        this.lcTarget = this.lcClient.target(urib.build(new Object[0]));
    }

    @PreDestroy
    void fini() {
        if (this.lcClient != null) {
            this.lcClient.close();
            this.lcClient = null;
        }
    }

    private ParticipantProxy getProxy(URI lraId, String participantId) {
        int i = participants.indexOf(new ParticipantProxy(lraId, participantId));
        return i == -1 ? null : participants.get(i);
    }

    private ParticipantProxy recreateProxy(URI lraId, String participantId) {
        return new ParticipantProxy(lraId, participantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response notifyParticipant(URI lraId, String participantId, String participantData, boolean compensate) {
        LRAProxyParticipant participant;
        ParticipantProxy proxy = this.getProxy(lraId, participantId);
        if (proxy == null) {
            proxy = this.recreateProxy(lraId, participantId);
        }
        if ((participant = proxy.getParticipant()) == null && participantData != null && participantData.length() > 0) {
            participant = ProxyService.deserializeParticipant(lraId, participantData).orElse(null);
        }
        if (participant != null) {
            Future<Void> future = null;
            try {
                future = compensate ? participant.compensateWork(lraId) : participant.completeWork(lraId);
            }
            catch (Exception e) {
                Response response = Response.ok().entity((Object)(compensate ? ParticipantStatus.FailedToCompensate : ParticipantStatus.FailedToComplete)).build();
                return response;
            }
            finally {
                if (future == null) {
                    participants.remove(proxy);
                } else {
                    proxy.setFuture(future, compensate);
                }
            }
            if (future != null) {
                return Response.accepted().build();
            }
            return Response.ok().build();
        }
        LRAProxyLogger.logger.errorf("TODO recovery: null participant for callback %s", (Object)lraId.toASCIIString());
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    void notifyForget(URI lraId, String participantId) {
        ParticipantProxy proxy = this.getProxy(lraId, participantId);
        if (proxy != null) {
            participants.remove(proxy);
        }
    }

    ParticipantStatus getStatus(URI lraId, String participantId) throws InvalidLRAStateException {
        ParticipantProxy proxy = this.getProxy(lraId, participantId);
        if (proxy == null) {
            throw new NotFoundException();
        }
        Optional<ParticipantStatus> status = proxy.getStatus();
        return status.orElseThrow(InvalidLRAStateException::new);
    }

    public URI joinLRA(LRAProxyParticipant participant, URI lraId) {
        return this.joinLRA(participant, lraId, 0L, ChronoUnit.SECONDS);
    }

    public URI joinLRA(LRAProxyParticipant participant, URI lraId, Long timelimit, ChronoUnit unit) {
        ParticipantProxy proxy = new ParticipantProxy(lraId, UUID.randomUUID().toString(), participant);
        try {
            String pId = proxy.getParticipantId();
            String lra = URLEncoder.encode(lraId.toASCIIString(), "UTF-8");
            UriBuilder clone = this.uriBuilder.clone();
            URI participantUri = clone.build(new Object[]{lra, pId});
            Link link = Link.fromUri((URI)participantUri).rel("participant").type("text/plain").build(new Object[0]);
            Optional<String> participantData = ProxyService.serializeParticipant(participant);
            participants.add(proxy);
            Response response = this.lcTarget.path(lra).queryParam(TIMELIMIT_PARAM_NAME, new Object[]{timelimit}).request().header("Link", (Object)link.toString()).put(Entity.entity((Object)participantData.orElse(""), (String)"text/plain"));
            if (response.getStatus() == Response.Status.PRECONDITION_FAILED.getStatusCode()) {
                throw new WebApplicationException(Response.status((int)response.getStatus()).entity((Object)(lraId + ": Too late to join with this LRA")).build());
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new WebApplicationException(Response.status((int)response.getStatus()).entity((Object)(lraId + ": Unable to join with this LRA")).build());
            }
            return new URI((String)response.readEntity(String.class));
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.status((int)0).entity((Object)(lraId + ": Exception whilst joining with this LRA")).build());
        }
    }

    /*
     * Exception decompiling
     */
    private static Optional<String> serializeParticipant(Serializable object) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Optional<LRAProxyParticipant> deserializeParticipant(URI lraId, String objectAsString) {
        return Optional.empty();
    }
}

