/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.annotations.Tool;
import io.openliberty.mcp.internal.ToolMetadata;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ToolDescription {
    private final String name;
    private final String title;
    private final String description;
    private final InputSchemaObject inputSchema;
    private final AnnotationsDescription annotations;
    static final long serialVersionUID = 7262099877457117195L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public InputSchemaObject getInputSchema() {
        return this.inputSchema;
    }

    public AnnotationsDescription getAnnotations() {
        return this.annotations;
    }

    public ToolDescription(ToolMetadata toolMetadata) {
        this.name = toolMetadata.name();
        this.title = toolMetadata.title();
        this.description = toolMetadata.description();
        Tool.Annotations ann = toolMetadata.annotation().annotations();
        this.annotations = this.isDefaultAnnotation(ann) ? null : new AnnotationsDescription(!ann.readOnlyHint() ? null : Boolean.valueOf(ann.readOnlyHint()), ann.destructiveHint() ? null : Boolean.valueOf(ann.destructiveHint()), !ann.idempotentHint() ? null : Boolean.valueOf(ann.idempotentHint()), ann.openWorldHint() ? null : Boolean.valueOf(ann.openWorldHint()), ann.title().isEmpty() ? null : ann.title());
        Map<String, ToolMetadata.ArgumentMetadata> argumentMap = toolMetadata.arguments();
        HashMap<String, InputSchemaPrimitive> primitiveInputSchemaMap = new HashMap<String, InputSchemaPrimitive>();
        LinkedList<String> requiredParameterList = new LinkedList<String>();
        for (String argumentName : argumentMap.keySet()) {
            ToolMetadata.ArgumentMetadata argumentMetadata = argumentMap.get(argumentName);
            primitiveInputSchemaMap.put(argumentName, this.buildPrimitiveInputSchema(argumentMetadata));
            if (!argumentMetadata.required()) continue;
            requiredParameterList.add(argumentName);
        }
        this.inputSchema = new InputSchemaObject("object", primitiveInputSchemaMap, requiredParameterList);
    }

    private boolean isDefaultAnnotation(Tool.Annotations ann) {
        return !ann.readOnlyHint() && ann.destructiveHint() && !ann.idempotentHint() && ann.openWorldHint() && ann.title().isEmpty();
    }

    private InputSchemaPrimitive buildPrimitiveInputSchema(ToolMetadata.ArgumentMetadata argumentMetadata) {
        boolean isJsonNumber;
        Type type = argumentMetadata.type();
        String argumentDescription = argumentMetadata.description();
        if (argumentDescription.equals("")) {
            argumentDescription = null;
        }
        boolean bl = isJsonNumber = type.equals(Long.TYPE) || type.equals(Double.TYPE) || type.equals(Byte.TYPE) || type.equals(Float.TYPE) || type.equals(Short.TYPE) || type.equals(Long.class) || type.equals(Double.class) || type.equals(Byte.class) || type.equals(Float.class) || type.equals(Short.class);
        InputSchemaPrimitive tempSchemaPrimitive = isJsonNumber ? new InputSchemaPrimitive("number", argumentDescription) : (type.equals(String.class) || type.equals(Character.class) || type.equals(Character.TYPE) ? new InputSchemaPrimitive("string", argumentDescription) : (type.equals(Integer.TYPE) || type.equals(Integer.class) ? new InputSchemaPrimitive("integer", argumentDescription) : (type.equals(Boolean.TYPE) || type.equals(Boolean.class) ? new InputSchemaPrimitive("boolean", argumentDescription) : new InputSchemaPrimitive(type.getTypeName(), argumentDescription))));
        return tempSchemaPrimitive;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.ToolDescription", ToolDescription.class, (String)"MCP", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record InputSchemaObject(String type, Map<String, InputSchemaPrimitive> properties, List<String> required) {
        static final long serialVersionUID = -4211361063233746932L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.ToolDescription$InputSchemaObject", InputSchemaObject.class, (String)"MCP", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record AnnotationsDescription(Boolean readOnlyHint, Boolean destructiveHint, Boolean idempotentHint, Boolean openWorldHint, String title) {
        static final long serialVersionUID = -3171406478670378303L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.ToolDescription$AnnotationsDescription", AnnotationsDescription.class, (String)"MCP", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record InputSchemaPrimitive(String type, String description) {
        static final long serialVersionUID = 903499640048298841L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.ToolDescription$InputSchemaPrimitive", InputSchemaPrimitive.class, (String)"MCP", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record InputSchema(List<InputSchemaObject> objs, List<InputSchemaPrimitive> primitives) {
        static final long serialVersionUID = 1075111327297057871L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.ToolDescription$InputSchema", InputSchema.class, (String)"MCP", null);
        }
    }
}

