/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.content.Content;
import io.openliberty.mcp.internal.Capabilities;
import io.openliberty.mcp.internal.HeaderValidation;
import io.openliberty.mcp.internal.McpConnectionTracker;
import io.openliberty.mcp.internal.McpProtocolVersion;
import io.openliberty.mcp.internal.McpSession;
import io.openliberty.mcp.internal.McpSessionStore;
import io.openliberty.mcp.internal.McpTransport;
import io.openliberty.mcp.internal.RequestMethod;
import io.openliberty.mcp.internal.ToolDescription;
import io.openliberty.mcp.internal.ToolMetadata;
import io.openliberty.mcp.internal.ToolRegistry;
import io.openliberty.mcp.internal.ToolResult;
import io.openliberty.mcp.internal.exceptions.jsonrpc.HttpResponseException;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCErrorCode;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCException;
import io.openliberty.mcp.internal.requests.CancellationImpl;
import io.openliberty.mcp.internal.requests.ExecutionRequestId;
import io.openliberty.mcp.internal.requests.McpInitializeParams;
import io.openliberty.mcp.internal.requests.McpNotificationParams;
import io.openliberty.mcp.internal.requests.McpRequestId;
import io.openliberty.mcp.internal.requests.McpToolCallParams;
import io.openliberty.mcp.internal.responses.McpInitializeResult;
import io.openliberty.mcp.messaging.Cancellation;
import io.openliberty.mcp.tools.ToolCallException;
import io.openliberty.mcp.tools.ToolResponse;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(McpServlet.class, (String)"MCP", null);
    private Jsonb jsonb;
    @Inject
    BeanManager bm;
    @Inject
    McpConnectionTracker connectionTracker;
    @Inject
    McpSessionStore sessionStore;
    @Inject
    McpConnectionTracker connection;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.jsonb = JsonbBuilder.create();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        McpTransport transport = new McpTransport(req, resp, this.jsonb);
        String accept = req.getHeader("Accept");
        if (accept != null && HeaderValidation.acceptContains(accept, "text/event-stream")) {
            HttpResponseException e = new HttpResponseException(405, "GET not supported yet. SSE not implemented.").withHeader("Allow", "POST");
            transport.sendHttpException(e);
        } else {
            HttpResponseException e = new HttpResponseException(405, "GET method not allowed.").withHeader("Allow", "POST");
            transport.sendHttpException(e);
        }
    }

    @FFDCIgnore(value={JSONRPCException.class, HttpResponseException.class})
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, JSONRPCException {
        McpTransport transport = new McpTransport(req, resp, this.jsonb);
        try {
            McpSession session;
            transport.init(this.sessionStore);
            RequestMethod method = transport.getMcpRequest().getRequestMethod();
            if (method != RequestMethod.INITIALIZE && method != RequestMethod.PING && (session = transport.getSession()) == null) {
                throw new HttpResponseException(400, "Missing Mcp-Session-Id header");
            }
            this.callRequest(transport);
        }
        catch (JSONRPCException e) {
            transport.sendJsonRpcException(e);
        }
        catch (HttpResponseException e) {
            transport.sendHttpException(e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"io.openliberty.mcp.internal.McpServlet", (String)"119", (Object)((Object)this), (Object[])new Object[]{req, resp});
            transport.sendError(e);
        }
    }

    protected void callRequest(McpTransport transport) throws JSONRPCException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        RequestMethod method = transport.getMcpRequest().getRequestMethod();
        switch (method) {
            case TOOLS_CALL: {
                this.callTool(transport);
                break;
            }
            case TOOLS_LIST: {
                this.listTools(transport);
                break;
            }
            case INITIALIZE: {
                this.initialize(transport);
                break;
            }
            case INITIALIZED: {
                this.initialized(transport);
                break;
            }
            case PING: {
                this.ping(transport);
                break;
            }
            case CANCELLED: {
                this.cancelRequest(transport);
                break;
            }
            default: {
                throw new JSONRPCException(JSONRPCErrorCode.METHOD_NOT_FOUND, List.of(String.valueOf(String.valueOf((Object)method) + " not found")));
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String sessionId = req.getHeader("Mcp-Session-Id");
        if (sessionId == null) {
            resp.sendError(400, "Missing Mcp-Session-Id");
            return;
        }
        if (this.sessionStore.isValid(sessionId)) {
            McpSession session = this.sessionStore.getSession(sessionId);
            if (session != null) {
                this.connectionTracker.cancelSessionRequests(session);
            }
            resp.setStatus(200);
        } else {
            resp.sendError(404, "Session not found");
        }
    }

    /*
     * Exception decompiling
     */
    @FFDCIgnore(value={JSONRPCException.class, InvocationTargetException.class, IllegalAccessException.class, IllegalArgumentException.class})
    private void callTool(McpTransport transport) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isBusinessException(Throwable t, McpToolCallParams params) {
        if (t instanceof ToolCallException) {
            return true;
        }
        if (params != null && params.getMetadata() != null) {
            for (Class<? extends Throwable> clazz : params.getMetadata().businessExceptions()) {
                if (!clazz.isAssignableFrom(t.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    private ToolResponse toErrorResponse(Throwable t) {
        String msg = t.getMessage() != null ? t.getMessage() : t.getClass().getSimpleName();
        return ToolResponse.error((String)msg);
    }

    private void addSpecialArguments(Object[] argumentsArray, ExecutionRequestId requestId, ToolMetadata toolMetadata) {
        for (ToolMetadata.SpecialArgumentMetadata argMetadata : toolMetadata.specialArguments()) {
            switch (argMetadata.typeResolution().specialArgsType()) {
                case CANCELLATION: {
                    CancellationImpl cancellation = new CancellationImpl();
                    cancellation.setRequestId(requestId);
                    this.connection.registerOngoingRequest(requestId, cancellation);
                    argumentsArray[argMetadata.index()] = cancellation;
                    break;
                }
            }
        }
    }

    private void listTools(McpTransport transport) throws IOException {
        ToolRegistry toolRegistry = ToolRegistry.get();
        LinkedList<ToolDescription> response = new LinkedList<ToolDescription>();
        if (toolRegistry.hasTools()) {
            for (ToolMetadata tmd : toolRegistry.getAllTools()) {
                response.add(new ToolDescription(tmd));
            }
            ToolResult toolResult = new ToolResult(response);
            transport.sendResponse(toolResult);
        }
    }

    @FFDCIgnore(value={NoSuchElementException.class})
    private void initialize(McpTransport transport) throws IOException {
        McpProtocolVersion version;
        McpInitializeParams params = transport.getParams(McpInitializeParams.class);
        try {
            version = McpProtocolVersion.parse(params.getProtocolVersion());
        }
        catch (NoSuchElementException e) {
            version = McpProtocolVersion.V_2025_06_18;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)((Object)this), (TraceComponent)tc, (String)("Client initializing: " + String.valueOf(params.getClientInfo())), (Object[])new Object[]{params.getCapabilities()});
        }
        String sessionId = this.sessionStore.createSession();
        Capabilities.ServerCapabilities caps = Capabilities.ServerCapabilities.of(new Capabilities.Tools(false));
        McpInitializeResult.ServerInfo info = new McpInitializeResult.ServerInfo("test-server", "Test Server", "0.1");
        McpInitializeResult result = new McpInitializeResult(version, caps, info, null);
        transport.setResponseHeader("Mcp-Session-Id", sessionId);
        transport.sendResponse(result);
    }

    private void initialized(McpTransport transport) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Client initialized", (Object[])new Object[0]);
        }
        transport.sendEmptyResponse();
    }

    private void ping(McpTransport transport) {
        transport.sendResponse(new Object());
    }

    private void cancelRequest(McpTransport transport) {
        Cancellation cancellation;
        McpNotificationParams notificationParams = transport.getMcpRequest().getParams(McpNotificationParams.class, this.jsonb);
        McpRequestId mcpRedId = notificationParams.getRequestId();
        ExecutionRequestId requestId = new ExecutionRequestId(mcpRedId, transport.getSessionId());
        Optional<String> reason = Optional.ofNullable(notificationParams.getReason());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)((Object)this), (TraceComponent)tc, (String)("Cancellation requested for " + String.valueOf(requestId)), (Object[])new Object[0]);
        }
        if ((cancellation = this.connection.getOngoingRequestCancellation(requestId)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Cancelling task", (Object[])new Object[0]);
            }
            ((CancellationImpl)cancellation).cancel(reason);
        }
        transport.sendEmptyResponse();
    }

    private ExecutionRequestId createOngoingRequestId(McpTransport transport) {
        return new ExecutionRequestId(transport.getMcpRequest().id(), transport.getSessionId());
    }

    private static /* synthetic */ boolean lambda$callTool$0(Object item) {
        return item instanceof Content;
    }
}

