/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.challenge;

import jakarta.annotation.ParametersAreNonnullByDefault;
import java.security.PublicKey;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.challenge.Challenge;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.toolbox.JoseUtils;

@ParametersAreNonnullByDefault
public class TokenChallenge
extends Challenge {
    private static final long serialVersionUID = 1634133407432681800L;
    protected static final String KEY_TOKEN = "token";

    public TokenChallenge(Login login, JSON data) {
        super(login, data);
    }

    protected String getToken() {
        String token = this.getJSON().get(KEY_TOKEN).asString();
        if (!AcmeUtils.isValidBase64Url(token)) {
            throw new AcmeProtocolException("Invalid token: " + token);
        }
        return token;
    }

    public String getAuthorization() {
        PublicKey pk = this.getLogin().getKeyPair().getPublic();
        return this.getToken() + '.' + AcmeUtils.base64UrlEncode(JoseUtils.thumbprint(pk));
    }
}

