/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.bootstrap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.ExceptionLogger;
import org.apache.http.impl.nio.DefaultHttpServerIODispatch;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.impl.nio.bootstrap.HttpServer;
import org.apache.http.impl.nio.bootstrap.ThreadFactoryImpl;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.ListenerEndpoint;

public class HttpServer {
    private final int port;
    private final InetAddress ifAddress;
    private final IOReactorConfig ioReactorConfig;
    private final NHttpServerEventHandler serverEventHandler;
    private final NHttpConnectionFactory<? extends DefaultNHttpServerConnection> connectionFactory;
    private final ExceptionLogger exceptionLogger;
    private final ExecutorService listenerExecutorService;
    private final ThreadGroup dispatchThreads;
    private final AtomicReference<Status> status;
    private final DefaultListeningIOReactor ioReactor;
    private volatile ListenerEndpoint endpoint;

    HttpServer(int port, InetAddress ifAddress, IOReactorConfig ioReactorConfig, NHttpServerEventHandler serverEventHandler, NHttpConnectionFactory<? extends DefaultNHttpServerConnection> connectionFactory, ExceptionLogger exceptionLogger) {
        this.port = port;
        this.ifAddress = ifAddress;
        this.ioReactorConfig = ioReactorConfig;
        this.serverEventHandler = serverEventHandler;
        this.connectionFactory = connectionFactory;
        this.exceptionLogger = exceptionLogger;
        this.listenerExecutorService = Executors.newSingleThreadExecutor((ThreadFactory)new ThreadFactoryImpl("HTTP-listener-" + this.port));
        this.dispatchThreads = new ThreadGroup("I/O-dispatchers");
        try {
            this.ioReactor = new DefaultListeningIOReactor(this.ioReactorConfig, (ThreadFactory)new ThreadFactoryImpl("I/O-dispatch", this.dispatchThreads));
        }
        catch (IOReactorException ex) {
            throw new IllegalStateException(ex);
        }
        this.ioReactor.setExceptionHandler((IOReactorExceptionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.status = new AtomicReference<Status>(Status.READY);
    }

    public ListenerEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void start() throws IOException {
        if (this.status.compareAndSet(Status.READY, Status.ACTIVE)) {
            this.endpoint = this.ioReactor.listen((SocketAddress)new InetSocketAddress(this.ifAddress, this.port > 0 ? this.port : 0));
            DefaultHttpServerIODispatch ioEventDispatch = new DefaultHttpServerIODispatch(this.serverEventHandler, this.connectionFactory);
            this.listenerExecutorService.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.listenerExecutorService.awaitTermination(timeout, timeUnit);
    }

    public void shutdown(long gracePeriod, TimeUnit timeUnit) {
        if (this.status.compareAndSet(Status.ACTIVE, Status.STOPPING)) {
            try {
                this.ioReactor.shutdown(timeUnit.toMillis(gracePeriod));
            }
            catch (IOException ex) {
                this.exceptionLogger.log((Exception)ex);
            }
            this.listenerExecutorService.shutdown();
        }
    }

    static /* synthetic */ DefaultListeningIOReactor access$000(HttpServer x0) {
        return x0.ioReactor;
    }

    static /* synthetic */ ExceptionLogger access$100(HttpServer x0) {
        return x0.exceptionLogger;
    }
}

