/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra;

import io.narayana.lra.LRAHttpClient;
import io.narayana.lra.ResponseHolder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.WebApplicationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HTTP;

public class RequestBuilder {
    private HttpRequestBase httpRequest;
    private ArrayList<String> paths;
    private URIBuilder builder;
    private boolean async;
    private long timeout;
    private TimeUnit timeUnit;

    public RequestBuilder(URI baseURI) {
        try {
            this.builder = new URIBuilder(String.format("%s://%s", baseURI.getScheme(), baseURI.getAuthority()));
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException((Throwable)e);
        }
        this.paths = new ArrayList();
        Collections.addAll(this.paths, this.strip(baseURI.getPath()).split("/"));
    }

    private String strip(String path) {
        return path.replaceAll("^/+", "").replaceAll("/+$", "");
    }

    public RequestBuilder path(String path) {
        Collections.addAll(this.paths, this.strip(path).split("/"));
        return this;
    }

    public RequestBuilder queryParam(String name, long value) {
        this.builder.setParameter(name, Long.toString(value));
        return this;
    }

    public RequestBuilder queryParam(String name, String value) {
        this.builder.setParameter(name, value);
        return this;
    }

    public RequestBuilder queryParam(String name, boolean value) {
        this.builder.setParameter(name, Boolean.toString(value));
        return this;
    }

    public RequestBuilder request() {
        this.builder.setPathSegments((List)this.paths);
        this.httpRequest = new HttpGet();
        return this;
    }

    public RequestBuilder header(String name, String value) {
        this.httpRequest.addHeader(name, value);
        return this;
    }

    public RequestBuilder header(String name, URI value) {
        this.httpRequest.addHeader(name, value == null ? null : value.toASCIIString());
        return this;
    }

    public RequestBuilder async(long timeout, TimeUnit timeUnit) {
        this.async = true;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        return this;
    }

    private HttpRequestBase setContent(HttpEntityEnclosingRequestBase req, String content, String mediaType) {
        if (content != null) {
            if (!mediaType.equals("text/plain")) {
                throw new IllegalArgumentException("RequestBuilder: the only supported content type is " + mediaType);
            }
            req.setEntity((HttpEntity)new StringEntity(content, HTTP.DEF_CONTENT_CHARSET));
        }
        return req;
    }

    private URI build() {
        try {
            return this.builder.build();
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public ResponseHolder put() throws WebApplicationException {
        return this.send(this.setContent((HttpEntityEnclosingRequestBase)new HttpPut(this.build()), "", ContentType.TEXT_PLAIN.getMimeType()));
    }

    public ResponseHolder put(String content, String mediaType) throws WebApplicationException {
        return this.send(this.setContent((HttpEntityEnclosingRequestBase)new HttpPut(this.build()), content, mediaType));
    }

    public ResponseHolder post() throws WebApplicationException {
        return this.send(this.setContent((HttpEntityEnclosingRequestBase)new HttpPost(this.build()), "", ContentType.TEXT_PLAIN.getMimeType()));
    }

    public ResponseHolder get() throws WebApplicationException {
        try {
            return this.send((HttpRequestBase)new HttpGet(this.builder.build()));
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public ResponseHolder delete() throws WebApplicationException {
        try {
            return this.send((HttpRequestBase)new HttpDelete(this.builder.build()));
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private ResponseHolder send(HttpRequestBase req) throws WebApplicationException {
        for (Header header : this.httpRequest.getAllHeaders()) {
            req.addHeader(header);
        }
        LRAHttpClient httpClient = LRAHttpClient.getClient();
        try {
            return this.async ? httpClient.request(req, this.timeout, this.timeUnit) : httpClient.request(req);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

