/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.slot;

import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.slot.BackingSlots;
import com.arjuna.ats.internal.arjuna.objectstore.slot.SlotStoreEnvironmentBean;
import com.arjuna.ats.internal.arjuna.objectstore.slot.SlotStoreKey;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;

public class SlotStore {
    private final SlotStoreEnvironmentBean config;
    private final String storeDirCanonicalPath;
    public final ConcurrentHashMap<SlotStoreKey, Integer> slotIdIndex = new ConcurrentHashMap();
    public final Deque<Integer> freeList = new ConcurrentLinkedDeque();
    public final BackingSlots slots;

    public SlotStore(SlotStoreEnvironmentBean config) throws IOException {
        this.config = config;
        File storeDir = new File(config.getStoreDir());
        this.storeDirCanonicalPath = storeDir.getCanonicalPath();
        this.slots = config.getBackingSlots();
        this.slots.init(config);
        for (int i = 0; i < config.getNumberOfSlots(); ++i) {
            byte[] data = this.slots.read(i);
            if (data == null || data.length == 0) {
                this.freeList.add(i);
                continue;
            }
            InputBuffer inputBuffer = new InputBuffer(data);
            SlotStoreKey slotStoreKey = SlotStoreKey.unpackFrom((InputBuffer)inputBuffer);
            this.slotIdIndex.put(slotStoreKey, i);
        }
    }

    public String getStoreName() {
        return this.getClass().getSimpleName() + ":" + this.storeDirCanonicalPath;
    }

    public InputObjectState read(SlotStoreKey key) throws IOException {
        Integer slotId = (Integer)this.slotIdIndex.get(key);
        if (slotId == null) {
            throw new IOException("record not found for " + key);
        }
        byte[] data = this.slots.read(slotId.intValue());
        if (data == null) {
            throw new IOException("record not found for " + key);
        }
        InputBuffer inputBuffer = new InputBuffer(data);
        SlotStoreKey.unpackFrom((InputBuffer)inputBuffer);
        InputObjectState inputObjectState = new InputObjectState();
        inputObjectState.unpackFrom(inputBuffer);
        return inputObjectState;
    }

    public boolean remove(SlotStoreKey key) throws IOException {
        Integer slotId = (Integer)this.slotIdIndex.remove(key);
        if (slotId == null) {
            return false;
        }
        this.slots.clear(slotId.intValue(), this.config.isSyncDeletes());
        this.freeList.add(slotId);
        return true;
    }

    public boolean write(SlotStoreKey key, OutputObjectState outputObjectState) throws IOException {
        OutputBuffer record = new OutputBuffer();
        key.packInto(record);
        outputObjectState.packInto(record);
        byte[] data = record.buffer();
        if (data.length > this.config.getBytesPerSlot()) {
            throw new IOException("data too big for slot");
        }
        Integer slotId = (Integer)this.freeList.poll();
        if (slotId == null) {
            return false;
        }
        this.slots.write(slotId.intValue(), data, this.config.isSyncWrites());
        Integer previousSlot = this.slotIdIndex.put(key, slotId);
        if (previousSlot != null) {
            this.slots.clear(previousSlot.intValue(), this.config.isSyncWrites());
            this.freeList.add(previousSlot);
        }
        return true;
    }

    public boolean contains(SlotStoreKey key) {
        return this.slotIdIndex.containsKey(key);
    }

    public String[] getKnownTypes() {
        HashSet<String> types = new HashSet<String>();
        for (SlotStoreKey key : this.slotIdIndex.keySet()) {
            types.add(key.getTypeName());
        }
        return types.toArray(new String[0]);
    }

    public SlotStoreKey[] getMatchingKeys(SlotStoreKey templateKey) {
        ArrayList<SlotStoreKey> matchingKeys = new ArrayList<SlotStoreKey>();
        for (SlotStoreKey candidateKey : this.slotIdIndex.keySet()) {
            if (!candidateKey.getTypeName().equalsIgnoreCase(templateKey.getTypeName()) || templateKey.getStateStatus() != -1 && candidateKey.getStateStatus() != templateKey.getStateStatus()) continue;
            matchingKeys.add(candidateKey);
        }
        return matchingKeys.toArray(new SlotStoreKey[0]);
    }
}

