/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoHandler;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.impl.HandlerFactory;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EndpointServices {
    private static TraceComponent tc = Tr.register(EndpointServices.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlWab20Messages");
    public static final String KEY_SECURITY_SERVICE = "securityService";
    public static final String KEY_ID = "id";
    public static final String KEY_SAML_SERVICE = "samlService";
    private final ConcurrentServiceReferenceMap<String, SsoSamlService> samlServiceRef = new ConcurrentServiceReferenceMap("samlService");
    protected final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    static final long serialVersionUID = 2368018060324393578L;

    protected void setSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.setReference(reference);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected void setSamlService(ServiceReference<SsoSamlService> ref) {
        ConcurrentServiceReferenceMap<String, SsoSamlService> concurrentServiceReferenceMap = this.samlServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            this.samlServiceRef.putReference((Object)((String)ref.getProperty(KEY_ID)), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected void unsetSamlService(ServiceReference<SsoSamlService> ref) {
        ConcurrentServiceReferenceMap<String, SsoSamlService> concurrentServiceReferenceMap = this.samlServiceRef;
        synchronized (concurrentServiceReferenceMap) {
            this.samlServiceRef.removeReference((Object)((String)ref.getProperty(KEY_ID)), ref);
        }
    }

    protected void activate(ComponentContext cc) {
        this.securityServiceRef.activate(cc);
        this.samlServiceRef.activate(cc);
        Tr.info((TraceComponent)tc, (String)"SAML20_ENDPOINT_SERVICE_ACTIVATED", (Object[])new Object[0]);
    }

    protected void deactivate(ComponentContext cc) {
        this.securityServiceRef.deactivate(cc);
        this.samlServiceRef.deactivate(cc);
    }

    protected void handleSamlRequest(HttpServletRequest request, HttpServletResponse response) throws SamlException {
        SsoRequest samlRequest = (SsoRequest)request.getAttribute("Saml20Request");
        if (samlRequest != null) {
            this.handleSamlRequest(request, response, samlRequest);
        }
    }

    private void handleSamlRequest(HttpServletRequest request, HttpServletResponse response, SsoRequest samlRequest) throws SamlException {
        SsoConfig ssoConfig;
        SsoSamlService samlService = this.getSsoSamlService(response, samlRequest);
        if (samlService != null && (ssoConfig = samlService.getConfig()) != null) {
            String reqUrl = request.getRequestURL().toString();
            if (!this.checkHttpsRequirement(ssoConfig, reqUrl)) {
                throw new SamlException("SAML20_EP_PROTOCOL_NOT_HTTPS", null, new Object[]{reqUrl});
            }
            Map<String, Object> parameters = this.getParameterMap(samlService);
            SsoHandler samlHandler = HandlerFactory.getHandlerInstance((SsoRequest)samlRequest);
            samlHandler.handleRequest(request, response, samlRequest, parameters);
        }
    }

    boolean checkHttpsRequirement(SsoConfig ssoConfig, String urlStr) {
        boolean metHttpsRequirement = true;
        if (ssoConfig.isHttpsRequired() && urlStr != null && !urlStr.startsWith("https")) {
            metHttpsRequirement = false;
        }
        return metHttpsRequirement;
    }

    private Map<String, Object> getParameterMap(SsoSamlService samlService) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put(Constants.KEY_SAML_SERVICE, samlService);
        results.put(Constants.KEY_SECURITY_SERVICE, this.securityServiceRef.getService());
        return results;
    }

    private SsoSamlService getSsoSamlService(HttpServletResponse response, SsoRequest samlRequest) throws SamlException {
        SsoSamlService service = (SsoSamlService)this.samlServiceRef.getService((Object)samlRequest.getProviderName());
        if (service == null || !service.isEnabled()) {
            service = null;
            throw new SamlException("SAML20_NO_SUCH_ACS_PROVIDER", null, new Object[]{samlRequest.getProviderName()});
        }
        samlRequest.setSsoSamlService(service);
        return service;
    }
}

