/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.extension;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.SubscriberDecorator;
import io.smallrye.reactive.messaging.observation.MessageObservationCollector;
import io.smallrye.reactive.messaging.providers.extension.ObservationDecorator;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class OutgoingObservationDecorator
implements SubscriberDecorator {
    @Inject
    @ConfigProperty(name="smallrye.messaging.observation.enabled", defaultValue="true")
    boolean enabled;
    @Inject
    ChannelRegistry registry;
    @Inject
    Instance<MessageObservationCollector<?>> observationCollector;

    @Override
    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> multi, List<String> channelName, boolean isConnector) {
        String channel = channelName.isEmpty() ? null : channelName.get(0);
        boolean isEmitter = this.registry.getEmitterNames().contains(channel);
        if (this.observationCollector.isResolvable() && this.enabled && !isEmitter && isConnector) {
            return ObservationDecorator.decorateObservation((MessageObservationCollector)this.observationCollector.get(), multi, channel, false, false);
        }
        return multi;
    }
}

